/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;

public class RangeLogVersionVisitor
implements LogVersionVisitor {
    public static final long UNKNOWN = -1L;
    private long lowestVersion = -1L;
    private File lowestFile;
    private long highestVersion = -1L;
    private File highestFile;

    @Override
    public void visit(File file, long logVersion) {
        if (logVersion > this.highestVersion) {
            this.highestVersion = logVersion;
            this.highestFile = file;
        }
        if (this.lowestVersion == -1L || logVersion < this.lowestVersion) {
            this.lowestVersion = logVersion;
            this.lowestFile = file;
        }
    }

    public long getLowestVersion() {
        return this.lowestVersion;
    }

    public File getLowestFile() {
        return this.lowestFile;
    }

    public long getHighestVersion() {
        return this.highestVersion;
    }

    public File getHighestFile() {
        return this.highestFile;
    }
}

