/*
 * Copyright (c) 2002-2020 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.kernel.impl.transaction.log;

public class LogPosition implements Comparable<LogPosition>
{
    public static final LogPosition UNSPECIFIED = new LogPosition( -1, -1 )
    {
        @Override
        public long getLogVersion()
        {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getByteOffset()
        {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString()
        {
            return "UNSPECIFIED";
        }
    };

    private final long logVersion;
    private final long byteOffset;

    public LogPosition( long logVersion, long byteOffset )
    {
        this.logVersion = logVersion;
        this.byteOffset = byteOffset;
    }

    public long getLogVersion()
    {
        return logVersion;
    }

    public long getByteOffset()
    {
        return byteOffset;
    }

    @Override
    public String toString()
    {
        return "LogPosition{" +
                "logVersion=" + logVersion +
                ", byteOffset=" + byteOffset +
                '}';
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || getClass() != o.getClass() )
        {
            return false;
        }

        LogPosition that = (LogPosition) o;
        return byteOffset == that.byteOffset && logVersion == that.logVersion;
    }

    @Override
    public int hashCode()
    {
        int result = (int) (logVersion ^ (logVersion >>> 32));
        result = 31 * result + (int) (byteOffset ^ (byteOffset >>> 32));
        return result;
    }

    @Override
    public int compareTo( LogPosition o )
    {
        if ( logVersion != o.logVersion )
        {
            return Long.compare( logVersion, o.logVersion );
        }
        return Long.compare( byteOffset, o.byteOffset );
    }
}
