/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_0;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.util.Preconditions;

public class LogEntryVersion {
    public static final LogEntryVersion INSTANCE = new LogEntryVersion();
    public static final LogEntryParserSet LATEST = LogEntryParserSetV4_0.V4_0;
    private final ByteObjectHashMap<LogEntryParserSet> sets = new ByteObjectHashMap();

    private LogEntryVersion() {
        this.register(LogEntryParserSetV2_3.V2_3);
        this.register(LogEntryParserSetV4_0.V4_0);
    }

    private void register(LogEntryParserSet set) {
        byte version = set.version();
        Preconditions.checkState((!this.sets.containsKey(version) ? 1 : 0) != 0, (String)"Conflicting version %d", (Object[])new Object[]{version});
        this.sets.put(version, (Object)set);
    }

    public LogEntryParserSet select(byte version) {
        LogEntryParserSet set = (LogEntryParserSet)this.sets.get(version);
        if (set != null) {
            return set;
        }
        if (version > LATEST.version()) {
            throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the highest supported prefix is %d. This indicates that the log files originates from a newer version of neo4j.", version, LATEST.version()));
        }
        throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the lowest supported prefix is %d. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", version, this.sets.keySet().min()));
    }

    public static boolean moreRecentVersionExists(byte version) {
        return version < LATEST.version();
    }
}

