/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.ByteReversingReadableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v42.DetachedCheckpointLogEntryParserV4_2;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

class LogEntryParserSetV4_2
extends LogEntryParserSet {
    LogEntryParserSetV4_2() {
        this(KernelVersion.V4_2);
    }

    LogEntryParserSetV4_2(KernelVersion version) {
        super(version);
        this.register(new LogEntryParser(1){

            @Override
            public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                LogPosition position = marker.newPosition();
                long timeWritten = channel.getLong();
                long latestCommittedTxWhenStarted = channel.getLong();
                int previousChecksum = channel.getInt();
                int additionalHeaderLength = channel.getInt();
                byte[] additionalHeader = new byte[additionalHeaderLength];
                channel.get(additionalHeader, additionalHeaderLength);
                return new LogEntryStart(version, timeWritten, latestCommittedTxWhenStarted, previousChecksum, additionalHeader, position);
            }
        });
        this.register(new LogEntryParser(3){

            @Override
            public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                StorageCommand command = commandReaderFactory.get(version).read((ReadableChannel)channel);
                return command == null ? null : new LogEntryCommand(version, command);
            }
        });
        this.register(new LogEntryParser(5){

            @Override
            public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
                long txId = channel.getLong();
                long timeWritten = channel.getLong();
                int checksum = channel.endChecksumAndValidate();
                return new LogEntryCommit(version, txId, timeWritten, checksum);
            }
        });
        this.register(new DetachedCheckpointLogEntryParserV4_2());
    }

    @Override
    public ReadableChecksumChannel wrap(ReadableChecksumChannel channel) {
        return new ByteReversingReadableChecksumChannel(channel);
    }
}

