/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.util.Preconditions;

public enum LogFormat {
    V6(6, 16, KernelVersion.V2_3, KernelVersion.V2_3, -1, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        return new LogHeader(6, logVersion, previousCommittedTx, null, 16L, -1, -559063315, null);
    }, null),
    V7(7, 64, KernelVersion.V4_2, KernelVersion.V4_4, -1, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        return new LogHeader(7, logVersion, previousCommittedTx, null, 64L, -1, -559063315, null);
    }, null),
    V8(8, 128, KernelVersion.V5_0, KernelVersion.getLatestVersion((Config)Config.defaults()), -1, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
        buffer.position(128);
        return new LogHeader(8, logVersion, previousCommittedTx, storeId, 128L, -1, -559063315, null);
    }, (buffer, logHeader) -> {
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putLong(LogFormat.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion().getVersionByte()));
            buffer.putLong(logHeader.getLastCommittedTxId());
            StoreIdSerialization.serializeWithFixedSize((StoreId)logHeader.getStoreId(), (ByteBuffer)buffer);
            while (buffer.position() < 128) {
                buffer.put((byte)0);
            }
        }
        finally {
            buffer.order(originalOrder);
        }
    }),
    V9(9, 128, KernelVersion.GLORIOUS_FUTURE, KernelVersion.GLORIOUS_FUTURE, LogSegments.DEFAULT_LOG_SEGMENT_SIZE, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
        int segmentBlockSize = buffer.getInt();
        int previousChecksum = buffer.getInt();
        byte kernelVersion = buffer.get();
        buffer.position(128);
        return new LogHeader(9, logVersion, previousCommittedTx, storeId, 128L, segmentBlockSize, previousChecksum, KernelVersion.getForVersion((byte)kernelVersion));
    }, (buffer, logHeader) -> {
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putLong(LogFormat.encodeLogVersion(logHeader.getLogVersion(), logHeader.getLogFormatVersion().getVersionByte()));
            buffer.putLong(logHeader.getLastCommittedTxId());
            StoreIdSerialization.serializeWithFixedSize((StoreId)logHeader.getStoreId(), (ByteBuffer)buffer);
            buffer.putInt(logHeader.getSegmentBlockSize());
            buffer.putInt(logHeader.getPreviousLogFileChecksum());
            buffer.put(logHeader.getKernelVersion().version());
            while ((long)buffer.position() < logHeader.getStartPosition().getByteOffset()) {
                buffer.put((byte)0);
            }
        }
        finally {
            buffer.order(originalOrder);
        }
    });

    public static final int BIGGEST_HEADER;
    static final long LOG_VERSION_BITS = 56L;
    static final long LOG_VERSION_MASK = 0xFFFFFFFFFFFFFFL;
    private static final LogFormat[] BY_VERSION_BYTE;
    private static final EnumMap<KernelVersion, LogFormat> KERNEL_VERSION_TO_LOG_FORMAT;
    private final byte versionByte;
    private final int headerSize;
    private final KernelVersion fromKernelVersion;
    private final KernelVersion toKernelVersion;
    private final int defaultSegmentBlockSize;
    private final LogFormatHeaderParser headerParser;
    private final LogFormatHeaderWriter headerWriter;

    private LogFormat(byte versionByte, int headerSize, KernelVersion from, KernelVersion to, int defaultSegmentBlockSize, LogFormatHeaderParser headerParser, LogFormatHeaderWriter headerWriter) {
        this.versionByte = versionByte;
        this.headerSize = headerSize;
        this.fromKernelVersion = from;
        this.toKernelVersion = to;
        this.defaultSegmentBlockSize = defaultSegmentBlockSize;
        this.headerParser = headerParser;
        this.headerWriter = headerWriter;
    }

    public byte getVersionByte() {
        return this.versionByte;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getDefaultSegmentBlockSize() {
        return this.defaultSegmentBlockSize;
    }

    public LogFormatHeaderWriter getHeaderWriter() {
        return this.headerWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogHeader parseHeader(ByteBuffer buffer, boolean strict, Path sourceFile) throws IOException {
        if (buffer.remaining() == 0) {
            return null;
        }
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            if (LogFormat.checkUnderflow(buffer, 8, strict, sourceFile)) {
                LogHeader logHeader = null;
                return logHeader;
            }
            long encodedLogVersions = buffer.getLong();
            if (encodedLogVersions == 0L) {
                LogHeader logHeader = null;
                return logHeader;
            }
            byte logFormatVersion = LogFormat.decodeLogFormatVersion(encodedLogVersions);
            long logVersion = LogFormat.decodeLogVersion(encodedLogVersions);
            LogFormat logFormat = BY_VERSION_BYTE[logFormatVersion];
            if (logFormat == null) {
                throw new IOException("Unrecognized transaction log format version: " + logFormatVersion);
            }
            if (LogFormat.checkUnderflow(buffer, logFormat.headerSize - 8, strict, sourceFile)) {
                LogHeader logHeader = null;
                return logHeader;
            }
            LogHeader logHeader = logFormat.headerParser.parse(logVersion, buffer);
            return logHeader;
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    public static void writeLogHeader(StoreChannel channel, LogHeader logHeader, MemoryTracker memoryTracker) throws IOException {
        LogFormatHeaderWriter headerWriter = logHeader.getLogFormatVersion().headerWriter;
        if (headerWriter == null) {
            throw new UnsupportedOperationException("Cannot write log format " + logHeader.getLogFormatVersion());
        }
        int headerSize = (int)logHeader.getStartPosition().getByteOffset();
        try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(headerSize, ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            headerWriter.write(buffer, logHeader);
            buffer.position(headerSize);
            buffer.flip();
            channel.writeAll(buffer);
            channel.flush();
        }
    }

    private static void buildKernelToFormatMap() {
        LogFormat[] logFormats = LogFormat.values();
        Arrays.sort(logFormats, Comparator.comparingInt(LogFormat::getVersionByte));
        KernelVersion[] kernelVersions = KernelVersion.values();
        Arrays.sort(kernelVersions, Comparator.comparingInt(KernelVersion::version));
        int i = 0;
        for (KernelVersion kernelVersion : kernelVersions) {
            if (kernelVersion == KernelVersion.GLORIOUS_FUTURE) continue;
            while (kernelVersion.isGreaterThan(logFormats[i].toKernelVersion)) {
                ++i;
            }
            KERNEL_VERSION_TO_LOG_FORMAT.put(kernelVersion, logFormats[i]);
        }
        for (LogFormat logFormat : logFormats) {
            if (logFormat.toKernelVersion != KernelVersion.GLORIOUS_FUTURE) continue;
            KERNEL_VERSION_TO_LOG_FORMAT.put(KernelVersion.GLORIOUS_FUTURE, logFormat);
        }
    }

    public static LogFormat fromKernelVersion(KernelVersion kernelVersion) {
        return KERNEL_VERSION_TO_LOG_FORMAT.get(kernelVersion);
    }

    public static LogFormat fromByteVersion(byte versionByte) {
        LogFormat logFormat = BY_VERSION_BYTE[versionByte];
        Preconditions.checkArgument((logFormat != null ? 1 : 0) != 0, (String)"Unknown log format byte version: %d".formatted(versionByte));
        return logFormat;
    }

    private static boolean checkUnderflow(ByteBuffer buffer, int require, boolean strict, Path fileForAdditionalErrorInformationOrNull) throws IncompleteLogHeaderException {
        if (buffer.remaining() < require) {
            if (strict) {
                if (fileForAdditionalErrorInformationOrNull != null) {
                    throw new IncompleteLogHeaderException(fileForAdditionalErrorInformationOrNull, buffer.remaining(), require);
                }
                throw new IncompleteLogHeaderException(buffer.remaining(), require);
            }
            return true;
        }
        return false;
    }

    private static long decodeLogVersion(long encLogVersion) {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    private static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }

    static long encodeLogVersion(long logVersion, long formatVersion) {
        return logVersion & 0xFFFFFFFFFFFFFFL | formatVersion << 56;
    }

    static {
        KERNEL_VERSION_TO_LOG_FORMAT = new EnumMap(KernelVersion.class);
        int biggestHeader = 0;
        BY_VERSION_BYTE = new LogFormat[127];
        LogFormat[] logFormatArray = LogFormat.values();
        int n = logFormatArray.length;
        for (int i = 0; i < n; ++i) {
            LogFormat format;
            LogFormat.BY_VERSION_BYTE[format.versionByte] = format = logFormatArray[i];
            if (biggestHeader >= format.headerSize) continue;
            biggestHeader = format.headerSize;
        }
        BIGGEST_HEADER = biggestHeader;
        LogFormat.buildKernelToFormatMap();
    }

    private static interface LogFormatHeaderParser {
        public LogHeader parse(long var1, ByteBuffer var3) throws IOException;
    }

    public static interface LogFormatHeaderWriter {
        public void write(ByteBuffer var1, LogHeader var2) throws IOException;
    }
}

