/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.storageengine.api.StoreId;

public class LogHeader {
    static final int LOG_HEADER_VERSION_SIZE = 8;
    private final LogFormat logFormatVersion;
    private final long logVersion;
    private final long lastCommittedTxId;
    private final long lastAppendIndex;
    private final StoreId storeId;
    private final LogPosition startPosition;
    private final int segmentBlockSize;
    private final int previousLogFileChecksum;
    private final KernelVersion kernelVersion;

    LogHeader(byte logFormatVersion, long logVersion, long lastCommittedTxId, long lastAppendIndex, StoreId storeId, long headerSize, int segmentBlockSize, int previousLogFileChecksum, KernelVersion kernelVersion) {
        this.logFormatVersion = LogFormat.fromByteVersion(logFormatVersion);
        this.logVersion = logVersion;
        this.lastCommittedTxId = lastCommittedTxId;
        this.lastAppendIndex = lastAppendIndex;
        this.storeId = storeId;
        this.segmentBlockSize = segmentBlockSize;
        this.startPosition = segmentBlockSize != -1 ? new LogPosition(logVersion, (long)segmentBlockSize) : new LogPosition(logVersion, headerSize);
        this.previousLogFileChecksum = previousLogFileChecksum;
        this.kernelVersion = kernelVersion;
    }

    public LogHeader(LogHeader logHeader, long version) {
        this.logFormatVersion = logHeader.logFormatVersion;
        this.logVersion = version;
        this.lastCommittedTxId = logHeader.lastCommittedTxId;
        this.lastAppendIndex = logHeader.lastAppendIndex;
        this.storeId = logHeader.storeId;
        this.segmentBlockSize = logHeader.segmentBlockSize;
        this.startPosition = new LogPosition(version, logHeader.startPosition.getByteOffset());
        this.previousLogFileChecksum = logHeader.previousLogFileChecksum;
        this.kernelVersion = logHeader.kernelVersion;
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public LogFormat getLogFormatVersion() {
        return this.logFormatVersion;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getLastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public int getSegmentBlockSize() {
        return this.segmentBlockSize;
    }

    public int getPreviousLogFileChecksum() {
        return this.previousLogFileChecksum;
    }

    public KernelVersion getKernelVersion() {
        return this.kernelVersion;
    }

    public long getLastAppendIndex() {
        return this.lastAppendIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogHeader logHeader = (LogHeader)o;
        return this.logFormatVersion == logHeader.logFormatVersion && this.logVersion == logHeader.logVersion && this.lastCommittedTxId == logHeader.lastCommittedTxId && this.lastAppendIndex == logHeader.lastAppendIndex && Objects.equals(this.storeId, logHeader.storeId) && Objects.equals(this.startPosition, logHeader.startPosition) && this.segmentBlockSize == logHeader.segmentBlockSize && this.previousLogFileChecksum == logHeader.previousLogFileChecksum && this.kernelVersion == logHeader.kernelVersion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logFormatVersion, this.logVersion, this.lastCommittedTxId, this.lastAppendIndex, this.storeId, this.startPosition, this.segmentBlockSize, this.previousLogFileChecksum, this.kernelVersion});
    }

    public String toString() {
        return "LogHeader{logFormatVersion=" + this.logFormatVersion + ", logVersion=" + this.logVersion + ", lastCommittedTxId=" + this.lastCommittedTxId + ", lastAppendIndex=" + this.lastAppendIndex + ", storeId=" + this.storeId + ", startPosition=" + this.startPosition + ", segmentBlockSize=" + this.segmentBlockSize + ", previousLogFileChecksum=" + this.previousLogFileChecksum + ", kernelVersion=" + this.kernelVersion + "}";
    }
}

