/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v56;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class LogEntryDetachedCheckpointV5_6
extends AbstractVersionAwareLogEntry {
    private final TransactionId transactionId;
    private final LogPosition logPosition;
    private final long checkpointTime;
    private final StoreId storeId;
    private final String reason;

    public LogEntryDetachedCheckpointV5_6(KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason) {
        super(kernelVersion, (byte)12);
        this.transactionId = transactionId;
        this.logPosition = logPosition;
        this.checkpointTime = checkpointMillis;
        this.storeId = storeId;
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV5_6 that = (LogEntryDetachedCheckpointV5_6)o;
        return this.checkpointTime == that.checkpointTime && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.logPosition, that.logPosition) && Objects.equals(this.storeId, that.storeId) && this.kernelVersion() == that.kernelVersion() && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.kernelVersion(), this.transactionId, this.logPosition, this.checkpointTime, this.storeId, this.reason);
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LogPosition getLogPosition() {
        return this.logPosition;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "LogEntryDetachedCheckpointV5_6{transactionId=" + this.transactionId + ", logPosition=" + this.logPosition + ", checkpointTime=" + this.checkpointTime + ", storeId=" + this.storeId + ", reason='" + this.reason + "', version=" + this.kernelVersion() + "}";
    }
}

