/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v42;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class CommitLogEntrySerializerV4_2
extends LogEntrySerializer<LogEntryCommit> {
    public CommitLogEntrySerializerV4_2() {
        super((byte)5);
    }

    @Override
    public LogEntryCommit parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long txId = channel.getLong();
        long timeWritten = channel.getLong();
        int checksum = channel.endChecksumAndValidate();
        return new LogEntryCommit(version, txId, timeWritten, checksum);
    }

    @Override
    public int write(WritableChannel channel, LogEntryCommit logEntry) throws IOException {
        CommitLogEntrySerializerV4_2.writeLogEntryHeader(logEntry.kernelVersion(), (byte)5, channel);
        channel.putLong(logEntry.getTxId()).putLong(logEntry.getTimeWritten());
        return channel.putChecksum();
    }
}

