/*
 * Decompiled with CFR 0.152.
 */
package n10s;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import n10s.ConfiguredStatementHandler;
import n10s.graphconfig.RDFParserConfig;
import n10s.mapping.MappingUtils;
import n10s.utils.DateUtils;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.PointValue;

public abstract class RDFToLPGStatementProcessor
extends ConfiguredStatementHandler {
    public static final int RELATIONSHIP = 0;
    public static final int LABEL = 1;
    public static final int PROPERTY = 2;
    public static final int DATATYPE = 3;
    protected final Log log;
    private static final String[] EMPTY_ARRAY = new String[0];
    protected Transaction tx;
    protected final RDFParserConfig parserConfig;
    private final Map<String, String> vocMappings;
    protected GraphDatabaseService graphdb;
    protected NsPrefixMap namespaces;
    protected Set<Statement> statements = new HashSet<Statement>();
    protected Map<String, Map<String, Object>> resourceProps = new HashMap<String, Map<String, Object>>();
    protected Map<Statement, Map<String, Object>> relProps = new HashMap<Statement, Map<String, Object>>();
    protected Map<String, Set<String>> resourceLabels = new HashMap<String, Set<String>>();
    public long totalTriplesParsed = 0L;
    public long totalTriplesMapped = 0L;
    public long mappedTripleCounter = 0L;
    protected final ValueFactory vf = SimpleValueFactory.getInstance();
    protected StringBuilder loadWarnings = new StringBuilder();
    protected boolean datatypeConflictFound = false;

    public RDFToLPGStatementProcessor(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        this.graphdb = db;
        this.tx = tx;
        this.parserConfig = conf;
        this.log = l;
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 3) {
            Map<String, String> mappingsTemp = MappingUtils.getImportMappingsFromDB(this.graphdb);
            if (mappingsTemp.containsKey(RDF.TYPE.stringValue())) {
                mappingsTemp.remove(RDF.TYPE.stringValue());
                this.log.debug("Mapping on rdf:type property is not applicable in RDF import and will be discarded");
            }
            this.vocMappings = mappingsTemp;
        } else {
            this.vocMappings = null;
        }
    }

    private void loadNamespaces() throws InvalidNamespacePrefixDefinitionInDB {
        this.namespaces = new NsPrefixMap(this.tx, false);
    }

    protected Object getObjectValue(IRI propertyIRI, Literal object) {
        IRI datatype = object.getDatatype();
        if (datatype.equals(XMLSchema.STRING) || datatype.equals(RDF.LANGSTRING)) {
            Optional<String> language = object.getLanguage();
            if (this.parserConfig.getLanguageFilter() == null || !language.isPresent() || this.parserConfig.getLanguageFilter().equals(language.get())) {
                return object.stringValue() + (String)(this.parserConfig.getGraphConf().isKeepLangTag() && language.isPresent() ? "@" + language.get() : "");
            }
            return null;
        }
        if (this.typeMapsToLongType(datatype)) {
            return object.longValue();
        }
        if (this.typeMapsToDouble(datatype)) {
            return object.doubleValue();
        }
        if (datatype.equals(XMLSchema.BOOLEAN)) {
            return object.booleanValue();
        }
        if (datatype.equals(XMLSchema.DATETIME)) {
            try {
                return ZonedDateTime.parse(object.stringValue());
            }
            catch (DateTimeParseException dtpe) {
                try {
                    DateTimeFormatter neo4jZonedDateFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).appendPattern("'['").appendZoneId().appendPattern("']'").toFormatter();
                    return ZonedDateTime.parse(object.stringValue(), neo4jZonedDateFormat);
                }
                catch (DateTimeParseException dtpe2) {
                    try {
                        return DateUtils.parseDateTime(object.stringValue());
                    }
                    catch (IllegalArgumentException e) {
                        return object.stringValue();
                    }
                }
            }
        }
        if (datatype.equals(this.vf.createIRI("http://www.opengis.net/ont/geosparql#", "wktLiteral"))) {
            try {
                return PointValue.parse((CharSequence)this.wktToCartesian(object.stringValue()));
            }
            catch (InvalidArgumentException e) {
                return object.stringValue();
            }
        }
        if (datatype.equals(XMLSchema.DATE)) {
            try {
                return DateUtils.parseDate(object.stringValue());
            }
            catch (IllegalArgumentException e) {
                return object.stringValue();
            }
        }
        if (this.parserConfig.getGraphConf().isKeepCustomDataTypes() && this.parserConfig.getGraphConf().getHandleVocabUris() != 2 && this.parserConfig.getGraphConf().getHandleVocabUris() != 3) {
            if (this.parserConfig.getGraphConf().getCustomDataTypePropList() == null || this.parserConfig.getGraphConf().getCustomDataTypePropList().contains(propertyIRI.stringValue())) {
                return this.getValueWithDatatype(datatype, object.stringValue());
            }
            return object.stringValue();
        }
        return object.stringValue();
    }

    private String wktToCartesian(String wktString) {
        Pattern wktRegex = Pattern.compile("^Point\\((?:(\\-?\\d+(?:\\.\\d+)?)\\s+)?(\\-?\\d+(?:\\.\\d+)?)\\s+(\\-?\\d+(?:\\.\\d+)?)\\)$");
        Matcher m = wktRegex.matcher(wktString);
        if (m.matches() && m.groupCount() == 3 && m.group(1) == null) {
            return m.replaceFirst("point({x: $2, y: $3, crs: 'cartesian'})");
        }
        if (m.matches() && m.groupCount() == 3 && m.group(1) != null) {
            return m.replaceFirst("point({x: $1, y: $2, z: $3, crs: 'cartesian-3d'})");
        }
        return wktString;
    }

    protected String getValueWithDatatype(IRI datatype, String value) {
        StringBuilder result = new StringBuilder(value);
        result.append("^^");
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
            result.append(this.handleIRI(datatype, 3));
        } else {
            result.append(datatype.stringValue());
        }
        return result.toString();
    }

    private boolean typeMapsToDouble(IRI datatype) {
        return datatype.equals(XMLSchema.DECIMAL) || datatype.equals(XMLSchema.DOUBLE) || datatype.equals(XMLSchema.FLOAT);
    }

    private boolean typeMapsToLongType(IRI datatype) {
        return datatype.equals(XMLSchema.INTEGER) || datatype.equals(XMLSchema.LONG) || datatype.equals(XMLSchema.INT) || datatype.equals(XMLSchema.SHORT) || datatype.equals(XMLSchema.BYTE) || datatype.equals(XMLSchema.NON_NEGATIVE_INTEGER) || datatype.equals(XMLSchema.POSITIVE_INTEGER) || datatype.equals(XMLSchema.UNSIGNED_LONG) || datatype.equals(XMLSchema.UNSIGNED_INT) || datatype.equals(XMLSchema.UNSIGNED_SHORT) || datatype.equals(XMLSchema.UNSIGNED_BYTE) || datatype.equals(XMLSchema.NON_POSITIVE_INTEGER) || datatype.equals(XMLSchema.NEGATIVE_INTEGER);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    protected String handleIRI(IRI iri, int elementType) {
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0 || this.parserConfig.getGraphConf().getHandleVocabUris() == 1) {
            String localName = iri.getLocalName();
            String prefix = this.namespaces.getPrefixOrAdd(iri.getNamespace(), this.parserConfig.getGraphConf().getHandleVocabUris() == 1);
            return prefix + "__" + localName;
        }
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 2) {
            return this.applyCapitalisation(iri.getLocalName(), elementType);
        }
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 3) {
            return this.mapElement(iri, elementType, null);
        }
        return iri.stringValue();
    }

    private String applyCapitalisation(String name, int element) {
        if (this.parserConfig.getGraphConf().isApplyNeo4jNaming()) {
            if (element == 0) {
                return name.toUpperCase();
            }
            if (element == 1) {
                return name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            if (element == 2) {
                return name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            return name;
        }
        return name;
    }

    private String mapElement(IRI iri, int elementType, String mappingId) {
        if (this.vocMappings.containsKey(iri.stringValue())) {
            return this.vocMappings.get(iri.stringValue());
        }
        return this.applyCapitalisation(iri.getLocalName(), elementType);
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0 || this.parserConfig.getGraphConf().getHandleVocabUris() == 1) {
            try {
                this.loadNamespaces();
            }
            catch (InvalidNamespacePrefixDefinitionInDB e) {
                throw new RDFHandlerException(e.getMessage());
            }
            this.log.debug("Found " + this.namespaces.getPrefixes().size() + " namespaces in the DB: " + this.namespaces);
        }
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
    }

    protected void addStatement(Statement st) {
        this.statements.add(st);
    }

    private void initialise(String subjectUri) {
        this.initialiseResourceProps(this.resourceProps, subjectUri);
        this.initialiseLabels(subjectUri);
    }

    private Set<String> initialiseLabels(String subjectUri) {
        HashSet<String> labels = new HashSet<String>();
        this.resourceLabels.put(subjectUri, labels);
        return labels;
    }

    private Map<String, Object> initialiseResourceProps(Map<String, Map<String, Object>> m, String subjectUri) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        m.put(subjectUri, props);
        return props;
    }

    private Map<String, Object> initialiseRelProps(Map<Statement, Map<String, Object>> m, Statement stmt) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        m.put(stmt, props);
        return props;
    }

    protected boolean setProp(String subjectUri, IRI propertyIRI, Literal propValueRaw) {
        Object propValue = this.getObjectValue(propertyIRI, propValueRaw);
        if (propValue != null) {
            Map<String, Object> props;
            if (!this.resourceProps.containsKey(subjectUri)) {
                props = this.initialiseResourceProps(this.resourceProps, subjectUri);
                this.initialiseLabels(subjectUri);
            } else {
                props = this.resourceProps.get(subjectUri);
            }
            this.addPropertyValueToElementProps(propertyIRI, props, propValue);
        }
        return propValue != null;
    }

    private void addPropertyValueToElementProps(IRI propertyIRI, Map<String, Object> props, Object propValue) {
        String propName = this.handleIRI(propertyIRI, 2);
        if (this.parserConfig.getGraphConf().getHandleMultival() == 0) {
            props.put(propName, propValue);
        } else if (this.parserConfig.getGraphConf().getHandleMultival() == 1) {
            if (this.parserConfig.getGraphConf().getMultivalPropList() == null || this.parserConfig.getGraphConf().getMultivalPropList().contains(propertyIRI.stringValue())) {
                if (props.containsKey(propName)) {
                    List propVals = (List)props.get(propName);
                    propVals.add(propValue);
                } else {
                    ArrayList<Object> propVals = new ArrayList<Object>();
                    propVals.add(propValue);
                    props.put(propName, propVals);
                }
            } else {
                props.put(propName, propValue);
            }
        }
    }

    protected void setLabel(String subjectUri, String label) {
        Set<String> labels;
        if (!this.resourceLabels.containsKey(subjectUri)) {
            this.initialiseResourceProps(this.resourceProps, subjectUri);
            labels = this.initialiseLabels(subjectUri);
        } else {
            labels = this.resourceLabels.get(subjectUri);
        }
        labels.add(label);
    }

    private void addResource(String subjectUri) {
        if (!this.resourceLabels.containsKey(subjectUri)) {
            this.initialise(subjectUri);
        }
    }

    @Override
    public void handleStatement(Statement st) {
        Object subjectUri;
        IRI predicate = st.getPredicate();
        Resource subject = st.getSubject();
        Value object = st.getObject();
        Object object2 = subjectUri = subject instanceof BNode ? "bnode://" + subject.stringValue() : subject.stringValue();
        if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(predicate.stringValue())) {
            if (subject instanceof Triple) {
                Triple reifiedStatement = (Triple)subject;
                if (!(reifiedStatement.getObject() instanceof Literal) && !reifiedStatement.getPredicate().equals(RDF.TYPE) && object instanceof Literal) {
                    Object subjectUri1 = reifiedStatement.getSubject() instanceof BNode ? "bnode://" + reifiedStatement.getSubject().stringValue() : reifiedStatement.getSubject().stringValue();
                    Object objectUri1 = reifiedStatement.getObject() instanceof BNode ? "bnode://" + reifiedStatement.getObject().stringValue() : reifiedStatement.getObject().stringValue();
                    this.addResource((String)subjectUri1);
                    this.addResource((String)objectUri1);
                    Statement stmt = this.vf.createStatement((Resource)this.vf.createIRI((String)subjectUri1), reifiedStatement.getPredicate(), (Value)this.vf.createIRI((String)objectUri1));
                    this.addStatement(stmt);
                    this.addRelProp(stmt, predicate, (Literal)object);
                    ++this.mappedTripleCounter;
                }
            } else if (object instanceof Literal) {
                if (this.setProp((String)subjectUri, predicate, (Literal)object)) {
                    ++this.mappedTripleCounter;
                }
            } else if ((this.parserConfig.getGraphConf().getHandleRDFTypes() == 0 || this.parserConfig.getGraphConf().getHandleRDFTypes() == 2) && predicate.equals(RDF.TYPE) && !(object instanceof BNode)) {
                this.setLabel((String)subjectUri, this.handleIRI((IRI)object, 1));
                if (this.parserConfig.getGraphConf().getHandleRDFTypes() == 2) {
                    this.addResource((String)subjectUri);
                    this.addResource(object.stringValue());
                    this.addStatement(this.vf.createStatement((Resource)this.vf.createIRI((String)subjectUri), predicate, object));
                }
                ++this.mappedTripleCounter;
            } else if (!(object instanceof Triple)) {
                this.addResource((String)subjectUri);
                Object objectUri = object instanceof BNode ? "bnode://" + object.stringValue() : object.stringValue();
                this.addResource((String)objectUri);
                this.addStatement(this.vf.createStatement((Resource)this.vf.createIRI((String)subjectUri), predicate, (Value)this.vf.createIRI((String)objectUri)));
                ++this.mappedTripleCounter;
            }
        }
        ++this.totalTriplesParsed;
        if (this.parserConfig.getCommitSize() != Long.MAX_VALUE && this.mappedTripleCounter != 0L && this.mappedTripleCounter % this.parserConfig.getCommitSize() == 0L) {
            this.periodicOperation();
        }
    }

    protected boolean addRelProp(Statement stmt, IRI predicate, Literal propValueRaw) {
        Object propValue = this.getObjectValue(predicate, propValueRaw);
        if (propValue != null) {
            Map<String, Object> props = !this.relProps.containsKey(stmt) ? this.initialiseRelProps(this.relProps, stmt) : this.relProps.get(stmt);
            this.addPropertyValueToElementProps(predicate, props, propValue);
        }
        return propValue != null;
    }

    @Override
    public RDFParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces == null ? null : this.namespaces.getPrefixToNs();
    }

    protected Object toPropertyValue(Object value) {
        Iterable it = (Iterable)value;
        Object first = Iterables.firstOrNull((Iterable)it);
        if (first == null) {
            return EMPTY_ARRAY;
        }
        return Iterables.asArray(first.getClass(), (Iterable)it);
    }

    protected List<String> defaultToString(Iterator it) {
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            Object next = it.next();
            list.add(next instanceof String ? next.toString() : this.getValueWithDatatype(this.getBestGuessDatatype(next.getClass()), next.toString()));
        }
        return list;
    }

    private IRI getBestGuessDatatype(Class<?> c) {
        if (c.equals(Double.class)) {
            return XMLSchema.DOUBLE;
        }
        if (c.equals(Long.class)) {
            return XMLSchema.LONG;
        }
        if (c.equals(Boolean.class)) {
            return XMLSchema.BOOLEAN;
        }
        if (c.equals(LocalDate.class)) {
            return XMLSchema.DATE;
        }
        if (c.equals(LocalDateTime.class)) {
            return XMLSchema.DATETIME;
        }
        return XMLSchema.STRING;
    }

    protected abstract void periodicOperation();

    public String getWarnings() {
        return this.loadWarnings.toString() + (this.datatypeConflictFound ? this.datatypeConflictMessage() : "");
    }

    private String datatypeConflictMessage() {
        if (this.getParserConfig().isStrictDataTypeCheck()) {
            return "Some triples were discarded because of heterogeneous data typing of values for the same property. Check logs  for details.";
        }
        return "Some heterogeneous data typing of values for the same property was found. Values were imported as typed strings. Check logs  for details.";
    }

    protected class HeterogeneousDataTyping
    extends RDFHandlerException {
        public HeterogeneousDataTyping() {
            super("Heterogeneous Datatyping");
        }
    }

    protected class PartialCommitException
    extends RDFHandlerException {
        public PartialCommitException(String s, Exception e) {
            super(s, e);
        }
    }

    protected class NamespacePrefixConflict
    extends RDFHandlerException {
        public NamespacePrefixConflict(String s, Exception e) {
            super(s, e);
        }
    }
}

