/*
 * Decompiled with CFR 0.152.
 */
package n10s.aux;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import n10s.graphconfig.Params;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.storable.DurationValue;

public class AuxProcedures {
    @UserFunction(name="n10s.aux.dt.check")
    @Description(value="Checks if a value has a given datatype (XSD)")
    public Boolean checkDatatype(@Name(value="expectedType") String expected, @Name(value="actual") Object value) {
        return this.getXSDFrom(value).equals(expected);
    }

    private String getXSDFrom(Object value) {
        if (value != null) {
            Class<?> type = value.getClass();
            if (LocalDate.class.isAssignableFrom(type)) {
                return XMLSchema.DATE.stringValue();
            }
            if (LocalDateTime.class.isAssignableFrom(type)) {
                return XMLSchema.DATETIME.stringValue();
            }
            if (LocalTime.class.isAssignableFrom(type)) {
                return XMLSchema.TIME.stringValue();
            }
            if (ZonedDateTime.class.isAssignableFrom(type)) {
                return XMLSchema.DATETIME.stringValue();
            }
            if (Point.class.isAssignableFrom(type)) {
                return Params.WKTLITERAL_URI.stringValue();
            }
            if (DurationValue.class.isAssignableFrom(type)) {
                return XMLSchema.DURATION.stringValue();
            }
            if (OffsetTime.class.isAssignableFrom(type)) {
                return XMLSchema.TIME.stringValue();
            }
            if (String.class.isAssignableFrom(type) && URIUtil.isValidURIReference(((String)value).trim()) && !((String)value).contains(" ")) {
                return XMLSchema.ANYURI.stringValue();
            }
            return "NONE";
        }
        return "NULL";
    }
}

