/*
 * Decompiled with CFR 0.152.
 */
package n10s.graphconfig;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import n10s.graphconfig.GraphConfig;
import n10s.result.GraphConfigItemResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphConfigProcedures {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;

    @Procedure(mode=Mode.WRITE)
    @Description(value="Initialises the config that drives the behavior of the graph")
    public Stream<GraphConfigItemResult> init(@Name(value="params", defaultValue="{}") Map<String, Object> props) throws GraphConfigException {
        if (this.graphIsEmpty()) {
            try {
                GraphConfig currentGraphConfig = new GraphConfig(props);
                HashMap<String, Map<String, Object>> queryParams = new HashMap<String, Map<String, Object>>();
                queryParams.put("props", currentGraphConfig.serialiseConfig());
                this.tx.execute("MERGE (gc:_GraphConfig) SET gc+= $props", queryParams);
                return currentGraphConfig.getAsGraphConfigResults().stream();
            }
            catch (GraphConfig.InvalidParamException ipe) {
                throw new GraphConfigException(ipe.getMessage());
            }
        }
        throw new GraphConfigException("The graph is non-empty. Config cannot be changed.");
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="sets specific params to the config that drives the behavior of the graph")
    public Stream<GraphConfigItemResult> set(@Name(value="params", defaultValue="{}") Map<String, Object> props) throws GraphConfigException {
        if (props.containsKey("force") && props.get("force").equals(Boolean.TRUE) || this.graphIsEmpty()) {
            GraphConfig currentGraphConfig;
            try {
                try {
                    currentGraphConfig = new GraphConfig(this.tx);
                    currentGraphConfig.add(props);
                }
                catch (GraphConfig.GraphConfigNotFound e) {
                    throw new GraphConfigException("Graph config not found. Call 'init' method first.");
                }
            }
            catch (GraphConfig.InvalidParamException ipe) {
                throw new GraphConfigException(ipe.getMessage());
            }
            HashMap<String, Map<String, Object>> queryParams = new HashMap<String, Map<String, Object>>();
            queryParams.put("props", currentGraphConfig.serialiseConfig());
            this.tx.execute("MERGE (gc:_GraphConfig) SET gc+= $props", queryParams);
            return currentGraphConfig.getAsGraphConfigResults().stream();
        }
        throw new GraphConfigException("The graph is non-empty. Config cannot be changed.");
    }

    @Procedure(mode=Mode.READ)
    @Description(value="Shows the current graph config")
    public Stream<GraphConfigItemResult> show() throws GraphConfigException {
        try {
            return new GraphConfig(this.tx).getAsGraphConfigResults().stream();
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            return Stream.empty();
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="removes the current graph config")
    public Stream<GraphConfigItemResult> drop() throws GraphConfigException {
        if (!this.graphIsEmpty()) {
            throw new GraphConfigException("The graph is non-empty. Config cannot be changed.");
        }
        ResourceIterator graphConfigs = this.tx.findNodes(Label.label((String)"_GraphConfig"));
        if (graphConfigs.hasNext()) {
            ((Node)graphConfigs.next()).delete();
        }
        return Stream.empty();
    }

    private boolean graphIsEmpty() {
        return !this.tx.execute("match (r:Resource) return id(r) limit 1").hasNext();
    }

    private class GraphConfigException
    extends Throwable {
        public GraphConfigException(String msg) {
            super(msg);
        }
    }
}

