/*
 * Decompiled with CFR 0.152.
 */
package n10s.onto;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;

public class OWLRestriction {
    protected static final IRI INIT = SimpleValueFactory.getInstance().createIRI("neo4j://initRestrictionType");
    protected static final IRI CARDINALITY = SimpleValueFactory.getInstance().createIRI("neo4j://cardinalityRestrictionType");
    private BNode restrictionId;
    private IRI type = INIT;
    private IRI relName = null;
    private IRI targetClass = null;
    private Integer cardinalityValue = null;
    private IRI cardinalityType = null;

    public OWLRestriction(BNode bNode) {
        this.restrictionId = bNode;
    }

    boolean isComplete() {
        return this.type != INIT && this.relName != null && this.targetClass != null && (!this.type.equals(CARDINALITY) || this.cardinalityValue != null);
    }

    public void setRelName(IRI rn) {
        this.relName = rn;
    }

    public void setTarget(IRI target) {
        this.targetClass = target;
    }

    public BNode getRestrictionId() {
        return this.restrictionId;
    }

    public IRI getType() {
        return this.type;
    }

    public IRI getCardinalityType() {
        return this.cardinalityType;
    }

    public boolean isCardinalityConstraint() {
        return this.type.equals(CARDINALITY);
    }

    public IRI getRelName() {
        return this.relName;
    }

    public IRI getTargetClass() {
        return this.targetClass;
    }

    public void setType(IRI tp) {
        this.type = tp.equals(OWL.ONCLASS) ? CARDINALITY : tp;
    }

    public void setCardinalityValue(Literal val) {
        this.cardinalityValue = Integer.parseInt(val.stringValue());
        if (this.cardinalityValue < 0) {
            throw new NumberFormatException("Cardinality needs to be defined as a non-negative integer");
        }
    }

    public void setCardinalitySpecificType(IRI type) {
        this.cardinalityType = type;
    }

    public int getCardinalityVal() {
        return this.cardinalityValue;
    }
}

