/*
 * Decompiled with CFR 0.152.
 */
package n10s.quadrdf;

import java.io.IOException;
import java.util.Map;
import n10s.CommonProcedures;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.RDFParserConfig;
import n10s.quadrdf.RDFQuadDirectStatementDeleter;
import n10s.quadrdf.RDFQuadDirectStatementLoader;
import n10s.rdf.RDFProcedures;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.procedure.Name;

public class QuadRDFProcedures
extends CommonProcedures {
    protected RDFProcedures.ImportResults doQuadRDFImport(@Name(value="format") String format, @Name(value="url") String url, @Name(value="rdf") String rdfFragment, @Name(value="params", defaultValue="{}") Map<String, Object> props) {
        RDFToLPGStatementProcessor statementLoader = null;
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        RDFProcedures.ImportResults importResults = new RDFProcedures.ImportResults();
        try {
            this.checkIndexExist();
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            if (rdfFormat != RDFFormat.TRIG && rdfFormat != RDFFormat.NQUADS) {
                throw new CommonProcedures.RDFImportBadParams(rdfFormat.getName() + " is not a Quad serialisation format");
            }
            statementLoader = new RDFQuadDirectStatementLoader(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            importResults.setTerminationKO(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            importResults.setTerminationKO("A Graph Config is required for RDF importing procedures to run");
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            importResults.setTerminationKO(e.getMessage());
        }
        if (statementLoader != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementLoader);
                importResults.setTriplesLoaded(((RDFQuadDirectStatementLoader)statementLoader).totalTriplesMapped);
                importResults.setTriplesParsed(((RDFQuadDirectStatementLoader)statementLoader).totalTriplesParsed);
                importResults.setNamespaces(statementLoader.getNamespaces());
                importResults.setConfigSummary(props);
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                importResults.setTerminationKO(e.getMessage());
                importResults.setTriplesLoaded(((RDFQuadDirectStatementLoader)statementLoader).totalTriplesMapped);
                importResults.setTriplesParsed(((RDFQuadDirectStatementLoader)statementLoader).totalTriplesParsed);
                importResults.setConfigSummary(props);
            }
        }
        return importResults;
    }

    protected RDFProcedures.DeleteResults doQuadRDFDelete(@Name(value="format") String format, @Name(value="url") String url, @Name(value="rdf") String rdfFragment, @Name(value="params", defaultValue="{}") Map<String, Object> props) {
        RDFQuadDirectStatementDeleter statementDeleter = null;
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        RDFProcedures.DeleteResults deleteResults = new RDFProcedures.DeleteResults();
        try {
            this.checkIndexExist();
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            if (rdfFormat != RDFFormat.TRIG && rdfFormat != RDFFormat.NQUADS) {
                throw new CommonProcedures.RDFImportBadParams(rdfFormat.getName() + " is not a Quad serialisation format");
            }
            statementDeleter = new RDFQuadDirectStatementDeleter(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            deleteResults.setTerminationKO(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            deleteResults.setTerminationKO("A Graph Config is required for RDF deleting procedures to run");
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            deleteResults.setTerminationKO(e.getMessage());
        }
        if (statementDeleter != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, statementDeleter);
                deleteResults.setTriplesDeleted(statementDeleter.totalTriplesMapped - statementDeleter.getNotDeletedStatementCount());
                deleteResults.setNamespaces(statementDeleter.getNamespaces());
                deleteResults.setExtraInfo(statementDeleter.getbNodeInfo());
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                deleteResults.setTerminationKO(e.getMessage());
                deleteResults.setTriplesDeleted(statementDeleter.totalTriplesMapped - statementDeleter.getNotDeletedStatementCount());
                deleteResults.setNamespaces(statementDeleter.getNamespaces());
                deleteResults.setExtraInfo(statementDeleter.getbNodeInfo());
            }
        }
        return deleteResults;
    }
}

