/*
 * Decompiled with CFR 0.152.
 */
package n10s.quadrdf;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterators;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import n10s.graphconfig.RDFParserConfig;
import n10s.quadrdf.ContextResource;
import n10s.quadrdf.RDFQuadToLPGStatementProcessor;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class RDFQuadDirectStatementDeleter
extends RDFQuadToLPGStatementProcessor {
    private static final Label RESOURCE = Label.label((String)"Resource");
    private Cache<ContextResource, Node> nodeCache;
    private long notDeletedStatementCount;
    private long statementsWithbNodeCount;
    private String bNodeInfo;

    public RDFQuadDirectStatementDeleter(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
        this.bNodeInfo = "";
        this.notDeletedStatementCount = 0L;
        this.statementsWithbNodeCount = 0L;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        this.log.debug("Delete operation  complete: Total number of triples deleted is " + this.totalTriplesMapped + "(out of " + this.totalTriplesParsed + " parsed)");
    }

    public Integer runPartialTx(final Transaction inThreadTransaction) {
        for (final Map.Entry entry : this.resourceLabels.entrySet()) {
            try {
                if (((ContextResource)entry.getKey()).getUri().startsWith("genid")) {
                    this.statementsWithbNodeCount += (long)(((Set)entry.getValue()).size() + 1);
                    continue;
                }
                Node tempNode = null;
                try {
                    tempNode = this.nodeCache.get((ContextResource)entry.getKey(), new Callable<Node>(){

                        @Override
                        public Node call() {
                            Node node = null;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            String cypher = RDFQuadDirectStatementDeleter.this.buildCypher(((ContextResource)entry.getKey()).getUri(), ((ContextResource)entry.getKey()).getGraphUri(), params);
                            Result result = inThreadTransaction.execute(cypher, params);
                            if (result.hasNext()) {
                                node = (Node)result.next().get("n");
                                if (result.hasNext()) {
                                    String props = "{uri: " + ((ContextResource)entry.getKey()).getUri() + (String)(((ContextResource)entry.getKey()).getGraphUri() == null ? "}" : ", graphUri: " + ((ContextResource)entry.getKey()).getGraphUri() + "}");
                                    throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                                }
                            }
                            return node;
                        }
                    });
                }
                catch (CacheLoader.InvalidCacheLoadException | IllegalStateException e) {
                    e.printStackTrace();
                }
                Node node = tempNode;
                ((Set)entry.getValue()).forEach(l -> {
                    if (node != null && node.hasLabel(Label.label((String)l))) {
                        node.removeLabel(Label.label((String)l));
                    } else {
                        ++this.notDeletedStatementCount;
                    }
                });
                ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> {
                    if (v instanceof List) {
                        List valuesToDelete = (List)v;
                        if (node != null && node.hasProperty(k)) {
                            ArrayList<Object> newProps = new ArrayList<Object>();
                            Object prop = node.getProperty(k);
                            if (prop instanceof long[]) {
                                long[] props;
                                for (long currentVal : props = (long[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof double[]) {
                                double[] props;
                                for (double currentVal : props = (double[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof boolean[]) {
                                boolean[] props;
                                for (boolean currentVal : props = (boolean[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof LocalDateTime[]) {
                                LocalDateTime[] props;
                                for (LocalDateTime currentVal : props = (LocalDateTime[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else if (prop instanceof LocalDate[]) {
                                LocalDate[] props;
                                for (LocalDate currentVal : props = (LocalDate[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            } else {
                                Object[] props;
                                for (Object currentVal : props = (Object[])prop) {
                                    if (valuesToDelete.contains(currentVal)) continue;
                                    newProps.add(currentVal);
                                }
                            }
                            node.removeProperty(k);
                            if (!newProps.isEmpty()) {
                                node.setProperty(k, this.toPropertyValue(newProps));
                            }
                        } else {
                            this.notDeletedStatementCount += (long)valuesToDelete.size();
                        }
                    } else if (node != null && node.hasProperty(k)) {
                        node.removeProperty(k);
                    } else {
                        ++this.notDeletedStatementCount;
                    }
                });
                if (node == null) continue;
                this.deleteNodeIfEmpty(node);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (final Statement st : this.statements) {
            try {
                if (st.getSubject() instanceof BNode != st.getObject() instanceof BNode) {
                    ++this.statementsWithbNodeCount;
                }
                if (st.getSubject() instanceof BNode || st.getObject() instanceof BNode) continue;
                ContextResource from = new ContextResource(st.getSubject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null);
                Node fromNode = null;
                try {
                    fromNode = this.nodeCache.get(from, new Callable<Node>(){

                        @Override
                        public Node call() {
                            Node node = null;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            String cypher = RDFQuadDirectStatementDeleter.this.buildCypher(st.getSubject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null, params);
                            Result result = inThreadTransaction.execute(cypher, params);
                            if (result.hasNext()) {
                                node = (Node)result.next().get("n");
                                if (result.hasNext()) {
                                    String props = "{uri: " + st.getSubject().stringValue() + (String)(st.getContext() == null ? "}" : ", graphUri: " + st.getContext().stringValue() + "}");
                                    throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                                }
                            }
                            return node;
                        }
                    });
                }
                catch (CacheLoader.InvalidCacheLoadException | IllegalStateException e) {
                    e.printStackTrace();
                }
                ContextResource to = new ContextResource(st.getObject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null);
                Node toNode = null;
                try {
                    toNode = this.nodeCache.get(to, new Callable<Node>(){

                        @Override
                        public Node call() {
                            Node node = null;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            String cypher = RDFQuadDirectStatementDeleter.this.buildCypher(st.getObject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null, params);
                            Result result = inThreadTransaction.execute(cypher, params);
                            if (result.hasNext()) {
                                node = (Node)result.next().get("n");
                                if (result.hasNext()) {
                                    String props = "{uri: " + st.getObject().stringValue() + (String)(st.getContext() == null ? "}" : ", graphUri: " + st.getContext().stringValue() + "}");
                                    throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                                }
                            }
                            return node;
                        }
                    });
                }
                catch (CacheLoader.InvalidCacheLoadException | IllegalStateException e) {
                    e.printStackTrace();
                }
                if (fromNode == null || toNode == null) {
                    ++this.notDeletedStatementCount;
                    continue;
                }
                if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.INCOMING)) {
                    for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getEndNode().equals(toNode)) continue;
                        rel.delete();
                        break;
                    }
                } else {
                    for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getStartNode().equals(fromNode)) continue;
                        rel.delete();
                        break;
                    }
                }
                this.deleteNodeIfEmpty(toNode);
                this.deleteNodeIfEmpty(fromNode);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
        this.nodeCache.invalidateAll();
        if (this.statementsWithbNodeCount > 0L) {
            this.setbNodeInfo(this.statementsWithbNodeCount + " of the statements could not be deleted, due to containing a blank node.");
        }
        return 0;
    }

    @Override
    protected void periodicOperation() {
        try (Transaction tempTransaction = this.graphdb.beginTx();){
            this.runPartialTx(tempTransaction);
            tempTransaction.commit();
            this.log.debug("partial commit: " + this.mappedTripleCounter + " triples deleted. Total so far: " + this.totalTriplesMapped);
        }
        this.totalTriplesMapped += this.mappedTripleCounter;
        this.mappedTripleCounter = 0L;
    }

    public long getNotDeletedStatementCount() {
        return this.notDeletedStatementCount + this.statementsWithbNodeCount;
    }

    public String getbNodeInfo() {
        return this.bNodeInfo;
    }

    private void setbNodeInfo(String bNodeInfo) {
        this.bNodeInfo = bNodeInfo;
    }

    private void deleteNodeIfEmpty(Node node) {
        int nodePropertyCount = node.getAllProperties().size();
        int labelCount = Iterators.size(node.getLabels().iterator());
        if (!node.hasRelationship(Direction.OUTGOING) && !node.hasRelationship(Direction.INCOMING) && node.hasLabel(RESOURCE) && labelCount == 1 && node.getAllProperties().containsKey("uri") && (node.getAllProperties().containsKey("graphUri") && nodePropertyCount == 2 || nodePropertyCount == 1)) {
            node.delete();
        }
    }
}

