/*
 * Decompiled with CFR 0.152.
 */
package n10s.quadrdf;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import n10s.graphconfig.RDFParserConfig;
import n10s.quadrdf.ContextResource;
import n10s.quadrdf.RDFQuadToLPGStatementProcessor;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class RDFQuadDirectStatementLoader
extends RDFQuadToLPGStatementProcessor {
    private static final Label RESOURCE = Label.label((String)"Resource");
    private Cache<ContextResource, Node> nodeCache;

    public RDFQuadDirectStatementLoader(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        this.log.debug("Import complete: " + this.totalTriplesMapped + "  triples ingested out of " + this.totalTriplesParsed + " parsed");
    }

    public Integer runPartialTx(final Transaction txInThread) {
        boolean count = false;
        for (final Map.Entry entry : this.resourceLabels.entrySet()) {
            try {
                Node node = this.nodeCache.get((ContextResource)entry.getKey(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        Node node = null;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        String cypher = RDFQuadDirectStatementLoader.this.buildCypher(((ContextResource)entry.getKey()).getUri(), ((ContextResource)entry.getKey()).getGraphUri(), params);
                        Result result = txInThread.execute(cypher, params);
                        if (result.hasNext()) {
                            node = (Node)result.next().get("n");
                            if (result.hasNext()) {
                                String props = "{uri: " + ((ContextResource)entry.getKey()).getUri() + (String)(((ContextResource)entry.getKey()).getGraphUri() == null ? "}" : ", graphUri: " + ((ContextResource)entry.getKey()).getGraphUri() + "}");
                                throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                            }
                        }
                        if (node == null) {
                            node = txInThread.createNode(new Label[]{RESOURCE});
                            node.setProperty("uri", (Object)((ContextResource)entry.getKey()).getUri());
                            if (((ContextResource)entry.getKey()).getGraphUri() != null) {
                                node.setProperty("graphUri", (Object)((ContextResource)entry.getKey()).getGraphUri());
                            }
                        }
                        return node;
                    }
                });
                ((Set)entry.getValue()).forEach(l -> node.addLabel(Label.label((String)l)));
                ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> {
                    if (v instanceof List) {
                        Object currentValue = node.getProperty(k, null);
                        if (currentValue == null) {
                            node.setProperty(k, this.toPropertyValue(v));
                        } else {
                            if (currentValue.getClass().isArray()) {
                                Object[] properties = (Object[])currentValue;
                                for (int i = 0; i < properties.length; ++i) {
                                    ((List)v).add(properties[i]);
                                }
                            } else {
                                ((List)v).add(node.getProperty(k));
                            }
                            node.setProperty(k, this.toPropertyValue(((List)v).stream().collect(Collectors.toSet())));
                        }
                    } else {
                        node.setProperty(k, v);
                    }
                });
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (final Statement st : this.statements) {
            try {
                ContextResource from = new ContextResource(st.getSubject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null);
                Node fromNode = this.nodeCache.get(from, new Callable<Node>(){

                    @Override
                    public Node call() {
                        Node node;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        String cypher = RDFQuadDirectStatementLoader.this.buildCypher(st.getSubject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null, params);
                        Result result = txInThread.execute(cypher, params);
                        if (result.hasNext()) {
                            node = (Node)result.next().get("n");
                            if (result.hasNext()) {
                                String props = "{uri: " + st.getSubject().stringValue() + (String)(st.getContext() == null ? "}" : ", graphUri: " + st.getContext().stringValue() + "}");
                                throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                            }
                        } else {
                            throw new NoSuchElementException("There exists no node with \"uri\": " + st.getSubject().stringValue() + " and \"graphUri\": " + st.getContext().stringValue());
                        }
                        return node;
                    }
                });
                ContextResource to = new ContextResource(st.getObject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null);
                Node toNode = this.nodeCache.get(to, new Callable<Node>(){

                    @Override
                    public Node call() {
                        Node node;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        String cypher = RDFQuadDirectStatementLoader.this.buildCypher(st.getObject().stringValue(), st.getContext() != null ? st.getContext().stringValue() : null, params);
                        Result result = txInThread.execute(cypher, params);
                        if (result.hasNext()) {
                            node = (Node)result.next().get("n");
                            if (result.hasNext()) {
                                String props = "{uri: " + st.getObject().stringValue() + (String)(st.getContext() == null ? "}" : ", graphUri: " + st.getContext().stringValue() + "}");
                                throw new IllegalStateException("There are multiple matching nodes for the given properties " + props);
                            }
                        } else {
                            throw new NoSuchElementException("There exists no node with \"uri\": " + st.getSubject().stringValue() + " and \"graphUri\": " + st.getContext().stringValue());
                        }
                        return node;
                    }
                });
                boolean found = false;
                if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.INCOMING)) {
                    for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getEndNode().equals(toNode)) continue;
                        found = true;
                        break;
                    }
                } else {
                    for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                        if (!rel.getStartNode().equals(fromNode)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                fromNode.createRelationshipTo(toNode, RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
        this.relProps.clear();
        this.nodeCache.invalidateAll();
        Integer result = 0;
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
            result = this.namespaces.partialRefresh(txInThread);
        }
        return result;
    }

    @Override
    protected void periodicOperation() {
        Transaction tempTransaction;
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
            try {
                tempTransaction = this.graphdb.beginTx();
                try {
                    this.namespaces.partialRefresh(tempTransaction);
                    tempTransaction.commit();
                    this.log.debug("namespace prefixes synced: " + this.namespaces.toString());
                }
                finally {
                    if (tempTransaction != null) {
                        tempTransaction.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            tempTransaction = this.graphdb.beginTx();
            try {
                this.runPartialTx(tempTransaction);
                tempTransaction.commit();
                this.log.debug("partial commit: " + this.mappedTripleCounter + " triples ingested. Total so far: " + this.totalTriplesMapped);
            }
            finally {
                if (tempTransaction != null) {
                    tempTransaction.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.totalTriplesMapped += this.mappedTripleCounter;
        this.mappedTripleCounter = 0L;
    }
}

