/*
 * Decompiled with CFR 0.152.
 */
package n10s.quadrdf;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.RDFParserConfig;
import n10s.quadrdf.ContextResource;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

abstract class RDFQuadToLPGStatementProcessor
extends RDFToLPGStatementProcessor
implements RDFHandler {
    Map<ContextResource, Map<String, Object>> resourceProps = new HashMap<ContextResource, Map<String, Object>>();
    Map<ContextResource, Set<String>> resourceLabels = new HashMap<ContextResource, Set<String>>();

    RDFQuadToLPGStatementProcessor(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
    }

    @Override
    public void handleStatement(Statement st) {
        Resource context = st.getContext();
        IRI predicate = st.getPredicate();
        Resource subject = st.getSubject();
        Value object = st.getObject();
        ContextResource sub = new ContextResource(subject.stringValue(), context != null ? context.stringValue() : null);
        ContextResource obj = new ContextResource(object.stringValue(), context != null ? context.stringValue() : null);
        if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(predicate.stringValue())) {
            if (object instanceof Literal) {
                if (this.setProp(sub, predicate, (Literal)object)) {
                    ++this.mappedTripleCounter;
                }
            } else if ((this.parserConfig.getGraphConf().getHandleRDFTypes() == 0 && predicate.equals(RDF.TYPE) || this.parserConfig.getGraphConf().getHandleRDFTypes() == 2) && !(object instanceof BNode)) {
                this.setLabel(sub, this.handleIRI((IRI)object, 1));
                if (this.parserConfig.getGraphConf().getHandleRDFTypes() == 2) {
                    this.addResource(sub);
                    this.addResource(obj);
                    this.addStatement(st);
                }
                ++this.mappedTripleCounter;
            } else {
                this.addResource(sub);
                this.addResource(obj);
                this.addStatement(st);
                ++this.mappedTripleCounter;
            }
        }
        ++this.totalTriplesParsed;
        if (this.parserConfig.getCommitSize() != Long.MAX_VALUE && this.mappedTripleCounter % this.parserConfig.getCommitSize() == 0L) {
            this.periodicOperation();
        }
    }

    @Override
    protected abstract void periodicOperation();

    String buildCypher(String uri, String graphUri, Map<String, Object> params) {
        Preconditions.checkNotNull(uri);
        StringBuilder cypher = new StringBuilder();
        params.put("uri", uri);
        cypher.append("MATCH (n:Resource) ");
        cypher.append("WHERE n.uri = $uri ");
        if (graphUri != null) {
            cypher.append("AND n.graphUri = $graphUri ");
            params.put("graphUri", graphUri);
        } else {
            cypher.append("AND NOT EXISTS(n.graphUri) ");
        }
        cypher.append("RETURN n");
        return cypher.toString();
    }

    private boolean setProp(ContextResource contextResource, IRI propertyIRI, Literal propValueRaw) {
        String propName = this.handleIRI(propertyIRI, 2);
        Object propValue = this.getObjectValue(propertyIRI, propValueRaw);
        if (propValue != null) {
            Map<String, Object> props;
            if (!this.resourceProps.containsKey(contextResource)) {
                props = this.initialiseProps(contextResource);
                this.initialiseLabels(contextResource);
            } else {
                props = this.resourceProps.get(contextResource);
            }
            if (this.parserConfig.getGraphConf().getHandleMultival() == 0) {
                props.put(propName, propValue);
            } else if (this.parserConfig.getGraphConf().getHandleMultival() == 1) {
                if (this.parserConfig.getGraphConf().getMultivalPropList() == null || this.parserConfig.getGraphConf().getMultivalPropList().contains(propertyIRI.stringValue())) {
                    if (props.containsKey(propName)) {
                        List propVals = (List)props.get(propName);
                        propVals.add(propValue);
                    } else {
                        ArrayList<Object> propVals = new ArrayList<Object>();
                        propVals.add(propValue);
                        props.put(propName, propVals);
                    }
                } else {
                    props.put(propName, propValue);
                }
            }
        }
        return propValue != null;
    }

    private void setLabel(ContextResource contextResource, String label) {
        Set<String> labels;
        if (!this.resourceLabels.containsKey(contextResource)) {
            this.initialiseProps(contextResource);
            labels = this.initialiseLabels(contextResource);
        } else {
            labels = this.resourceLabels.get(contextResource);
        }
        labels.add(label);
    }

    private void addResource(ContextResource contextResource) {
        if (!this.resourceLabels.containsKey(contextResource)) {
            this.initialise(contextResource);
        }
    }

    private void initialise(ContextResource contextResource) {
        this.initialiseProps(contextResource);
        this.initialiseLabels(contextResource);
    }

    private Set<String> initialiseLabels(ContextResource contextResource) {
        HashSet<String> labels = new HashSet<String>();
        this.resourceLabels.put(contextResource, labels);
        return labels;
    }

    private HashMap<String, Object> initialiseProps(ContextResource contextResource) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.resourceProps.put(contextResource, props);
        return props;
    }
}

