/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.export;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import n10s.graphconfig.GraphConfig;
import n10s.rdf.export.ExportProcessor;
import n10s.rdf.export.TriplePattern;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import n10s.utils.UriUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class LPGRDFToRDFProcesssor
extends ExportProcessor {
    private final Pattern customDataTypedLiteralShortenedURIPattern = Pattern.compile("(.+)" + Pattern.quote("^^") + "(\\w+)" + Pattern.quote("__") + "(.+)$");
    private final NsPrefixMap namespaces;

    public LPGRDFToRDFProcesssor(GraphDatabaseService graphdb, Transaction tx, GraphConfig gc, boolean isRDFStarSerialisation) throws InvalidNamespacePrefixDefinitionInDB {
        super(tx, graphdb, gc);
        this.exportPropertiesInRels = isRDFStarSerialisation;
        this.namespaces = new NsPrefixMap(tx, false);
    }

    @Override
    public Stream<Statement> streamLocalImplicitOntology() {
        HashSet<Statement> statements = new HashSet<Statement>();
        Result res = this.tx.execute("CALL db.schema.visualization() ");
        Map next = res.next();
        List nodeList = (List)next.get("nodes");
        nodeList.forEach(node -> {
            String catName = node.getAllProperties().get("name").toString();
            if (!(catName.equals("Resource") || catName.equals("_NsPrefDef") || catName.equals("_GraphConfig") || catName.equals("_n10sValidatorConfig") || catName.equals("_MapNs") || catName.equals("_MapDef") || catName.equals("_GraphConfig"))) {
                IRI subject = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, catName));
                statements.add(this.vf.createStatement((Resource)subject, RDF.TYPE, (Value)OWL.CLASS));
                statements.add(this.vf.createStatement((Resource)subject, RDFS.LABEL, (Value)this.vf.createLiteral(subject.getLocalName())));
            }
        });
        List relationshipList = (List)next.get("relationships");
        for (Relationship r : relationshipList) {
            String rangeClassStr;
            IRI relUri = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, r.getType().name()));
            statements.add(this.vf.createStatement((Resource)relUri, RDF.TYPE, (Value)OWL.OBJECTPROPERTY));
            statements.add(this.vf.createStatement((Resource)relUri, RDFS.LABEL, (Value)this.vf.createLiteral(relUri.getLocalName())));
            String domainClassStr = ((Label)r.getStartNode().getLabels().iterator().next()).name();
            if (!domainClassStr.equals("Resource")) {
                IRI domainUri = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, domainClassStr));
                statements.add(this.vf.createStatement((Resource)relUri, RDFS.DOMAIN, (Value)domainUri));
            }
            if ((rangeClassStr = ((Label)r.getEndNode().getLabels().iterator().next()).name()).equals("Resource")) continue;
            IRI rangeUri = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, rangeClassStr));
            statements.add(this.vf.createStatement((Resource)relUri, RDFS.RANGE, (Value)rangeUri));
        }
        return statements.stream();
    }

    private String buildURI(String baseVocabNS, String name) {
        Pattern regex = Pattern.compile("^([-\\w]+)__(.*)$");
        Matcher matcher = regex.matcher(name);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            String uriNsPart = this.namespaces.getNsForPrefix(prefix);
            if (uriNsPart == null) {
                throw new MissingNamespacePrefixDefinition("Prefix ".concat(prefix).concat(" in use but not in the namespace prefix definition"));
            }
            String localName = matcher.group(2);
            return uriNsPart + localName;
        }
        if (name.startsWith("http")) {
            return name;
        }
        return baseVocabNS + name;
    }

    public Stream<Statement> streamNodeByUri(String uri, String graphId, boolean excludeContext) {
        String queryNoContext;
        String queryWithContext;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", uri);
        if (graphId == null || graphId.equals("")) {
            queryWithContext = "MATCH (x:Resource {uri:$uri}) WHERE NOT EXISTS(x.graphUri)\nOPTIONAL MATCH (x)-[r]-(val:Resource) WHERE exists(val.uri)\nAND NOT EXISTS(val.graphUri)\nRETURN x, r, val.uri AS value";
            queryNoContext = "MATCH (x:Resource {uri:$uri}) WHERE NOT EXISTS(x.graphUri)\nRETURN x, null AS r, null AS value";
        } else {
            queryWithContext = "MATCH (x:Resource {uri:$uri, graphUri:$graphUri}) OPTIONAL MATCH (x)-[r]-(val:Resource {graphUri:$graphUri}) WHERE exists(val.uri)\nRETURN x, r, val.uri AS value";
            queryNoContext = "MATCH (x:Resource {uri:$uri, graphUri:$graphUri}) RETURN x, null AS r, null AS value";
            params.put("graphUri", graphId);
        }
        HashSet<Statement> statementResults = new HashSet<Statement>();
        Result result = this.tx.execute(excludeContext ? queryNoContext : queryWithContext, params);
        boolean doneOnce = false;
        while (result.hasNext()) {
            Relationship rel;
            Map row = result.next();
            Node node = (Node)row.get("x");
            if (!doneOnce) {
                statementResults.addAll(this.processNode(node, null, null));
                doneOnce = true;
            }
            if ((rel = (Relationship)row.get("r")) == null) continue;
            statementResults.addAll(this.processRelationship(rel, null));
        }
        return statementResults.stream();
    }

    public Stream<Statement> streamNodeByUri(String uri, boolean streamContext) {
        HashMap<Long, IRI> ontologyEntitiesUris = new HashMap<Long, IRI>();
        Node node = this.tx.findNode(Label.label((String)"Resource"), "uri", (Object)uri);
        Set<Statement> result = this.processNode(node, ontologyEntitiesUris, null);
        if (streamContext) {
            Iterable relationships = node.getRelationships();
            for (Relationship rel : relationships) {
                result.addAll(this.processRelationship(rel, ontologyEntitiesUris));
            }
        }
        return result.stream();
    }

    @Override
    protected boolean filterRelationship(Relationship rel, Map<Long, IRI> ontologyEntitiesUris) {
        return !rel.getStartNode().hasLabel(Label.label((String)"Resource")) || !rel.getEndNode().hasLabel(Label.label((String)"Resource"));
    }

    @Override
    protected boolean filterNode(Node node, Map<Long, IRI> ontologyEntitiesUris) {
        return !node.hasLabel(Label.label((String)"Resource"));
    }

    @Override
    protected void processPropOnRel(Set<Statement> statementSet, Statement baseStatement, String key, Object propertyValueObject) {
        IRI predicate = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, key));
        if (propertyValueObject instanceof Object[]) {
            for (Object o : (Object[])propertyValueObject) {
                statementSet.add(this.vf.createStatement((Resource)this.vf.createTriple(baseStatement.getSubject(), baseStatement.getPredicate(), baseStatement.getObject()), predicate, (Value)this.createTypedLiteral(o)));
            }
        } else {
            statementSet.add(this.vf.createStatement((Resource)this.vf.createTriple(baseStatement.getSubject(), baseStatement.getPredicate(), baseStatement.getObject()), predicate, (Value)this.createTypedLiteral(propertyValueObject)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Set<Statement> processRelationship(Relationship rel, Map<Long, IRI> ontologyEntitiesUris) {
        Resource subject = this.buildSubjectOrContext(rel.getStartNode().getProperty("uri").toString());
        IRI predicate = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, rel.getType().name()));
        Resource object = this.buildSubjectOrContext(rel.getEndNode().getProperty("uri").toString());
        Resource context = null;
        if (rel.getStartNode().hasProperty("graphUri") && rel.getEndNode().hasProperty("graphUri")) {
            if (!rel.getStartNode().getProperty("graphUri").toString().equals(rel.getEndNode().getProperty("graphUri").toString())) throw new IllegalStateException("Graph uri of a statement has to be the same for both start and end node of the relationship!");
            context = this.buildSubjectOrContext(rel.getStartNode().getProperty("graphUri").toString());
        } else if (rel.getStartNode().hasProperty("graphUri") != rel.getEndNode().hasProperty("graphUri")) {
            throw new IllegalStateException("Graph uri of a statement has to be the same for both start and end node of the relationship!");
        }
        Statement base = this.vf.createStatement(subject, predicate, (Value)object, context);
        HashSet<Statement> result = new HashSet<Statement>();
        result.add(base);
        if (!this.exportPropertiesInRels) return result;
        rel.getAllProperties().forEach((k, v) -> this.processPropOnRel((Set<Statement>)result, base, (String)k, v));
        return result;
    }

    @Override
    protected Set<Statement> processNode(Node node, Map<Long, IRI> ontologyEntitiesUris, String propNameFilter) {
        HashSet<Statement> result = new HashSet<Statement>();
        if (propNameFilter == null || propNameFilter.equals(RDF.TYPE.stringValue()) || propNameFilter.equals("rdf__type")) {
            Iterable nodeLabels = node.getLabels();
            for (Label label : nodeLabels) {
                if (label.name().equals("Resource")) continue;
                result.add(this.vf.createStatement(this.buildSubjectOrContext(node.getProperty("uri").toString()), RDF.TYPE, (Value)this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, label.name())), node.hasProperty("graphUri") ? this.vf.createIRI(node.getProperty("graphUri").toString()) : null));
            }
        }
        Map allProperties = node.getAllProperties();
        for (String key : allProperties.keySet()) {
            Literal object;
            if (key.equals("uri") || key.equals("graphUri") || propNameFilter != null && !key.equals(propNameFilter)) continue;
            Resource subject = this.buildSubjectOrContext(node.getProperty("uri").toString());
            IRI predicate = this.vf.createIRI(this.buildURI(this.BASE_SCH_NS, key));
            Object propertyValueObject = allProperties.get(key);
            Resource context = null;
            if (node.hasProperty("graphUri")) {
                context = this.buildSubjectOrContext(node.getProperty("graphUri").toString());
            }
            if (propertyValueObject instanceof long[]) {
                for (int i = 0; i < ((long[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((long[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof double[]) {
                for (int i = 0; i < ((double[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((double[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof boolean[]) {
                for (int i = 0; i < ((boolean[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((boolean[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof LocalDateTime[]) {
                for (int i = 0; i < ((LocalDateTime[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((LocalDateTime[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof ZonedDateTime[]) {
                for (int i = 0; i < ((ZonedDateTime[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((ZonedDateTime[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof LocalDate[]) {
                for (int i = 0; i < ((LocalDate[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(((LocalDate[])propertyValueObject)[i]);
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            if (propertyValueObject instanceof Object[]) {
                for (int i = 0; i < ((Object[])propertyValueObject).length; ++i) {
                    object = this.createTypedLiteral(this.buildCustomDTFromShortURI((String)((Object[])propertyValueObject)[i]));
                    result.add(this.vf.createStatement(subject, predicate, (Value)object, context));
                }
                continue;
            }
            Literal object2 = propertyValueObject instanceof String ? this.createTypedLiteral(this.buildCustomDTFromShortURI((String)propertyValueObject)) : this.createTypedLiteral(propertyValueObject);
            result.add(this.vf.createStatement(subject, predicate, (Value)object2, context));
        }
        return result;
    }

    @Override
    public Stream<Statement> streamTriplesFromTriplePattern(TriplePattern tp) throws InvalidNamespacePrefixDefinitionInDB {
        Result result;
        if (tp.getSubject() != null) {
            HashSet<Statement> allStatements = new HashSet<Statement>();
            Node resource = this.tx.findNode(Label.label((String)"Resource"), "uri", (Object)tp.getSubject());
            if (resource != null) {
                String predicate = null;
                try {
                    predicate = tp.getPredicate() != null ? UriUtils.translateUri(tp.getPredicate(), this.tx, this.graphConfig) : null;
                }
                catch (UriUtils.UriNamespaceHasNoAssociatedPrefix e) {
                    predicate = tp.getPredicate();
                }
                if (tp.getObject() == null) {
                    allStatements.addAll(this.processNode(resource, null, predicate));
                    Iterable relationships = tp.getPredicate() == null ? resource.getRelationships(Direction.OUTGOING) : resource.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)predicate)});
                    for (Relationship r : relationships) {
                        allStatements.addAll(this.processRelationship(r, null));
                    }
                } else {
                    Value object = this.getValueFromTriplePatternObject(tp);
                    allStatements.addAll(this.processNode(resource, null, predicate).stream().filter(st -> st.getObject().equals(object)).collect(Collectors.toSet()));
                    if (!tp.getLiteral().booleanValue()) {
                        Iterable relationships = tp.getPredicate() == null ? resource.getRelationships(Direction.OUTGOING) : resource.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)predicate)});
                        for (Relationship r : relationships) {
                            if (!r.getOtherNode(resource).getProperty("uri").equals(object.stringValue())) continue;
                            allStatements.addAll(this.processRelationship(r, null));
                        }
                    }
                }
            }
            return allStatements.stream();
        }
        String predicate = null;
        try {
            predicate = tp.getPredicate() != null ? UriUtils.translateUri(tp.getPredicate(), this.tx, this.graphConfig) : null;
        }
        catch (UriUtils.UriNamespaceHasNoAssociatedPrefix e) {
            predicate = tp.getPredicate();
        }
        if (tp.getObject() == null) {
            Result result2 = predicate != null ? (tp.getPredicate().equals(RDF.TYPE.stringValue()) && this.graphConfig.getHandleRDFTypes() == 0 ? this.tx.execute("MATCH (r:Resource) WHERE size(labels(r))>1 RETURN r") : this.tx.execute(String.format("MATCH (r:Resource) WHERE exists(r.`%s`) RETURN r\nUNION \nMATCH (:Resource)-[r:`%s`]->() RETURN r", predicate, predicate))) : this.tx.execute("MATCH (r:Resource) RETURN r\nUNION \nMATCH (:Resource)-[r]->() RETURN r");
            String finalPredicate = predicate;
            return result2.stream().flatMap(row -> {
                HashSet<Statement> rowResult = new HashSet<Statement>();
                Object r = row.get("r");
                if (r instanceof Node) {
                    rowResult.addAll(this.processNode((Node)r, null, finalPredicate));
                } else if (r instanceof Relationship) {
                    rowResult.addAll(this.processRelationship((Relationship)r, null));
                }
                return rowResult.stream();
            });
        }
        Value object = this.getValueFromTriplePatternObject(tp);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (predicate != null) {
            if (tp.getPredicate().equals(RDF.TYPE.stringValue()) && this.graphConfig.getHandleRDFTypes() == 0) {
                String objectAsShortenedUri = null;
                if (object instanceof IRI) {
                    try {
                        objectAsShortenedUri = UriUtils.translateUri(object.stringValue(), this.tx, this.graphConfig);
                    }
                    catch (UriUtils.UriNamespaceHasNoAssociatedPrefix e) {
                        e.printStackTrace();
                    }
                } else {
                    objectAsShortenedUri = "____";
                }
                result = this.tx.execute(String.format("MATCH (r:`%s`) RETURN r", objectAsShortenedUri));
            } else if (object instanceof IRI) {
                params.put("uri", object.stringValue());
                result = this.tx.execute(String.format("MATCH (:Resource)-[r:`%s`]->(o:Resource { uri:  $uri }) RETURN r", predicate), params);
            } else {
                params.put("propVal", object.stringValue());
                result = this.graphConfig.getHandleMultival() == 1 && (this.graphConfig.getMultivalPropList() == null || this.graphConfig.getMultivalPropList().contains(tp.getPredicate())) ? this.tx.execute(String.format("MATCH (r:Resource) WHERE $propVal in r.`%s` RETURN r", predicate), params) : this.tx.execute(String.format("MATCH (r:Resource) WHERE r.`%s` = $propVal RETURN r", predicate), params);
            }
        } else if (object instanceof IRI) {
            params.put("uri", object.stringValue());
            result = this.tx.execute("MATCH ()-[r]->(o:Resource { uri:  $uri }) RETURN r", params);
        } else {
            params.put("propVal", this.castValueFromXSDType((Literal)object));
            result = this.tx.execute("MATCH (r:Resource) UNWIND keys(r) as propName \nWITH r, propName\nWHERE $propVal in [] + r[propName] \nRETURN r, propName", params);
        }
        String finalPredicate1 = predicate;
        return result.stream().flatMap(row -> {
            HashSet<Statement> rowResult = new HashSet<Statement>();
            Object r = row.get("r");
            if (r instanceof Node) {
                rowResult.addAll(this.processNode((Node)r, null, finalPredicate1 != null ? finalPredicate1 : (String)row.get("propName")));
            } else if (r instanceof Relationship) {
                rowResult.addAll(this.processRelationship((Relationship)r, null));
            }
            return rowResult.stream();
        }).filter(st -> st.getObject().equals(object));
    }

    private String buildCustomDTFromShortURI(String literal) {
        Matcher matcher = this.customDataTypedLiteralShortenedURIPattern.matcher(literal);
        if (matcher.matches()) {
            String value = matcher.group(1);
            String prefix = matcher.group(2);
            String uriNsPart = this.namespaces.getNsForPrefix(prefix);
            if (uriNsPart == null) {
                throw new MissingNamespacePrefixDefinition("Prefix ".concat(prefix).concat(" in use but not in the namespace prefix definition"));
            }
            String localName = matcher.group(3);
            return value + "^^" + uriNsPart + localName;
        }
        return literal;
    }

    private Resource buildSubjectOrContext(String id) {
        Resource result;
        try {
            result = this.vf.createIRI(id);
        }
        catch (IllegalArgumentException e) {
            result = this.vf.createBNode(id);
        }
        return result;
    }

    public Stream<Statement> streamLocalExplicitOntology(Map<String, Object> params) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        return null;
    }

    private class MissingNamespacePrefixDefinition
    extends RDFHandlerException {
        MissingNamespacePrefixDefinition(String msg) {
            super("RDF Serialization ERROR: ".concat(msg));
        }
    }
}

