/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.load;

import java.util.HashMap;
import n10s.graphconfig.RDFParserConfig;
import n10s.rdf.load.DirectStatementLoader;
import n10s.result.RelationshipResult;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DirectRelationshipAdder
extends DirectStatementLoader {
    private Statement relStatement;

    public DirectRelationshipAdder(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
    }

    public RelationshipResult returnRel() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fromuri", this.relStatement.getSubject().stringValue());
        params.put("touri", this.relStatement.getObject().stringValue());
        params.put("relname", this.relStatement.getPredicate().getLocalName());
        return new RelationshipResult((Relationship)this.tx.execute("MATCH (:Resource { uri: $fromuri })-[r]-(:Resource { uri: $touri }) WHERE type(r) contains $relname RETURN r LIMIT 1", params).next().get("r"));
    }

    @Override
    public void handleStatement(Statement st) {
        if (!(st.getSubject() instanceof Triple)) {
            this.relStatement = st;
        }
        super.handleStatement(st);
    }

    @Override
    protected void periodicOperation() {
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
            this.namespaces.partialRefresh(this.tx);
        }
        this.runPartialTx(this.tx);
    }
}

