/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.load;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.RDFParserConfig;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DirectStatementLoader
extends RDFToLPGStatementProcessor {
    private static final Label RESOURCE = Label.label((String)"Resource");
    private Cache<String, Node> nodeCache;

    public DirectStatementLoader(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        this.log.debug("Import complete: " + this.totalTriplesMapped + "  triples ingested out of " + this.totalTriplesParsed + " parsed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer runPartialTx(Transaction inThreadTransaction) {
        try {
            for (Map.Entry entry : this.resourceLabels.entrySet()) {
                try {
                    Node node = this.nodeCache.get((String)entry.getKey(), () -> {
                        Node node1 = inThreadTransaction.findNode(RESOURCE, "uri", entry.getKey());
                        if (node1 == null) {
                            node1 = inThreadTransaction.createNode(new Label[]{RESOURCE});
                            node1.setProperty("uri", entry.getKey());
                        }
                        return node1;
                    });
                    ((Set)entry.getValue()).forEach(l -> node.addLabel(Label.label((String)l)));
                    ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> this.setProperty((Entity)node, (String)k, v));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            for (Statement st : this.statements) {
                try {
                    Map relProps;
                    Node fromNode = this.nodeCache.get(st.getSubject().stringValue(), () -> inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getSubject().stringValue()));
                    Node toNode = this.nodeCache.get(st.getObject().stringValue(), () -> inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getObject().stringValue()));
                    boolean found = false;
                    Relationship theRel = null;
                    if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)), Direction.INCOMING)) {
                        for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                            if (!rel.getEndNode().equals(toNode)) continue;
                            found = true;
                            theRel = rel;
                            break;
                        }
                    } else {
                        for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0))})) {
                            if (!rel.getStartNode().equals(fromNode)) continue;
                            found = true;
                            theRel = rel;
                            break;
                        }
                    }
                    if (!found) {
                        theRel = fromNode.createRelationshipTo(toNode, RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)));
                    }
                    if ((relProps = (Map)this.relProps.get(st)) == null) continue;
                    for (Map.Entry entry : relProps.entrySet()) {
                        this.setProperty((Entity)theRel, (String)entry.getKey(), entry.getValue());
                    }
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            Integer result = 0;
            if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
                result = this.namespaces.partialRefresh(inThreadTransaction);
            }
            Integer n = result;
            return n;
        }
        finally {
            this.statements.clear();
            this.resourceLabels.clear();
            this.resourceProps.clear();
            this.relProps.clear();
            this.nodeCache.invalidateAll();
        }
    }

    private void setProperty(Entity node, String k, Object v) {
        if (v instanceof List) {
            Object currentValue = node.getProperty(k, null);
            ArrayList<Object> newList = new ArrayList<Object>();
            if (currentValue != null) {
                if (currentValue.getClass().isArray()) {
                    int length = Array.getLength(currentValue);
                    for (int i = 0; i < length; ++i) {
                        Object atomicValue = Array.get(currentValue, i);
                        newList.add(atomicValue);
                    }
                } else {
                    newList.add(node.getProperty(k));
                }
            }
            Class<?> currentDatatype = newList.isEmpty() ? ((List)v).get(0).getClass() : newList.get(0).getClass();
            ArrayList discardedItems = new ArrayList();
            for (Object x : (List)v) {
                if (x.getClass().equals(currentDatatype)) {
                    newList.add(x);
                    continue;
                }
                discardedItems.add(x);
            }
            if (!discardedItems.isEmpty()) {
                this.datatypeConflictFound |= true;
                if (this.getParserConfig().isStrictDataTypeCheck()) {
                    this.mappedTripleCounter -= (long)discardedItems.size();
                    this.log.warn("The following values for property '" + k + "' have been discarded because of datatype heterogeneity (previously stored values are of type " + currentDatatype + ") : " + discardedItems);
                    node.setProperty(k, this.toPropertyValue(newList.stream().collect(Collectors.toSet())));
                } else {
                    newList.addAll(discardedItems);
                    node.setProperty(k, this.toPropertyValue(this.defaultToString(newList.iterator()).stream().collect(Collectors.toSet())));
                }
            } else {
                node.setProperty(k, this.toPropertyValue(newList.stream().collect(Collectors.toSet())));
            }
        } else {
            node.setProperty(k, v);
        }
    }

    @Override
    protected void periodicOperation() {
        block18: {
            Transaction tempTransaction;
            block17: {
                if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
                    try {
                        tempTransaction = this.graphdb.beginTx();
                        try {
                            this.namespaces.partialRefresh(tempTransaction);
                            tempTransaction.commit();
                            this.log.debug("namespace prefixes synced: " + this.namespaces.toString());
                        }
                        finally {
                            if (tempTransaction != null) {
                                tempTransaction.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error("Problems syncing up namespace prefixes in partial commit. ", (Throwable)e);
                        if (!this.getParserConfig().isAbortOnError()) break block17;
                        throw new RDFToLPGStatementProcessor.NamespacePrefixConflict("Problems syncing up namespace prefixes in partial commit. ", e);
                    }
                }
            }
            try {
                tempTransaction = this.graphdb.beginTx();
                try {
                    this.runPartialTx(tempTransaction);
                    tempTransaction.commit();
                    this.log.debug("partial commit: " + this.mappedTripleCounter + " triples ingested. Total so far: " + this.totalTriplesMapped);
                    this.totalTriplesMapped += this.mappedTripleCounter;
                }
                finally {
                    if (tempTransaction != null) {
                        tempTransaction.close();
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Problems when running partial commit. Partial transaction rolled back. " + this.mappedTripleCounter + " triples lost.", (Throwable)e);
                if (!this.getParserConfig().isAbortOnError()) break block18;
                throw new RDFToLPGStatementProcessor.PartialCommitException("Problems when running partial commit. Partial transaction rolled back. ", e);
            }
        }
        this.mappedTripleCounter = 0L;
    }
}

