/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.preview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import n10s.ConfiguredStatementHandler;
import n10s.RDFToLPGStatementProcessor;
import n10s.Util;
import n10s.graphconfig.RDFParserConfig;
import n10s.result.VirtualNode;
import n10s.result.VirtualRelationship;
import n10s.utils.NamespacePrefixConflictException;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class StatementPreviewer
extends RDFToLPGStatementProcessor {
    private Map<String, Node> vNodes;
    private List<Relationship> vRels;

    public StatementPreviewer(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Map<String, Node> virtualNodes, List<Relationship> virtualRels, Log l) {
        super(db, tx, conf, l);
        this.vNodes = virtualNodes;
        this.vRels = virtualRels;
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.mappedTripleCounter >= this.parserConfig.getStreamTripleLimit()) {
            this.conclude();
            throw new ConfiguredStatementHandler.TripleLimitReached(this.parserConfig.getStreamTripleLimit() + " triples added to preview");
        }
        super.handleStatement(st);
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.conclude();
    }

    private void conclude() {
        for (String uri : this.resourceLabels.keySet()) {
            this.vNodes.put(uri, new VirtualNode(Util.labels(new ArrayList((Collection)this.resourceLabels.get(uri))), this.getPropsPlusUri(uri)));
        }
        this.statements.forEach(st -> {
            try {
                VirtualRelationship vrel = new VirtualRelationship(this.vNodes.get(st.getSubject().stringValue().replace("'", "'")), this.vNodes.get(st.getObject().stringValue().replace("'", "'")), RelationshipType.withName((String)this.handleIRI(st.getPredicate(), 0)));
                Map relProps = (Map)this.relProps.get(st);
                if (relProps != null) {
                    for (Map.Entry entry : relProps.entrySet()) {
                        vrel.setProperty((String)entry.getKey(), entry.getValue());
                    }
                }
                this.vRels.add(vrel);
            }
            catch (NamespacePrefixConflictException e) {
                e.printStackTrace();
            }
        });
    }

    private Map<String, Object> getPropsPlusUri(String uri) {
        Map props = (Map)this.resourceProps.get(uri);
        props.put("uri", uri);
        return props;
    }

    @Override
    protected void periodicOperation() {
    }
}

