/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.stream;

import java.util.ArrayList;
import java.util.List;
import n10s.ConfiguredStatementHandler;
import n10s.graphconfig.RDFParserConfig;
import n10s.result.StreamedStatement;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class StatementStreamer
extends ConfiguredStatementHandler {
    protected final RDFParserConfig parserConfig;
    protected List<StreamedStatement> statements;

    public StatementStreamer(RDFParserConfig pc) {
        this.parserConfig = pc;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.statements = new ArrayList<StreamedStatement>();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
    }

    @Override
    public void handleNamespace(String s, String s1) throws RDFHandlerException {
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if ((long)this.statements.size() < this.parserConfig.getStreamTripleLimit()) {
            if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(st.getPredicate().stringValue())) {
                Value object = st.getObject();
                StreamedStatement statement = new StreamedStatement(st.getSubject().stringValue(), st.getPredicate().stringValue(), object.stringValue(), object instanceof Literal, object instanceof Literal ? ((Literal)object).getDatatype().stringValue() : null, object instanceof Literal ? (String)((Literal)object).getLanguage().orElse(null) : null);
                this.statements.add(statement);
            }
        } else {
            throw new ConfiguredStatementHandler.TripleLimitReached(this.parserConfig.getStreamTripleLimit() + " triples streamed");
        }
    }

    @Override
    public void handleComment(String s) throws RDFHandlerException {
    }

    public List<StreamedStatement> getStatements() {
        return this.statements;
    }

    @Override
    public RDFParserConfig getParserConfig() {
        return this.parserConfig;
    }
}

