/*
 * Decompiled with CFR 0.152.
 */
package n10s.skos.load;

import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import n10s.CommonProcedures;
import n10s.RDFImportException;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.RDFParserConfig;
import n10s.rdf.RDFProcedures;
import n10s.skos.load.SkosImporter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SKOSLoadProcedures
extends RDFProcedures {
    @Procedure(name="n10s.skos.import.fetch", mode=Mode.WRITE)
    @Description(value="Imports classes, properties (dataType and Object), hierarchies thereof and domain and range info.")
    public Stream<RDFProcedures.ImportResults> importSKOSFromUrl(@Name(value="url") String url, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws RDFImportException {
        return Stream.of(this.doSkosImport(format, url, null, props));
    }

    @Procedure(name="n10s.skos.import.inline", mode=Mode.WRITE)
    @Description(value="Imports classes, properties (dataType and Object), hierarchies thereof and domain and range info.")
    public Stream<RDFProcedures.ImportResults> importSKOSInline(@Name(value="skosFragment") String skosFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws RDFImportException {
        return Stream.of(this.doSkosImport(format, null, skosFragment, props));
    }

    private RDFProcedures.ImportResults doSkosImport(String format, String url, String rdfFragment, Map<String, Object> props) throws RDFImportException {
        SkosImporter skosImporter = null;
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        RDFProcedures.ImportResults importResults = new RDFProcedures.ImportResults();
        try {
            this.checkConstraintExist();
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            skosImporter = new SkosImporter(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            importResults.setTerminationKO(e.getMessage());
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            importResults.setTerminationKO(e.getMessage());
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            throw new RDFImportException("A Graph Config is required for the SKOS import procedure to run");
        }
        if (skosImporter != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, skosImporter);
                importResults.setTriplesLoaded(skosImporter.totalTriplesMapped);
                importResults.setTriplesParsed(skosImporter.totalTriplesParsed);
                importResults.setConfigSummary(props);
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                importResults.setTerminationKO(e.getMessage());
                importResults.setTriplesLoaded(skosImporter.totalTriplesMapped);
                importResults.setTriplesParsed(skosImporter.totalTriplesParsed);
                importResults.setConfigSummary(props);
                e.printStackTrace();
            }
        }
        return importResults;
    }
}

