/*
 * Decompiled with CFR 0.152.
 */
package n10s.skos.load;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import n10s.RDFToLPGStatementProcessor;
import n10s.graphconfig.RDFParserConfig;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.model.vocabulary.SKOSXL;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class SkosImporter
extends RDFToLPGStatementProcessor {
    protected Map<String, String> resourceIndirectAltProps = new HashMap<String, String>();
    protected Map<String, String> resourceIndirectPrefProps = new HashMap<String, String>();
    protected Map<String, String> resourceIndirectHiddenProps = new HashMap<String, String>();
    protected Map<String, Literal> pendingLabels = new HashMap<String, Literal>();
    public static final Label RESOURCE = Label.label((String)"Resource");
    Cache<String, Node> nodeCache;

    protected SkosImporter(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Log l) {
        super(db, tx, conf, l);
        this.nodeCache = CacheBuilder.newBuilder().maximumSize(conf.getNodeCacheSize()).build();
    }

    @Override
    protected void periodicOperation() {
        block18: {
            Transaction tempTransaction;
            block17: {
                if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0) {
                    try {
                        tempTransaction = this.graphdb.beginTx();
                        try {
                            this.namespaces.partialRefresh(tempTransaction);
                            tempTransaction.commit();
                            this.log.debug("namespace prefixes synced: " + this.namespaces.toString());
                        }
                        finally {
                            if (tempTransaction != null) {
                                tempTransaction.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error("Problems syncing up namespace prefixes in partial commit. ", (Throwable)e);
                        if (!this.getParserConfig().isAbortOnError()) break block17;
                        throw new RDFToLPGStatementProcessor.NamespacePrefixConflict("Problems syncing up namespace prefixes in partial commit. ", e);
                    }
                }
            }
            try {
                tempTransaction = this.graphdb.beginTx();
                try {
                    this.runPartialTx(tempTransaction);
                    tempTransaction.commit();
                    this.log.debug("partial commit: " + this.mappedTripleCounter + " triples ingested. Total so far: " + this.totalTriplesMapped);
                    this.totalTriplesMapped += this.mappedTripleCounter;
                }
                finally {
                    if (tempTransaction != null) {
                        tempTransaction.close();
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Problems when running partial commit. Partial transaction rolled back. " + this.mappedTripleCounter + " triples lost.", (Throwable)e);
                if (!this.getParserConfig().isAbortOnError()) break block18;
                throw new RDFToLPGStatementProcessor.PartialCommitException("Problems when running partial commit. Partial transaction rolled back. ", e);
            }
        }
        this.mappedTripleCounter = 0L;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        if (this.parserConfig.getGraphConf().getHandleVocabUris() == 0 || this.parserConfig.getGraphConf().getHandleVocabUris() == 1) {
            this.namespaces.add(this.parserConfig.getGraphConf().getBaseSchemaNamespacePrefix(), this.parserConfig.getGraphConf().getBaseSchemaNamespace());
            this.log.debug("Added schema ns and prefix " + this.parserConfig.getGraphConf().getBaseSchemaNamespacePrefix() + ": " + this.parserConfig.getGraphConf().getBaseSchemaNamespace());
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.periodicOperation();
        int unusedExtra = 0;
        for (Map.Entry entry : this.resourceProps.entrySet()) {
            for (Map.Entry values : ((Map)entry.getValue()).entrySet()) {
                if (values.getValue() instanceof List) {
                    unusedExtra += ((List)values.getValue()).size();
                    continue;
                }
                ++unusedExtra;
            }
        }
        this.totalTriplesMapped -= (long)unusedExtra;
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(st.getPredicate().stringValue())) {
            if (st.getPredicate().equals(RDF.TYPE) && st.getObject().equals(SKOS.CONCEPT) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
            } else if ((st.getPredicate().equals(SKOS.BROADER) || st.getPredicate().equals(SKOS.RELATED)) && st.getObject() instanceof IRI && st.getSubject() instanceof IRI) {
                this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                this.addStatement(st);
            } else if (st.getPredicate().equals(SKOS.NARROWER) && st.getObject() instanceof IRI && st.getSubject() instanceof IRI) {
                this.instantiatePair("Resource", (IRI)st.getSubject(), "Resource", (IRI)st.getObject());
                this.addStatement(this.vf.createStatement((Resource)((IRI)st.getObject()), SKOS.BROADER, (Value)st.getSubject()));
            } else if ((st.getPredicate().equals(SKOS.PREF_LABEL) || st.getPredicate().equals(SKOS.ALT_LABEL) || st.getPredicate().equals(SKOS.HIDDEN_LABEL)) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
                this.setProp(st.getSubject().stringValue(), st.getPredicate(), (Literal)st.getObject());
            } else if ((st.getPredicate().equals(SKOSXL.PREF_LABEL) || st.getPredicate().equals(SKOSXL.ALT_LABEL) || st.getPredicate().equals(SKOSXL.HIDDEN_LABEL)) && st.getSubject() instanceof IRI) {
                this.instantiate(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getClassLabelName()), (IRI)st.getSubject());
                this.setIndirectPropFirstLeg(st.getSubject().stringValue(), st.getPredicate(), st.getObject().stringValue());
                ++this.mappedTripleCounter;
            } else if (st.getPredicate().equals(SKOSXL.LITERAL_FORM) && st.getObject() instanceof Literal) {
                this.setIndirectPropSecondLeg(st.getSubject().stringValue(), (Literal)st.getObject());
                ++this.mappedTripleCounter;
            }
        }
        ++this.totalTriplesParsed;
        if (this.parserConfig.getCommitSize() != Long.MAX_VALUE && this.mappedTripleCounter != 0L && this.mappedTripleCounter % this.parserConfig.getCommitSize() == 0L) {
            this.periodicOperation();
        }
    }

    private void instantiate(IRI label, IRI iri) {
        this.setLabel(iri.stringValue(), this.handleIRI(label, 1));
        ((Map)this.resourceProps.get(iri.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri.getLocalName());
        ++this.mappedTripleCounter;
    }

    private void instantiatePair(String label1, IRI iri1, String label2, IRI iri2) {
        this.setLabel(iri1.stringValue(), label1);
        ((Map)this.resourceProps.get(iri1.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri1.getLocalName());
        this.setLabel(iri2.stringValue(), label2);
        ((Map)this.resourceProps.get(iri2.stringValue())).put(this.handleIRI(this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "name"), 2), iri2.getLocalName());
        ++this.mappedTripleCounter;
    }

    private void setIndirectPropSecondLeg(String subject, Literal object) {
        if (this.resourceIndirectPrefProps.containsKey(subject)) {
            this.setProp(this.resourceIndirectPrefProps.get(subject), SKOS.PREF_LABEL, object);
        } else if (this.resourceIndirectAltProps.containsKey(subject)) {
            this.setProp(this.resourceIndirectAltProps.get(subject), SKOS.ALT_LABEL, object);
        } else if (this.resourceIndirectHiddenProps.containsKey(subject)) {
            this.setProp(this.resourceIndirectHiddenProps.get(subject), SKOS.HIDDEN_LABEL, object);
        } else {
            this.pendingLabels.put(subject, object);
        }
    }

    private void setIndirectPropFirstLeg(String subject, IRI predicate, String object) {
        if (this.pendingLabels.containsKey(object)) {
            this.setProp(subject, predicate, this.pendingLabels.get(object));
        } else if (predicate.equals(SKOSXL.PREF_LABEL)) {
            this.resourceIndirectPrefProps.put(object, subject);
        } else if (predicate.equals(SKOSXL.ALT_LABEL)) {
            this.resourceIndirectAltProps.put(object, subject);
        } else if (predicate.equals(SKOSXL.HIDDEN_LABEL)) {
            this.resourceIndirectHiddenProps.put(object, subject);
        }
    }

    public Integer runPartialTx(final Transaction inThreadTransaction) {
        for (final Map.Entry entry : this.resourceLabels.entrySet()) {
            try {
                if (((Set)entry.getValue()).isEmpty()) continue;
                Node node = this.nodeCache.get((String)entry.getKey(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        Node node = inThreadTransaction.findNode(RESOURCE, "uri", entry.getKey());
                        if (node == null) {
                            node = inThreadTransaction.createNode(new Label[]{RESOURCE});
                            node.setProperty("uri", entry.getKey());
                        }
                        return node;
                    }
                });
                ((Set)entry.getValue()).forEach(l -> node.addLabel(Label.label((String)l)));
                ((Map)this.resourceProps.get(entry.getKey())).forEach((k, v) -> {
                    if (v instanceof List) {
                        Object currentValue = node.getProperty(k, null);
                        if (currentValue == null) {
                            node.setProperty(k, this.toPropertyValue(v));
                        } else {
                            if (currentValue.getClass().isArray()) {
                                Object[] properties;
                                for (Object property : properties = (Object[])currentValue) {
                                    ((List)v).add(property);
                                }
                            } else {
                                ((List)v).add(node.getProperty(k));
                            }
                            node.setProperty(k, this.toPropertyValue(((List)v).stream().collect(Collectors.toSet())));
                        }
                    } else {
                        node.setProperty(k, v);
                    }
                });
                this.resourceProps.remove(entry.getKey());
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (final Statement st : this.statements) {
            try {
                Node fromNode = this.nodeCache.get(st.getSubject().stringValue(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        return inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getSubject().stringValue());
                    }
                });
                Node toNode = this.nodeCache.get(st.getObject().stringValue(), new Callable<Node>(){

                    @Override
                    public Node call() {
                        return inThreadTransaction.findNode(RESOURCE, "uri", (Object)st.getObject().stringValue());
                    }
                });
                boolean found = false;
                if (fromNode.getDegree(RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)), Direction.OUTGOING) < toNode.getDegree(RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)), Direction.INCOMING)) {
                    for (Relationship rel : fromNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0))})) {
                        if (!rel.getEndNode().equals(toNode)) continue;
                        found = true;
                        break;
                    }
                } else {
                    for (Relationship rel : toNode.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0))})) {
                        if (!rel.getStartNode().equals(fromNode)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                fromNode.createRelationshipTo(toNode, RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0)));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.statements.clear();
        this.resourceLabels.clear();
        this.resourceProps.clear();
        this.nodeCache.invalidateAll();
        return 0;
    }

    private IRI translateRelName(IRI iri) {
        if (iri.equals(SKOS.BROADER)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getSubClassOfRelName());
        }
        if (iri.equals(SKOS.RELATED)) {
            return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), this.parserConfig.getGraphConf().getRelatedConceptRelName());
        }
        return this.vf.createIRI(this.parserConfig.getGraphConf().getBaseSchemaNamespace(), "REL");
    }
}

