/*
 * Decompiled with CFR 0.152.
 */
package n10s.utils;

import n10s.graphconfig.GraphConfig;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.neo4j.graphdb.Transaction;

public class UriUtils {
    public static String translateUri(String uri, Transaction tx, GraphConfig gc) throws InvalidNamespacePrefixDefinitionInDB, UriNamespaceHasNoAssociatedPrefix {
        if (gc == null || gc.getGraphMode() == 1) {
            if ((gc != null ? gc.getBaseSchemaNamespace() : "neo4j://graph.schema#").equals(uri.substring(0, URIUtil.getLocalNameIndex(uri)))) {
                return uri.substring(URIUtil.getLocalNameIndex(uri));
            }
            return "__NONE__";
        }
        if (gc.getHandleVocabUris() == 0 || gc.getHandleVocabUris() == 1 || gc.getHandleVocabUris() == 3) {
            return UriUtils.getShortForm(uri, tx);
        }
        return uri;
    }

    public static String getShortForm(String str, Transaction tx) throws UriNamespaceHasNoAssociatedPrefix, InvalidNamespacePrefixDefinitionInDB {
        NsPrefixMap prefixDefs = new NsPrefixMap(tx, false);
        IRI iri = SimpleValueFactory.getInstance().createIRI(str);
        if (!prefixDefs.hasNs(iri.getNamespace())) {
            throw new UriNamespaceHasNoAssociatedPrefix("Prefix Undefined: No prefix defined for namespace <" + str + ">. Use n10s.nsprefixes.add(...) procedure.");
        }
        return prefixDefs.getPrefixForNs(iri.getNamespace()) + "__" + iri.getLocalName();
    }

    public static class UriNamespaceHasNoAssociatedPrefix
    extends Exception {
        public UriNamespaceHasNoAssociatedPrefix(String message) {
            super(message);
        }
    }
}

