/*
 * Decompiled with CFR 0.152.
 */
package n10s.experimental;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Stream;
import n10s.CommonProcedures;
import n10s.experimental.dimodel.DIModelBuilder;
import n10s.experimental.dimodel.DIModelSummary;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.UriUtils;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DataImporterProcedures
extends CommonProcedures {
    @Procedure(name="n10s.experimental.stream.dimodel.inline", mode=Mode.READ)
    @Description(value="Generates a data importer tool model aligned with the selected ontology")
    public Stream<DIModelSummary> streamDIModel(@Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams, InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        return this.doBuild(format, null, rdfFragment, props, false);
    }

    @Procedure(name="n10s.experimental.stream.dimodel.fetch", mode=Mode.READ)
    @Description(value="Generates a data importer tool model aligned with the selected ontology")
    public Stream<DIModelSummary> streamDIModelFromURL(@Name(value="url") String url, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams {
        return this.doBuild(format, url, null, props, false);
    }

    @Procedure(name="n10s.experimental.export.dimodel.inline", mode=Mode.READ)
    @Description(value="Generates a data importer tool model aligned with the selected ontology")
    public Stream<DIModelSummary> exportDIModel(@Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams, InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        return this.doBuild(format, null, rdfFragment, props, true);
    }

    @Procedure(name="n10s.experimental.export.dimodel.fetch", mode=Mode.READ)
    @Description(value="Generates a data importer tool model aligned with the selected ontology")
    public Stream<DIModelSummary> exportDIModelFromURL(@Name(value="url") String url, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws IOException, CommonProcedures.RDFImportBadParams {
        return this.doBuild(format, url, null, props, true);
    }

    private Stream<DIModelSummary> doBuild(String format, String url, String rdfFragment, Map<String, Object> props, boolean writeToFile) throws IOException, CommonProcedures.RDFImportBadParams {
        InputStream is = rdfFragment != null ? new ByteArrayInputStream(rdfFragment.getBytes(Charset.defaultCharset())) : this.getInputStream(url, props);
        DIModelBuilder dimb = new DIModelBuilder(this.tx, this.log);
        dimb.buildDIModel(is, this.getFormat(format), props);
        if (writeToFile) {
            return dimb.exportDIModelToFile(dimb.getModelAsSerialisableObject(), dimb.getModelMappings());
        }
        return dimb.exportDIModelAsString(dimb.getModelAsSerialisableObject(), dimb.getModelMappings());
    }
}

