/*
 * Decompiled with CFR 0.152.
 */
package n10s.experimental.dimodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class DIMNodeDef {
    public IRI nodeId;
    public Map<IRI, IRI> props;
    public Map<IRI, Set<IRI>> rels;
    public long x;
    public long y;

    public DIMNodeDef(IRI nodeId) {
        this.nodeId = nodeId;
        this.props = new HashMap<IRI, IRI>();
        this.props.put(RDFS.LABEL, XSD.STRING);
        this.props.put(RDFS.COMMENT, XSD.STRING);
        this.props.put(SimpleValueFactory.getInstance().createIRI("neo4j://graph.schema#uri"), XSD.STRING);
        this.rels = new HashMap<IRI, Set<IRI>>();
    }

    public String toString() {
        return "\nID: " + this.nodeId.getLocalName() + " \n - PROPS:" + this.mapAsString(this.props) + "\n - RELS:" + this.mapOfSetsAsString(this.rels);
    }

    private String mapAsString(Map<IRI, IRI> m) {
        StringBuilder sb = new StringBuilder();
        m.entrySet().forEach(x -> sb.append("\t").append(((IRI)x.getKey()).getLocalName()).append(":").append((IRI)x.getValue() != null ? ((IRI)x.getValue()).getLocalName() : " - "));
        return sb.toString();
    }

    private String mapOfSetsAsString(Map<IRI, Set<IRI>> m) {
        StringBuilder sb = new StringBuilder();
        m.entrySet().forEach(x -> {
            sb.append("\t").append(((IRI)x.getKey()).getLocalName()).append(":");
            ((Set)x.getValue()).forEach(r -> sb.append("\t").append(r.getLocalName()));
        });
        return sb.toString();
    }

    public Map<String, Object> getNodeSchemasAsJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("label", this.nodeId.getLocalName());
        map.put("additionLabels", new ArrayList());
        map.put("labelProperties", new ArrayList());
        ArrayList properties = new ArrayList();
        map.put("properties", properties);
        this.props.forEach((k, v) -> {
            HashMap<String, String> prop = new HashMap<String, String>();
            prop.put("property", k.getLocalName());
            prop.put("type", v != null ? this.convertToDIDataType((IRI)v) : "string");
            prop.put("identifier", k.stringValue());
            properties.add(prop);
        });
        HashMap<String, Object> key = new HashMap<String, Object>();
        map.put("key", key);
        key.put("properties", Collections.EMPTY_LIST);
        key.put("name", "");
        return map;
    }

    private String convertToDIDataType(IRI datatype) {
        if (datatype.equals(XSD.INTEGER) || datatype.equals(XSD.INT) || datatype.equals(XSD.POSITIVE_INTEGER) || datatype.equals(XSD.NEGATIVE_INTEGER) || datatype.equals(XSD.NON_POSITIVE_INTEGER) || datatype.equals(XSD.NON_NEGATIVE_INTEGER) || datatype.equals(XSD.LONG) || datatype.equals(XSD.SHORT) || datatype.equals(XSD.UNSIGNED_LONG) || datatype.equals(XSD.UNSIGNED_SHORT)) {
            return "integer";
        }
        if (datatype.equals(XSD.DECIMAL) || datatype.equals(XSD.FLOAT) || datatype.equals(XSD.DOUBLE)) {
            return "float";
        }
        if (datatype.equals(XSD.BOOLEAN)) {
            return "boolean";
        }
        return "string";
    }

    public Map<String, Object> getRelSchemasAsJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.rels.forEach((k, v) -> v.forEach(r -> {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("type", k.getLocalName());
            prop.put("sourceNodeSchema", this.nodeId.stringValue());
            prop.put("targetNodeSchema", r.stringValue());
            prop.put("properties", Collections.EMPTY_LIST);
            map.put(this.nodeId.stringValue() + k.stringValue() + r.stringValue(), prop);
        }));
        return map;
    }

    public Map<String, Object> getNodeMappingsAsJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeSchema", this.nodeId.stringValue());
        map.put("mappings", new ArrayList());
        return map;
    }

    public Map<String, Object> getRelsMappingsAsJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.rels.forEach((k, v) -> v.forEach(r -> {
            HashMap<String, Object> relMap = new HashMap<String, Object>();
            relMap.put("relationshipSchema", this.nodeId.stringValue() + k.stringValue() + r.stringValue());
            relMap.put("mappings", Collections.EMPTY_LIST);
            relMap.put("sourceMappings", Collections.EMPTY_LIST);
            relMap.put("targetMappings", Collections.EMPTY_LIST);
            map.put(this.nodeId.stringValue() + k.stringValue() + r.stringValue(), relMap);
        }));
        return map;
    }

    public Map<String, Object> getGraphNodeAsJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.nodeId.stringValue());
        HashMap<String, Long> position = new HashMap<String, Long>();
        position.put("x", this.x);
        position.put("y", this.y);
        map.put("position", position);
        map.put("caption", this.nodeId.getLocalName());
        return map;
    }

    public List<Object> getGraphRelsAsJsonObject() {
        ArrayList<Object> graphrels = new ArrayList<Object>();
        this.rels.forEach((k, v) -> v.forEach(r -> {
            HashMap<String, Object> rel = new HashMap<String, Object>();
            rel.put("id", this.nodeId.stringValue() + k.stringValue() + r.stringValue());
            rel.put("type", k.getLocalName());
            rel.put("fromId", this.nodeId.stringValue());
            rel.put("toId", r.stringValue());
            graphrels.add(rel);
        }));
        return graphrels;
    }

    public void addProp(IRI prop, IRI datatype) {
        this.props.put(prop, datatype);
    }

    public void addRel(IRI rel, IRI range) {
        if (this.rels.containsKey(rel)) {
            Set<IRI> existingSet = this.rels.get(rel);
            existingSet.add(range);
        } else {
            HashSet<IRI> newSet = new HashSet<IRI>();
            newSet.add(range);
            this.rels.put(rel, newSet);
        }
    }

    public void setPos(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public int getRelCount() {
        return this.rels.values().stream().map(s -> s.size()).reduce(0, Integer::sum);
    }
}

