/*
 * Decompiled with CFR 0.152.
 */
package n10s.experimental.dimodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import n10s.experimental.dimodel.DIMNodeDef;
import n10s.experimental.dimodel.DIModelSummary;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DIModelBuilder {
    private Map<IRI, DIMNodeDef> modelDef = new HashMap<IRI, DIMNodeDef>();
    private static int MAX_NUM_NODES = 25;
    private static int MAX_NUM_RELS = 250;
    public static String catsQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nselect distinct ?explicit ?parent\nwhere {\n  ?explicit rdfs:subClassOf* ?parent\n    filter( ?explicit in ( %s ) && isIRI(?parent))\n  }\n";
    public static String allCatsQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nselect distinct ?explicit ?parent\nwhere {\n  ?explicit a ?classtype    \n    filter( (?classtype in ( owl:Class, rdfs:Class )) && not exists { ?x rdfs:subClassOf ?explicit })\n   \n  ?explicit rdfs:subClassOf* ?parent\n    filter( isIRI(?parent) )\n  }";
    public static String relsQuery = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sch: <https://schema.org/>\nselect distinct ?prop ?domain ?range\nwhere {\n\n   filter(?domain in ( %s )\n    && ?range in ( %s ))\n  \n  ?prop a ?propertyClass .\n  filter(?propertyClass in (rdf:Property, owl:ObjectProperty, owl:FunctionalProperty, owl:AsymmetricProperty,  owl:InverseFunctionalProperty, owl:IrreflexiveProperty, owl:ReflexiveProperty, owl:SymmetricProperty, owl:TransitiveProperty))\n\n  {\n    ?prop ?domainPred ?domain ; ?rangePred ?range .\n    \tfilter(?domainPred in (sch:domainIncludes, rdfs:domain) && ?rangePred in (sch:rangeIncludes, rdfs:range))\n  } union {\n    ?prop ?domainPred [ owl:unionOf/rdf:rest*/rdf:first  ?domain ]\n          filter(?domainPred in (sch:domainIncludes, rdfs:domain) )\n  } union {\n    ?domain rdfs:subClassOf [ a                   owl:Restriction ;\n                            owl:onProperty      ?prop ;\n                            ?restrictionPred  ?range\n                          ] ;\n          filter(?restrictionPred in (owl:someValuesFrom, owl:allValuesFrom ))\n  } union {\n    ?domain rdfs:subClassOf [ a                   owl:Restriction ;\n                            owl:onProperty      ?prop ;\n                            ?cardinalityRestriction  ?card ;\n        \t\t\t\t\towl:onClass ?range \n                          ] ;\n          filter(?cardinalityRestriction in (owl:qualifiedCardinality, owl:minQualifiedCardinality,   owl:maxQualifiedCardinality ))\n  }\n\n}";
    public static String propsQuery = "PREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sch: <https://schema.org/>\nselect distinct ?prop ?domain ?range\nwhere {\n\n  ?prop a ?propertyClass .\n  filter(?propertyClass in (rdf:Property, owl:DatatypeProperty, owl:FunctionalProperty ))\n\n  {\n    ?prop ?domainPred ?domain\n    \tfilter(?domainPred in (sch:domainIncludes, rdfs:domain) &&\n        \t?domain in ( %s ))\n  } union {\n    ?prop ?domainPred [ owl:unionOf/rdf:rest*/rdf:first  ?domain ]\n          filter(?domainPred in (sch:domainIncludes, rdfs:domain) &&\n             ?domain in ( %s ))\n  }\n\n  optional {\n    ?prop ?rangePred ?range\n    filter(?rangePred in (sch:rangeIncludes, rdfs:range) &&    (?range in ( sch:Text ) || regex(str(?range),\"^http://www.w3.org/2001/XMLSchema#.*\")))\n  }\n\n}";

    public DIModelBuilder(Transaction tx, Log log) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buildDIModel(InputStream is, RDFFormat format, Map<String, Object> props) throws IOException {
        String urilist;
        HashMap<IRI, Set<IRI>> uriMap = new HashMap<IRI, Set<IRI>>();
        if (props.containsKey("classList")) {
            if (!(props.get("classList") instanceof List)) throw new IllegalArgumentException("classList must contain a list of uris (strings)");
            urilist = !((List)props.get("classList")).isEmpty() ? this.formatUriList((List)props.get("classList")) : null;
        } else {
            urilist = null;
        }
        SailRepository repo = new SailRepository(new MemoryStore());
        try (RepositoryConnection conn = repo.getConnection();){
            conn.begin();
            conn.add((Reader)new InputStreamReader(is), "http://neo4j.com/base/", format, new Resource[0]);
            conn.commit();
            TupleQuery tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, urilist != null ? String.format(catsQuery, urilist) : allCatsQuery);
            TupleQueryResult queryResult = tupleQuery.evaluate();
            HashSet<IRI> allClasses = new HashSet<IRI>();
            while (queryResult.hasNext()) {
                BindingSet next = (BindingSet)queryResult.next();
                allClasses.add((IRI)next.getValue("parent"));
                if (uriMap.containsKey(next.getValue("parent"))) {
                    Set existingSet = (Set)uriMap.get(next.getValue("parent"));
                    existingSet.add((IRI)next.getValue("explicit"));
                    continue;
                }
                HashSet<IRI> newSet = new HashSet<IRI>();
                newSet.add((IRI)next.getValue("explicit"));
                uriMap.put((IRI)next.getValue("parent"), newSet);
            }
            StringBuilder sb = new StringBuilder();
            allClasses.forEach(c -> sb.append(", <").append(c.stringValue()).append(">"));
            urilist = sb.length() > 0 ? sb.substring(1) : sb.toString();
            HashSet explicitClassSet = new HashSet();
            uriMap.values().forEach(s -> explicitClassSet.addAll(s));
            if (explicitClassSet.size() > MAX_NUM_NODES) {
                throw new RuntimeException("The ontology contains a large number of classes (" + explicitClassSet.size() + " leaf classes) that would generate an unusable model. Please select a subset using the 'classList' parameter. ");
            }
            explicitClassSet.forEach(c -> this.modelDef.put((IRI)c, new DIMNodeDef((IRI)c)));
            this.addRels(String.format(relsQuery, urilist, urilist), uriMap, conn);
            if (this.modelDef.values().stream().map(md -> md.getRelCount()).reduce(0, Integer::sum) > MAX_NUM_RELS) {
                throw new RuntimeException("The ontology contains a large number of classes and relationships ( " + this.modelDef.values().stream().map(md -> md.getRelCount()).reduce(0, Integer::sum) + " ) that would generate an unusable model. Please select a subset using the 'classList' parameter. ");
            }
            this.addProps(String.format(propsQuery, urilist, urilist), uriMap, conn);
            return;
        }
    }

    private String printModelDefSummary() {
        StringBuilder sb = new StringBuilder();
        for (DIMNodeDef d : this.modelDef.values()) {
            sb.append(d);
        }
        return sb.toString();
    }

    public Map<String, Object> getModelAsSerialisableObject() {
        this.assignPositionsToNodes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", "0.1.1-beta.0");
        HashMap graph = new HashMap();
        map.put("graph", graph);
        ArrayList graphNodes = new ArrayList();
        graph.put("nodes", graphNodes);
        this.modelDef.forEach((k, v) -> graphNodes.add(v.getGraphNodeAsJsonObject()));
        ArrayList graphRels = new ArrayList();
        graph.put("relationships", graphRels);
        this.modelDef.forEach((k, v) -> graphRels.addAll(v.getGraphRelsAsJsonObject()));
        HashMap datamodel = new HashMap();
        map.put("dataModel", datamodel);
        HashMap<String, Map> filemodel = new HashMap<String, Map>();
        datamodel.put("fileModel", filemodel);
        filemodel.put("fileSchemas", Collections.EMPTY_MAP);
        HashMap graphmodel = new HashMap();
        datamodel.put("graphModel", graphmodel);
        HashMap nodeSchemas = new HashMap();
        graphmodel.put("nodeSchemas", nodeSchemas);
        this.modelDef.forEach((k, v) -> nodeSchemas.put(k.stringValue(), v.getNodeSchemasAsJsonObject()));
        HashMap relSchemas = new HashMap();
        graphmodel.put("relationshipSchemas", relSchemas);
        this.modelDef.forEach((k, v) -> relSchemas.putAll(v.getRelSchemasAsJsonObject()));
        HashMap mappingModel = new HashMap();
        datamodel.put("mappingModel", mappingModel);
        HashMap nodeMappings = new HashMap();
        mappingModel.put("nodeMappings", nodeMappings);
        this.modelDef.forEach((k, v) -> nodeMappings.put(k.stringValue(), v.getNodeMappingsAsJsonObject()));
        HashMap relMappings = new HashMap();
        mappingModel.put("relationshipMappings", relMappings);
        this.modelDef.forEach((k, v) -> relMappings.putAll(v.getRelsMappingsAsJsonObject()));
        return map;
    }

    private void assignPositionsToNodes() {
        long rows = Math.round(Math.sqrt(this.modelDef.size() / 2));
        if (rows == 0L) {
            rows = 1L;
        }
        long cols = 2L * rows;
        long step_h = 2400L / cols;
        long step_v = 1200L / rows;
        long x_start = -1000L + step_h / 2L;
        long y_start = step_v / 2L;
        int i = 0;
        for (IRI n : this.modelDef.keySet()) {
            this.modelDef.get(n).setPos(x_start + (long)i % cols * step_h, y_start + (long)i / cols * step_v);
            ++i;
        }
    }

    private void addProps(String theQuery, Map<IRI, Set<IRI>> uriMap, RepositoryConnection conn) {
        TupleQuery tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, theQuery);
        TupleQueryResult queryResult = tupleQuery.evaluate();
        while (queryResult.hasNext()) {
            BindingSet next = (BindingSet)queryResult.next();
            Set<IRI> domains = uriMap.get((IRI)next.getValue("domain"));
            for (IRI domain : domains) {
                DIMNodeDef nd = this.modelDef.get(domain);
                nd.addProp((IRI)next.getValue("prop"), (IRI)next.getValue("range"));
            }
        }
    }

    private void addRels(String theQuery, Map<IRI, Set<IRI>> uriMap, RepositoryConnection conn) {
        TupleQuery tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, theQuery);
        TupleQueryResult queryResult = tupleQuery.evaluate();
        while (queryResult.hasNext()) {
            BindingSet next = (BindingSet)queryResult.next();
            Set<IRI> domains = uriMap.get((IRI)next.getValue("domain"));
            for (IRI domain : domains) {
                DIMNodeDef nd = this.modelDef.get(domain);
                Set<IRI> ranges = uriMap.get((IRI)next.getValue("range"));
                for (IRI range : ranges) {
                    nd.addRel((IRI)next.getValue("prop"), range);
                }
            }
        }
    }

    private String formatUriList(List urilist) {
        StringBuilder sb = new StringBuilder();
        urilist.forEach(s -> sb.append(", <").append(s).append(">"));
        return sb.substring(1);
    }

    public Stream<DIModelSummary> exportDIModelToFile(Map<String, Object> map, String mappings) throws IOException {
        File configFile = new File(Stream.of(System.getProperty("sun.java.command").split("--")).map(String::trim).filter(s -> s.startsWith("config-dir=")).map(s -> s.substring("config-dir=".length())).findFirst().orElse(".").concat(File.separator).concat("neo4j.conf"));
        Properties p = new Properties();
        p.load(new FileReader(configFile));
        String importFolderPath = p.contains("dbms.directories.import") ? p.get("dbms.directories.import").toString() : "import";
        File diModelFileName = new File(Stream.of(System.getProperty("sun.java.command").split("--")).map(String::trim).filter(s -> s.startsWith("home-dir=")).map(s -> s.substring("home-dir=".length())).findFirst().orElse(".").concat(File.separator).concat(importFolderPath).concat(File.separator).concat("diModel.json"));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(diModelFileName));
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, map);
        return Stream.of(new DIModelSummary(diModelFileName.getAbsolutePath(), mappings, this.printModelDefSummary()));
    }

    public Stream<DIModelSummary> exportDIModelAsString(Map<String, Object> map, String mappings) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return Stream.of(new DIModelSummary(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(map), mappings, this.printModelDefSummary()));
    }

    public String getModelMappings() {
        HashMap<String, String> standardns = new HashMap<String, String>();
        standardns.put("http://schema.org/", "sch");
        standardns.put("http://www.w3.org/2004/02/skos/core#", "skos");
        standardns.put("http://www.w3.org/2008/05/skos-xl#", "skosxl");
        standardns.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        standardns.put("http://www.w3.org/2002/07/owl#", "owl");
        standardns.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        standardns.put("http://www.w3.org/ns/shacl#", "sh");
        standardns.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        HashSet namespaces = new HashSet();
        HashSet schemaElements = new HashSet();
        this.modelDef.forEach((className, ndef) -> {
            namespaces.add(className.getNamespace());
            schemaElements.add(className);
            ndef.props.forEach((propname, type) -> {
                if (!propname.stringValue().equals("neo4j://graph.schema#uri")) {
                    namespaces.add(propname.getNamespace());
                    schemaElements.add(propname);
                }
            });
            ndef.rels.forEach((relname, range) -> {
                namespaces.add(relname.getNamespace());
                schemaElements.add(relname);
            });
        });
        int nscount = 1;
        StringBuilder sb = new StringBuilder();
        for (String ns : namespaces) {
            sb.append("CALL n10s.nsprefixes.add(\"");
            if (standardns.containsKey(ns)) {
                sb.append((String)standardns.get(ns));
            } else {
                sb.append("ns").append(nscount++);
            }
            sb.append("\",\"" + ns + "\");").append("\n");
        }
        sb.append("\n\n");
        schemaElements.forEach(se -> sb.append("CALL n10s.mapping.add(\"" + se + "\", \"" + se.getLocalName() + "\");").append("\n"));
        return sb.toString();
    }
}

