/*
 * Decompiled with CFR 0.152.
 */
package n10s.graphconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import n10s.graphconfig.Params;
import n10s.result.GraphConfigItemResult;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class GraphConfig {
    public static final int GRAPHCONF_MODE_LPG = 1;
    public static final int GRAPHCONF_MODE_RDF = 2;
    public static final int GRAPHCONF_VOC_URI_SHORTEN = 0;
    public static final int GRAPHCONF_VOC_URI_SHORTEN_STRICT = 1;
    public static final int GRAPHCONF_VOC_URI_IGNORE = 2;
    public static final int GRAPHCONF_VOC_URI_MAP = 3;
    public static final int GRAPHCONF_VOC_URI_KEEP = 4;
    public static final String GRAPHCONF_VOC_URI_SHORTEN_STR = "SHORTEN";
    public static final String GRAPHCONF_VOC_URI_SHORTEN_STRICT_STR = "SHORTEN_STRICT";
    public static final String GRAPHCONF_VOC_URI_IGNORE_STR = "IGNORE";
    public static final String GRAPHCONF_VOC_URI_MAP_STR = "MAP";
    public static final String GRAPHCONF_VOC_URI_KEEP_STR = "KEEP";
    public static final int GRAPHCONF_MULTIVAL_PROP_OVERWRITE = 0;
    public static final int GRAPHCONF_MULTIVAL_PROP_ARRAY = 1;
    public static final String GRAPHCONF_MULTIVAL_PROP_OVERWRITE_STR = "OVERWRITE";
    public static final String GRAPHCONF_MULTIVAL_PROP_ARRAY_STR = "ARRAY";
    public static final int GRAPHCONF_RDFTYPES_AS_LABELS = 0;
    public static final int GRAPHCONF_RDFTYPES_AS_NODES = 1;
    public static final int GRAPHCONF_RDFTYPES_AS_LABELS_AND_NODES = 2;
    public static final String GRAPHCONF_RDFTYPES_AS_LABELS_STR = "LABELS";
    public static final String GRAPHCONF_RDFTYPES_AS_NODES_STR = "NODES";
    public static final String GRAPHCONF_RDFTYPES_AS_LABELS_AND_NODES_STR = "LABELS_AND_NODES";
    private static final String DEFAULT_CLASS_LABEL_NAME = "Class";
    private static final String DEFAULT_SCO_REL_NAME = "SCO";
    private static final String DEFAULT_DATATYPEPROP_LABEL_NAME = "Property";
    private static final String DEFAULT_OBJECTPROP_LABEL_NAME = "Relationship";
    private static final String DEFAULT_SPO_REL_NAME = "SPO";
    private static final String DEFAULT_DOMAIN_REL_NAME = "DOMAIN";
    private static final String DEFAULT_RANGE_REL_NAME = "RANGE";
    private int handleVocabUris;
    private int handleMultival;
    private int handleRDFTypes;
    private boolean keepLangTag;
    private boolean applyNeo4jNaming;
    private boolean keepCustomDataTypes;
    private Set<String> multivalPropList;
    private Set<String> customDataTypePropList;
    private String classLabelName;
    private String subClassOfRelName;
    private String dataTypePropertyLabelName;
    private String objectPropertyLabelName;
    private String subPropertyOfRelName;
    private String domainRelName;
    private String rangeRelName;
    private String baseSchemaNamespace;
    private String baseSchemaNamespacePrefix;

    public GraphConfig(Map<String, Object> props) throws InvalidParamException {
        Matcher matcher;
        this.handleVocabUris = props.containsKey("handleVocabUris") ? this.parseHandleVocabUrisValue((String)props.get("handleVocabUris")) : 0;
        this.handleMultival = props.containsKey("handleMultival") ? this.parseHandleMultivalValue((String)props.get("handleMultival")) : 0;
        this.handleRDFTypes = props.containsKey("handleRDFTypes") ? this.parseHandleRDFTypesValue((String)props.get("handleRDFTypes")) : 0;
        this.keepLangTag = props.containsKey("keepLangTag") && (Boolean)props.get("keepLangTag") != false;
        this.applyNeo4jNaming = props.containsKey("applyNeo4jNaming") && (Boolean)props.get("applyNeo4jNaming") != false;
        boolean bl = this.keepCustomDataTypes = props.containsKey("keepCustomDataTypes") && (Boolean)props.get("keepCustomDataTypes") != false;
        Set<Object> set = props.containsKey("multivalPropList") ? (props.get("multivalPropList") != null ? ((List)props.get("multivalPropList")).stream().collect(Collectors.toSet()) : null) : (this.multivalPropList = null);
        this.customDataTypePropList = props.containsKey("customDataTypePropList") ? (props.get("customDataTypePropList") != null ? ((List)props.get("customDataTypePropList")).stream().collect(Collectors.toSet()) : null) : null;
        String string = this.baseSchemaNamespace = props.containsKey("baseSchemaNamespace") && URIUtil.isCorrectURISplit((String)props.get("baseSchemaNamespace"), "someLocalName") ? (String)props.get("baseSchemaNamespace") : null;
        this.baseSchemaNamespacePrefix = props.containsKey("baseSchemaPrefix") ? ((matcher = Params.PREFIX_PATTERN.matcher((String)props.get("baseSchemaPrefix"))).matches() ? (String)props.get("baseSchemaPrefix") : null) : null;
        this.classLabelName = props.containsKey("classLabel") ? (String)props.get("classLabel") : DEFAULT_CLASS_LABEL_NAME;
        this.subClassOfRelName = props.containsKey("subClassOfRel") ? (String)props.get("subClassOfRel") : DEFAULT_SCO_REL_NAME;
        this.dataTypePropertyLabelName = props.containsKey("dataTypePropertyLabel") ? (String)props.get("dataTypePropertyLabel") : DEFAULT_DATATYPEPROP_LABEL_NAME;
        this.objectPropertyLabelName = props.containsKey("objectPropertyLabel") ? (String)props.get("objectPropertyLabel") : DEFAULT_OBJECTPROP_LABEL_NAME;
        this.subPropertyOfRelName = props.containsKey("subPropertyOfRel") ? (String)props.get("subPropertyOfRel") : DEFAULT_SPO_REL_NAME;
        this.domainRelName = props.containsKey("domainRel") ? (String)props.get("domainRel") : DEFAULT_DOMAIN_REL_NAME;
        this.rangeRelName = props.containsKey("rangeRel") ? (String)props.get("rangeRel") : DEFAULT_RANGE_REL_NAME;
    }

    public GraphConfig(Transaction tx) throws GraphConfigNotFound {
        Result gcResult = tx.execute("MATCH (gc:_GraphConfig) RETURN gc ");
        if (!gcResult.hasNext()) {
            throw new GraphConfigNotFound();
        }
        Map singleRecord = gcResult.next();
        Map graphConfigProperties = ((Node)singleRecord.get("gc")).getAllProperties();
        this.handleVocabUris = (Integer)graphConfigProperties.get("_handleVocabUris");
        this.handleMultival = (Integer)graphConfigProperties.get("_handleMultival");
        this.handleRDFTypes = (Integer)graphConfigProperties.get("_handleRDFTypes");
        this.keepLangTag = (Boolean)graphConfigProperties.get("_keepLangTag");
        this.keepCustomDataTypes = (Boolean)graphConfigProperties.get("_keepCustomDataTypes");
        this.applyNeo4jNaming = (Boolean)graphConfigProperties.get("_applyNeo4jNaming");
        this.multivalPropList = this.getListOfStringsOrNull(graphConfigProperties, "_multivalPropList");
        this.customDataTypePropList = this.getListOfStringsOrNull(graphConfigProperties, "_customDataTypePropList");
        this.baseSchemaNamespace = (String)graphConfigProperties.get("_baseSchemaNamespace");
        this.baseSchemaNamespacePrefix = (String)graphConfigProperties.get("_baseSchemaPrefix");
        this.classLabelName = graphConfigProperties.containsKey("_classLabel") ? (String)graphConfigProperties.get("_classLabel") : DEFAULT_CLASS_LABEL_NAME;
        this.subClassOfRelName = graphConfigProperties.containsKey("_subClassOfRel") ? (String)graphConfigProperties.get("_subClassOfRel") : DEFAULT_SCO_REL_NAME;
        this.dataTypePropertyLabelName = graphConfigProperties.containsKey("_dataTypePropertyLabel") ? (String)graphConfigProperties.get("_dataTypePropertyLabel") : DEFAULT_DATATYPEPROP_LABEL_NAME;
        this.objectPropertyLabelName = graphConfigProperties.containsKey("_objectPropertyLabel") ? (String)graphConfigProperties.get("_objectPropertyLabel") : DEFAULT_OBJECTPROP_LABEL_NAME;
        this.subPropertyOfRelName = graphConfigProperties.containsKey("_subPropertyOfRel") ? (String)graphConfigProperties.get("_subPropertyOfRel") : DEFAULT_SPO_REL_NAME;
        this.domainRelName = graphConfigProperties.containsKey("_domainRel") ? (String)graphConfigProperties.get("_domainRel") : DEFAULT_DOMAIN_REL_NAME;
        this.rangeRelName = graphConfigProperties.containsKey("_rangeRel") ? (String)graphConfigProperties.get("_rangeRel") : DEFAULT_RANGE_REL_NAME;
    }

    private Set<String> getListOfStringsOrNull(Map<String, Object> gcp, String key) {
        if (gcp.containsKey(key)) {
            String[] arrayOfStrings;
            HashSet<String> resultSet = new HashSet<String>();
            for (String str : arrayOfStrings = (String[])gcp.get(key)) {
                resultSet.add(str);
            }
            return resultSet;
        }
        return null;
    }

    public int getGraphMode() {
        if (this.handleVocabUris == 0 || this.handleVocabUris == 1 || this.handleVocabUris == 4) {
            return 2;
        }
        if (this.handleVocabUris == 2 || this.handleVocabUris == 3) {
            return 1;
        }
        return 1;
    }

    public int parseHandleVocabUrisValue(String handleVocUrisAsText) throws InvalidParamException {
        if (handleVocUrisAsText.equals(GRAPHCONF_VOC_URI_SHORTEN_STR)) {
            return 0;
        }
        if (handleVocUrisAsText.equals(GRAPHCONF_VOC_URI_SHORTEN_STRICT_STR)) {
            return 1;
        }
        if (handleVocUrisAsText.equals(GRAPHCONF_VOC_URI_IGNORE_STR)) {
            return 2;
        }
        if (handleVocUrisAsText.equals(GRAPHCONF_VOC_URI_MAP_STR)) {
            return 3;
        }
        if (handleVocUrisAsText.equals(GRAPHCONF_VOC_URI_KEEP_STR)) {
            return 4;
        }
        throw new InvalidParamException(handleVocUrisAsText + " is not a valid option for param 'handleVocabUris'");
    }

    public int parseHandleMultivalValue(String multivalAsText) throws InvalidParamException {
        if (multivalAsText.equals(GRAPHCONF_MULTIVAL_PROP_OVERWRITE_STR)) {
            return 0;
        }
        if (multivalAsText.equals(GRAPHCONF_MULTIVAL_PROP_ARRAY_STR)) {
            return 1;
        }
        throw new InvalidParamException(multivalAsText + " is not a valid option for param 'handleMultival'");
    }

    private int parseHandleRDFTypesValue(String handleRDFTypesAsText) throws InvalidParamException {
        if (handleRDFTypesAsText.equals(GRAPHCONF_RDFTYPES_AS_LABELS_STR)) {
            return 0;
        }
        if (handleRDFTypesAsText.equals(GRAPHCONF_RDFTYPES_AS_NODES_STR)) {
            return 1;
        }
        if (handleRDFTypesAsText.equals(GRAPHCONF_RDFTYPES_AS_LABELS_AND_NODES_STR)) {
            return 2;
        }
        throw new InvalidParamException(handleRDFTypesAsText + " is not a valid option for param 'handleRDFTypes'");
    }

    public String getHandleVocabUrisAsString() {
        switch (this.handleVocabUris) {
            case 0: {
                return GRAPHCONF_VOC_URI_SHORTEN_STR;
            }
            case 1: {
                return GRAPHCONF_VOC_URI_SHORTEN_STRICT_STR;
            }
            case 2: {
                return GRAPHCONF_VOC_URI_IGNORE_STR;
            }
            case 3: {
                return GRAPHCONF_VOC_URI_MAP_STR;
            }
        }
        return GRAPHCONF_VOC_URI_KEEP_STR;
    }

    public String getHandleMultivalAsString() {
        switch (this.handleMultival) {
            case 0: {
                return GRAPHCONF_MULTIVAL_PROP_OVERWRITE_STR;
            }
            case 1: {
                return GRAPHCONF_MULTIVAL_PROP_ARRAY_STR;
            }
        }
        return GRAPHCONF_MULTIVAL_PROP_OVERWRITE_STR;
    }

    public String getHandleRDFTypesAsString() {
        switch (this.handleRDFTypes) {
            case 0: {
                return GRAPHCONF_RDFTYPES_AS_LABELS_STR;
            }
            case 1: {
                return GRAPHCONF_RDFTYPES_AS_NODES_STR;
            }
            case 2: {
                return GRAPHCONF_RDFTYPES_AS_LABELS_AND_NODES_STR;
            }
        }
        return GRAPHCONF_RDFTYPES_AS_LABELS_STR;
    }

    public List<GraphConfigItemResult> getAsGraphConfigResults() {
        ArrayList<GraphConfigItemResult> result = new ArrayList<GraphConfigItemResult>();
        result.add(new GraphConfigItemResult("handleVocabUris", this.getHandleVocabUrisAsString()));
        result.add(new GraphConfigItemResult("handleMultival", this.getHandleMultivalAsString()));
        result.add(new GraphConfigItemResult("handleRDFTypes", this.getHandleRDFTypesAsString()));
        result.add(new GraphConfigItemResult("keepLangTag", this.isKeepLangTag()));
        if (this.getMultivalPropList() != null) {
            result.add(new GraphConfigItemResult("multivalPropList", this.getMultivalPropList()));
        }
        result.add(new GraphConfigItemResult("keepCustomDataTypes", this.isKeepCustomDataTypes()));
        if (this.getCustomDataTypePropList() != null) {
            result.add(new GraphConfigItemResult("customDataTypePropList", this.getCustomDataTypePropList()));
        }
        result.add(new GraphConfigItemResult("applyNeo4jNaming", this.isApplyNeo4jNaming()));
        if (this.getBaseSchemaNamespace() != null) {
            result.add(new GraphConfigItemResult("baseSchemaNamespace", this.getBaseSchemaNamespace()));
        }
        if (this.getBaseSchemaNamespacePrefix() != null) {
            result.add(new GraphConfigItemResult("baseSchemaPrefix", this.getBaseSchemaNamespacePrefix()));
        }
        result.add(new GraphConfigItemResult("classLabel", this.getClassLabelName()));
        result.add(new GraphConfigItemResult("subClassOfRel", this.getSubClassOfRelName()));
        result.add(new GraphConfigItemResult("dataTypePropertyLabel", this.getDataTypePropertyLabelName()));
        result.add(new GraphConfigItemResult("objectPropertyLabel", this.getObjectPropertyLabelName()));
        result.add(new GraphConfigItemResult("subPropertyOfRel", this.getSubPropertyOfRelName()));
        result.add(new GraphConfigItemResult("domainRel", this.getDomainRelName()));
        result.add(new GraphConfigItemResult("rangeRel", this.getRangeRelName()));
        return result;
    }

    public Map<String, Object> serialiseConfig() {
        HashMap<String, Object> configAsMap = new HashMap<String, Object>();
        configAsMap.put("_handleVocabUris", this.handleVocabUris);
        configAsMap.put("_handleMultival", this.handleMultival);
        configAsMap.put("_handleRDFTypes", this.handleRDFTypes);
        configAsMap.put("_keepLangTag", this.keepLangTag);
        configAsMap.put("_keepCustomDataTypes", this.keepCustomDataTypes);
        configAsMap.put("_applyNeo4jNaming", this.applyNeo4jNaming);
        configAsMap.put("_multivalPropList", this.multivalPropList);
        configAsMap.put("_customDataTypePropList", this.customDataTypePropList);
        configAsMap.put("_baseSchemaNamespace", this.baseSchemaNamespace);
        configAsMap.put("_baseSchemaPrefix", this.baseSchemaNamespacePrefix);
        configAsMap.put("_classLabel", this.classLabelName);
        configAsMap.put("_subClassOfRel", this.subClassOfRelName);
        configAsMap.put("_dataTypePropertyLabel", this.dataTypePropertyLabelName);
        configAsMap.put("_objectPropertyLabel", this.objectPropertyLabelName);
        configAsMap.put("_subPropertyOfRel", this.subPropertyOfRelName);
        configAsMap.put("_domainRel", this.domainRelName);
        configAsMap.put("_rangeRel", this.rangeRelName);
        return configAsMap;
    }

    public int getHandleVocabUris() {
        return this.handleVocabUris;
    }

    public int getHandleMultival() {
        return this.handleMultival;
    }

    public int getHandleRDFTypes() {
        return this.handleRDFTypes;
    }

    public boolean isKeepLangTag() {
        return this.keepLangTag;
    }

    public boolean isApplyNeo4jNaming() {
        return this.applyNeo4jNaming;
    }

    public boolean isKeepCustomDataTypes() {
        return this.keepCustomDataTypes;
    }

    public Set<String> getMultivalPropList() {
        return this.multivalPropList;
    }

    public Set<String> getCustomDataTypePropList() {
        return this.customDataTypePropList;
    }

    public String getBaseSchemaNamespace() {
        if (this.baseSchemaNamespace != null) {
            return this.baseSchemaNamespace;
        }
        return "neo4j://graph.schema#";
    }

    public String getBaseSchemaNamespacePrefix() {
        if (this.baseSchemaNamespacePrefix != null) {
            return this.baseSchemaNamespacePrefix;
        }
        return "n4sch";
    }

    public String getClassLabelName() {
        return this.classLabelName;
    }

    public String getObjectPropertyLabelName() {
        return this.objectPropertyLabelName;
    }

    public String getDataTypePropertyLabelName() {
        return this.dataTypePropertyLabelName;
    }

    public String getSubClassOfRelName() {
        return this.subClassOfRelName;
    }

    public String getSubPropertyOfRelName() {
        return this.subPropertyOfRelName;
    }

    public String getDomainRelName() {
        return this.domainRelName;
    }

    public String getRangeRelName() {
        return this.rangeRelName;
    }

    public String getRelatedConceptRelName() {
        return "RELATED";
    }

    public void add(Map<String, Object> props) throws InvalidParamException {
        if (props.containsKey("handleVocabUris")) {
            this.handleVocabUris = this.parseHandleVocabUrisValue((String)props.get("handleVocabUris"));
        }
        if (props.containsKey("handleMultival")) {
            this.handleMultival = this.parseHandleMultivalValue((String)props.get("handleMultival"));
        }
        if (props.containsKey("handleRDFTypes")) {
            this.handleRDFTypes = this.parseHandleRDFTypesValue((String)props.get("handleRDFTypes"));
        }
        if (props.containsKey("keepLangTag") && ((Boolean)props.get("keepLangTag")).booleanValue()) {
            this.keepLangTag = (Boolean)props.get("keepLangTag");
        }
        if (props.containsKey("applyNeo4jNaming") && ((Boolean)props.get("applyNeo4jNaming")).booleanValue()) {
            this.applyNeo4jNaming = (Boolean)props.get("applyNeo4jNaming");
        }
        if (props.containsKey("keepCustomDataTypes") && ((Boolean)props.get("keepCustomDataTypes")).booleanValue()) {
            this.keepCustomDataTypes = (Boolean)props.get("keepCustomDataTypes");
        }
        if (props.containsKey("multivalPropList")) {
            Set<Object> set = this.multivalPropList = props.get("multivalPropList") != null ? ((List)props.get("multivalPropList")).stream().collect(Collectors.toSet()) : null;
        }
        if (props.containsKey("customDataTypePropList")) {
            Set<Object> set = this.customDataTypePropList = props.get("customDataTypePropList") != null ? ((List)props.get("customDataTypePropList")).stream().collect(Collectors.toSet()) : null;
        }
        if (props.containsKey("baseSchemaNamespace") && URIUtil.isCorrectURISplit((String)props.get("baseSchemaNamespace"), "someLocalName")) {
            this.baseSchemaNamespace = (String)props.get("baseSchemaNamespace");
        }
        if (props.containsKey("classLabel")) {
            this.classLabelName = (String)props.get("classLabel");
        }
        if (props.containsKey("subClassOfRel")) {
            this.subClassOfRelName = (String)props.get("subClassOfRel");
        }
        if (props.containsKey("dataTypePropertyLabel")) {
            this.dataTypePropertyLabelName = (String)props.get("dataTypePropertyLabel");
        }
        if (props.containsKey("objectPropertyLabel")) {
            this.objectPropertyLabelName = (String)props.get("objectPropertyLabel");
        }
        if (props.containsKey("subPropertyOfRel")) {
            this.subPropertyOfRelName = (String)props.get("subPropertyOfRel");
        }
        if (props.containsKey("domainRel")) {
            this.domainRelName = (String)props.get("domainRel");
        }
        if (props.containsKey("rangeRel")) {
            this.rangeRelName = (String)props.get("rangeRel");
        }
    }

    public class GraphConfigNotFound
    extends Throwable {
    }

    public class InvalidParamException
    extends Throwable {
        public InvalidParamException(String msg) {
            super(msg);
        }
    }
}

