/*
 * Decompiled with CFR 0.152.
 */
package n10s.inference;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import n10s.graphconfig.GraphConfig;
import n10s.inference.MicroReasonerException;
import n10s.result.NodeResult;
import n10s.result.RelAndNodeResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class MicroReasoners {
    private static final String sloInferenceFormatReturnClassNames = "CALL db.labels() YIELD label  WITH collect(label) as labels MATCH path = (c:`%1$s`)<-[:`%3$s`*]-(s:`%1$s`)  WHERE s.`%2$s` in labels AND NOT (c)-[:`%3$s`]->() AND any(x in nodes (path)  WHERE x.`%2$s` = $virtLabel ) RETURN COLLECT(DISTINCT s.`%2$s`) + $virtLabel  as l";
    private static final String subcatPathQuery = "MATCH (x:`%1$s` { `%2$s`: $oneOfCats } ) MATCH (y:`%1$s` { `%2$s`: $virtLabel } )  WHERE  (x)-[:`%3$s`*]->(y) RETURN count(x) > 0 as isTrue ";
    private static final String scoInferenceCypherTopDownQuery = "MATCH (cat)<-[:`%1$s`*0..]-(subcat) WHERE id(cat) = $catId RETURN collect(DISTINCT id(subcat)) AS catIds";
    private static final String scoInferenceCypherBottomUpQuery = "MATCH (cat)<-[:`%1$s`*0..]-(subcat) WHERE id(subcat) = $catId RETURN collect(DISTINCT id(cat)) AS catIds";
    private static final String sroInferenceFormatReturnRelNamesQuery = "RETURN $virtRel as r UNION MATCH (:`%1$s` { `%2$s`: $virtRel})<-[:`%3$s`*]-(sr:`%1$s`) RETURN DISTINCT sr.`%2$s` as r";
    private static final String DEFAULT_CAT_NAME_PROP_NAME = "name";
    private static final String DEFAULT_REL_NAME_PROP_NAME = "name";
    private static final boolean DEFAULT_SEARCH_TOP_DOWN = false;
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;

    @Procedure(mode=Mode.READ)
    @Description(value="n10s.inference.nodesLabelled('label') - returns all nodes with label 'label' or its sublabels.")
    public Stream<NodeResult> nodesLabelled(@Name(value="label") String virtLabel, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws MicroReasonerException {
        GraphConfig gc = this.getGraphConfig();
        if (gc == null && this.missingParams(props, "catLabel", "catNameProp", "subCatRel")) {
            throw new MicroReasonerException("No GraphConfig or in-procedure params. Method cannot be run.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("virtLabel", virtLabel);
        Result results = this.tx.execute(String.format(sloInferenceFormatReturnClassNames, props.containsKey("catLabel") ? (String)props.get("catLabel") : gc.getClassLabelName(), props.containsKey("catNameProp") ? (String)props.get("catNameProp") : "name", props.containsKey("subCatRel") ? (String)props.get("subCatRel") : gc.getSubClassOfRelName()), params);
        List labelList = (List)results.next().get("l");
        StringBuilder sb = new StringBuilder();
        sb.append("cypher runtime=slotted ");
        sb.append("unwind [] as result return result ");
        labelList.forEach(x -> sb.append(" UNION MATCH (x:`").append((String)x).append("`) RETURN x as result "));
        return this.tx.execute(sb.toString()).stream().map(n -> (Node)n.get("result")).map(NodeResult::new);
    }

    private GraphConfig getGraphConfig() {
        try {
            return new GraphConfig(this.tx);
        }
        catch (GraphConfig.GraphConfigNotFound graphConfigNotFound) {
            return null;
        }
    }

    @Procedure(mode=Mode.READ)
    @Description(value="n10s.inference.nodesInCategory('category') - returns all nodes connected to Node 'catNode' or its subcategories.")
    public Stream<NodeResult> nodesInCategory(@Name(value="category") Node catNode, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws MicroReasonerException {
        GraphConfig gc = this.getGraphConfig();
        if (gc == null && this.missingParams(props, "subCatRel")) {
            throw new MicroReasonerException("No GraphConfig or in-procedure params. Method cannot be run.");
        }
        String inCatRelName = props.containsKey("inCatRel") ? (String)props.get("inCatRel") : this.getDefaultIncatRel(gc);
        String subCatRelName = props.containsKey("subCatRel") ? (String)props.get("subCatRel") : gc.getSubClassOfRelName();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("catId", catNode.getId());
        String cypher = "MATCH (rootCategory)<-[:`" + subCatRelName + "`*0..]-()<-[:`" + inCatRelName + "`]-(individual) WHERE id(rootCategory) = $catId RETURN individual ";
        return this.tx.execute(cypher, params).stream().map(n -> (Node)n.get("individual")).map(NodeResult::new);
    }

    private String getDefaultIncatRel(GraphConfig gc) {
        if (gc.getHandleRDFTypes() == 1 || gc.getHandleRDFTypes() == 2) {
            if (gc.getHandleVocabUris() == 2 || gc.getHandleVocabUris() == 3) {
                return "type";
            }
            if (gc.getHandleVocabUris() == 0 || gc.getHandleVocabUris() == 1) {
                return "rdf__type";
            }
            if (gc.getHandleVocabUris() == 4) {
                return "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
            }
        }
        return "IN_CATEGORY";
    }

    private List<Long> getSubcatIds(Node catNode, String subCatRelName, GraphConfig gc) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("catId", catNode.getId());
        return (List)this.tx.execute(String.format(scoInferenceCypherTopDownQuery, subCatRelName == null ? gc.getSubClassOfRelName() : subCatRelName), params).next().get("catIds");
    }

    private List<Long> getSuperCatIds(long catNodeId, String subCatRelName, GraphConfig gc) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("catId", catNodeId);
        return (List)this.tx.execute(String.format(scoInferenceCypherBottomUpQuery, subCatRelName == null ? gc.getSubClassOfRelName() : subCatRelName), params).next().get("catIds");
    }

    @Procedure(mode=Mode.READ)
    @Description(value="n10s.inference.getRels(node,'rel', { relDir: '>'} ) - returns all relationships of type 'rel' or its subtypes along with the target nodes.")
    public Stream<RelAndNodeResult> getRels(@Name(value="node") Node node, @Name(value="rel") String virtRel, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws MicroReasonerException {
        String directionString;
        GraphConfig gc = this.getGraphConfig();
        if (gc == null && this.missingParams(props, "relLabel", "subRelRel")) {
            throw new MicroReasonerException("No GraphConfig or in-procedure params. Method cannot be run.");
        }
        String string = directionString = props.containsKey("relDir") ? (String)props.get("relDir") : "";
        Direction direction = directionString.equals(">") ? Direction.OUTGOING : (directionString.equals("<") ? Direction.INCOMING : Direction.BOTH);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("virtRel", virtRel);
        Result results = this.tx.execute(String.format(sroInferenceFormatReturnRelNamesQuery, props.containsKey("relLabel") ? (String)props.get("relLabel") : gc.getObjectPropertyLabelName(), props.containsKey("relNameProp") ? (String)props.get("relNameProp") : "name", props.containsKey("subRelRel") ? (String)props.get("subRelRel") : gc.getSubPropertyOfRelName()), params);
        HashSet<RelationshipType> rts = new HashSet<RelationshipType>();
        while (results.hasNext()) {
            rts.add(RelationshipType.withName((String)((String)results.next().get("r"))));
        }
        return StreamSupport.stream(node.getRelationships(direction, rts.toArray(new RelationshipType[0])).spliterator(), true).map(n -> new RelAndNodeResult((Relationship)n, n.getOtherNode(node)));
    }

    @UserFunction
    @Description(value="n10s.inference.hasLabel(node,'label',{}) - checks whether node is explicitly or implicitly labeled as 'label'.")
    public boolean hasLabel(@Name(value="node") Node individual, @Name(value="label") String label, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws MicroReasonerException {
        GraphConfig gc = this.getGraphConfig();
        if (gc == null && this.missingParams(props, "catLabel", "subCatRel")) {
            throw new MicroReasonerException("No GraphConfig or in-function params. Method cannot be run.");
        }
        String queryString = String.format(subcatPathQuery, props.containsKey("catLabel") ? (String)props.get("catLabel") : gc.getClassLabelName(), props.containsKey("catNameProp") ? (String)props.get("catNameProp") : "name", props.containsKey("subCatRel") ? (String)props.get("subCatRel") : gc.getSubClassOfRelName());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("virtLabel", label);
        Iterable labels = individual.getLabels();
        boolean is = false;
        for (Label l : labels) {
            params.put("oneOfCats", l.name());
            is |= l.name().equals(label) ? true : this.tx.execute(queryString, params).next().get("isTrue").equals(true);
        }
        return is;
    }

    private boolean missingParams(Map<String, Object> props, String ... paramNames) {
        boolean missing = false;
        for (String param : paramNames) {
            missing |= !props.containsKey(param);
        }
        return missing;
    }

    @UserFunction
    @Description(value="n10s.inference.inCategory(node, category, {}) - checks whether node is explicitly or implicitly in a category.")
    public boolean inCategory(@Name(value="node") Node individual, @Name(value="category") Node category, @Name(value="params", defaultValue="{}") Map<String, Object> props) {
        boolean is;
        List<Long> catIds;
        GraphConfig gc = this.getGraphConfig();
        String inCatRelName = props.containsKey("inCatRel") ? (String)props.get("inCatRel") : this.getDefaultIncatRel(gc);
        String subCatRelName = props.containsKey("subCatRel") ? (String)props.get("subCatRel") : gc.getSubClassOfRelName();
        boolean searchTopDown = props.containsKey("searchTopDown") ? (Boolean)props.get("searchTopDown") : false;
        ResourceIterator relIterator = individual.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)inCatRelName)}).iterator();
        if (searchTopDown) {
            boolean is2;
            List<Long> catIds2 = this.getSubcatIds(category, subCatRelName, gc);
            for (is2 = false; !is2 && relIterator.hasNext(); is2 |= catIds2.contains(((Relationship)relIterator.next()).getEndNode().getId())) {
            }
            return is2;
        }
        for (is = false; !is && relIterator.hasNext(); is |= catIds.contains(category.getId())) {
            catIds = this.getSuperCatIds(((Relationship)relIterator.next()).getEndNode().getId(), subCatRelName, gc);
        }
        return is;
    }
}

