/*
 * Decompiled with CFR 0.152.
 */
package n10s.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.NsPrefixMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class MappingUtils {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    @Procedure(mode=Mode.WRITE)
    public Stream<MappingDesc> add(@Name(value="elementUri") String rdfVocElement, @Name(value="graphElementName") String graphElem) throws MappingDefinitionException, InvalidNamespacePrefixDefinitionInDB {
        NsPrefixMap prefixDefs = new NsPrefixMap(this.tx, false);
        IRI rdfVocElementIri = vf.createIRI(rdfVocElement);
        if (!prefixDefs.hasNs(rdfVocElementIri.getNamespace())) {
            throw new MappingDefinitionException("No namespace prefix defined for vocabulary " + rdfVocElementIri.getNamespace() + ".  Define it first with call n10s.nsprefixes.add('yourprefix','" + rdfVocElementIri.getNamespace() + "')");
        }
        String prefix = prefixDefs.getPrefixForNs(rdfVocElementIri.getNamespace());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("namespace", rdfVocElementIri.getNamespace());
        params.put("prefix", prefix);
        params.put("local", rdfVocElementIri.getLocalName());
        params.put("graphElement", graphElem);
        String clearOldOccurences = "MATCH (oldmd:`_MapDef`)-[:`_IN`]->(oldns:`_MapNs`)  \nWHERE oldmd._key = $graphElement OR (oldns._ns = $namespace AND oldmd._local = $local)\nDETACH DELETE oldmd";
        String cleanOrphansIfAny = "MATCH (oldns:`_MapNs`)\n WHERE not (oldns)<-[:_IN]-() \n DELETE oldns";
        String createNewMapping = "MERGE (newmns:`_MapNs` { _ns: $namespace, _prefix: $prefix }) \nMERGE  (newmd:`_MapDef` { _key: $graphElement, _local: $local})\nMERGE (newmns)<-[:_IN]-(newmd)";
        this.tx.execute(clearOldOccurences, params);
        this.tx.execute(cleanOrphansIfAny);
        this.tx.execute(createNewMapping, params);
        return Stream.of(new MappingDesc(graphElem, rdfVocElementIri.getLocalName(), rdfVocElementIri.getNamespace(), prefix));
    }

    @Procedure(mode=Mode.WRITE)
    public Stream<StringOutput> dropAll(@Name(value="namespace") String schemaUri) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("_ns", schemaUri);
        ResourceIterator schemas = this.tx.findNodes(Label.label((String)"_MapNs"), props);
        if (!schemas.hasNext()) {
            return Stream.of(new StringOutput("schema not found"));
        }
        Node schemaToDelete = (Node)schemas.next();
        ResourceIterable inRels = schemaToDelete.getRelationships(Direction.INCOMING, new RelationshipType[]{RelationshipType.withName((String)"_IN")});
        inRels.forEach(x -> {
            x.getOtherNode(schemaToDelete).delete();
            x.delete();
        });
        schemaToDelete.delete();
        return Stream.of(new StringOutput("successfully deleted schema (and mappings)"));
    }

    @Procedure(mode=Mode.WRITE)
    public Stream<StringOutput> drop(@Name(value="graphElementName") String gElem) throws MappingDefinitionException {
        String cypher = "MATCH (mapns)<-[:_IN]-(elem:_MapDef { _key : $local }) DETACH DELETE elem RETURN count(elem) AS deletecount, size([(mapns)<-[r:_IN]-() | r ]) AS remaining, mapns ";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("local", gElem);
        Result queryResult = this.tx.execute(cypher, params);
        if (!queryResult.hasNext()) {
            return Stream.of(new StringOutput("mapping not found"));
        }
        Map singleRecord = queryResult.next();
        if (!((Long)singleRecord.get("deletecount")).equals(1L)) {
            throw new MappingDefinitionException("multiple mappings found for elem " + gElem);
        }
        Long mappingsRemaining = (Long)singleRecord.get("remaining");
        if (mappingsRemaining == 0L) {
            Node nsNode = (Node)singleRecord.get("mapns");
            nsNode.delete();
        }
        return Stream.of(new StringOutput("mapping successfully deleted"));
    }

    @Procedure(mode=Mode.READ)
    public Stream<MappingDesc> list(@Name(value="schemaElem", defaultValue="") String schemaElem) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("elemName", schemaElem);
        String cypher = "MATCH (mns:_MapNs)<-[:_IN]-(elem:_MapDef) WHERE toLower(elem._key) CONTAINS toLower($elemName)  OR toLower(elem._local) CONTAINS toLower($elemName)  RETURN elem._key AS elemName, elem._local AS schemaElement, mns._prefix AS schemaPrefix, mns._ns AS schemaNs  ";
        return this.tx.execute(cypher, params).stream().map(x$0 -> new MappingDesc((Map<String, Object>)x$0));
    }

    public static Map<String, String> getExportMappingsFromDB(GraphDatabaseService gds) {
        final HashMap<String, String> mappings = new HashMap<String, String>();
        gds.executeTransactionally("MATCH (mp:_MapDef)-[:_IN]->(mns:_MapNs) RETURN mp._key AS key, mp._local AS local, mns._ns AS ns ", Collections.emptyMap(), (ResultTransformer)new ResultTransformer<Object>(){

            public Object apply(Result result) {
                while (result.hasNext()) {
                    Map row = result.next();
                    mappings.put((String)row.get("key"), (String)row.get("ns") + (String)row.get("local"));
                }
                return null;
            }
        });
        return mappings;
    }

    static Map<String, String> getPrefixes(GraphDatabaseService gds, String nsPrefixQuery) {
        final HashMap<String, String> nsprefixes = new HashMap<String, String>();
        gds.executeTransactionally(nsPrefixQuery, Collections.emptyMap(), (ResultTransformer)new ResultTransformer<Object>(){

            public Object apply(Result result) {
                while (result.hasNext()) {
                    Map row = result.next();
                    nsprefixes.put((String)row.get("prefix"), (String)row.get("ns"));
                }
                return null;
            }
        });
        return nsprefixes;
    }

    public static Map<String, String> getPrefixesInUse(GraphDatabaseService gds) {
        return MappingUtils.getPrefixes(gds, "MATCH (nspd:`_NsPrefDef`) UNWIND keys(nspd) as key\nRETURN key as prefix, nspd[key] as ns ");
    }

    public static Map<String, String> getPrefixesFromMappingDefinitions(GraphDatabaseService gds) {
        return MappingUtils.getPrefixes(gds, "MATCH (mns:_MapNs) WHERE (:_MapDef)-[:_IN]->(mns) RETURN mns._prefix AS prefix, mns._ns AS ns ");
    }

    public static Map<String, String> getImportMappingsFromDB(GraphDatabaseService gds) {
        final HashMap<String, String> mappings = new HashMap<String, String>();
        gds.executeTransactionally("MATCH (mp:_MapDef)-[:_IN]->(mns:_MapNs) RETURN mp._key AS key, mp._local AS local, mns._ns AS ns ", Collections.emptyMap(), (ResultTransformer)new ResultTransformer<Object>(){

            public Object apply(Result result) {
                while (result.hasNext()) {
                    Map row = result.next();
                    mappings.put((String)row.get("ns") + (String)row.get("local"), (String)row.get("key"));
                }
                return null;
            }
        });
        return mappings;
    }

    private class MappingDefinitionException
    extends Throwable {
        public MappingDefinitionException(String s) {
            super(s);
        }
    }

    public class MappingDesc {
        public String schemaNs;
        public String schemaPrefix;
        public String schemaElement;
        public String elemName;

        public MappingDesc(Map<String, Object> record) {
            this.elemName = record.get("elemName").toString();
            this.schemaElement = record.get("schemaElement").toString();
            this.schemaNs = record.get("schemaNs").toString();
            this.schemaPrefix = record.get("schemaPrefix").toString();
        }

        public MappingDesc(String elemName, String schemaElement, String schemaNs, String schemaPrefix) {
            this.elemName = elemName;
            this.schemaElement = schemaElement;
            this.schemaNs = schemaNs;
            this.schemaPrefix = schemaPrefix;
        }
    }

    public class StringOutput {
        public String output;

        public StringOutput(String output) {
            this.output = output;
        }
    }
}

