/*
 * Decompiled with CFR 0.152.
 */
package n10s.onto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import n10s.CommonProcedures;
import n10s.ConfiguredStatementHandler;
import n10s.RDFImportException;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.RDFParserConfig;
import n10s.onto.OntologyImporter;
import n10s.onto.OntologyPreviewer;
import n10s.rdf.RDFProcedures;
import n10s.result.GraphResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;

public class OntoProcedures
extends CommonProcedures {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public Log log;

    protected RDFProcedures.ImportResults doOntoImport(String format, String url, String rdfFragment, Map<String, Object> props, boolean reuseCurrentTx) throws GraphConfig.GraphConfigNotFound, GraphConfig.InvalidParamException {
        OntologyImporter ontoImporter = null;
        RDFFormat rdfFormat = null;
        RDFProcedures.ImportResults importResults = new RDFProcedures.ImportResults();
        try {
            this.checkConstraintExist();
            if (!props.containsKey("singleTx")) {
                props.put("singleTx", reuseCurrentTx);
            }
            RDFParserConfig conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            ontoImporter = new OntologyImporter(this.db, this.tx, conf, this.log);
        }
        catch (CommonProcedures.RDFImportPreRequisitesNotMet e) {
            importResults.setTerminationKO(e.getMessage());
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            importResults.setTerminationKO(e.getMessage());
        }
        if (ontoImporter != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, ontoImporter);
                importResults.setTriplesLoaded(ontoImporter.totalTriplesMapped);
                importResults.setTriplesParsed(ontoImporter.totalTriplesParsed);
                importResults.setConfigSummary(props);
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                importResults.setTerminationKO(e.getMessage());
                importResults.setTriplesLoaded(ontoImporter.totalTriplesMapped);
                importResults.setTriplesParsed(ontoImporter.totalTriplesParsed);
                importResults.setConfigSummary(props);
                e.printStackTrace();
            }
        }
        return importResults;
    }

    protected GraphResult doPreviewOnto(@Name(value="url") String url, @Name(value="rdf") String rdfFragment, @Name(value="format") String format, @Name(value="params", defaultValue="{}") Map<String, Object> props) throws RDFImportException {
        RDFParserConfig conf = null;
        RDFFormat rdfFormat = null;
        OntologyPreviewer ontoViewer = null;
        HashMap<String, Node> virtualNodes = new HashMap<String, Node>();
        ArrayList<Relationship> virtualRels = new ArrayList<Relationship>();
        try {
            conf = new RDFParserConfig(props, new GraphConfig(this.tx));
            rdfFormat = this.getFormat(format);
            ontoViewer = new OntologyPreviewer(this.db, this.tx, conf, virtualNodes, virtualRels, this.log);
        }
        catch (CommonProcedures.RDFImportBadParams e) {
            throw new RDFImportException(e);
        }
        catch (GraphConfig.GraphConfigNotFound e) {
            throw new RDFImportException("A Graph Config is required for the Ontology preview procedure to run");
        }
        if (ontoViewer != null) {
            try {
                this.parseRDFPayloadOrFromUrl(rdfFormat, url, rdfFragment, props, ontoViewer);
            }
            catch (ConfiguredStatementHandler.TripleLimitReached e) {
            }
            catch (IOException | RDFHandlerException | RDFParseException | QueryExecutionException e) {
                throw new RDFImportException(e.getMessage());
            }
        }
        return new GraphResult(new ArrayList<Node>(virtualNodes.values()), virtualRels);
    }
}

