/*
 * Decompiled with CFR 0.152.
 */
package n10s.onto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import n10s.ConfiguredStatementHandler;
import n10s.Util;
import n10s.graphconfig.RDFParserConfig;
import n10s.onto.OWLRestriction;
import n10s.onto.OntologyImporter;
import n10s.result.VirtualNode;
import n10s.result.VirtualRelationship;
import n10s.utils.NamespacePrefixConflictException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class OntologyPreviewer
extends OntologyImporter {
    private Map<String, Node> vNodes;
    private List<Relationship> vRels;

    public OntologyPreviewer(GraphDatabaseService db, Transaction tx, RDFParserConfig conf, Map<String, Node> virtualNodes, List<Relationship> virtualRels, Log log) {
        super(db, tx, conf, log);
        this.vNodes = virtualNodes;
        this.vRels = virtualRels;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.conclude();
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.mappedTripleCounter >= this.parserConfig.getStreamTripleLimit()) {
            this.conclude();
            throw new ConfiguredStatementHandler.TripleLimitReached(this.parserConfig.getStreamTripleLimit() + " triples added to preview");
        }
        super.handleStatement(st);
    }

    private void conclude() {
        for (String uri : this.resourceLabels.keySet()) {
            this.vNodes.put(uri, new VirtualNode(Util.labels(new ArrayList((Collection)this.resourceLabels.get(uri))), this.getPropsPlusUri(uri)));
        }
        this.openSubClassRestrictions.keySet().stream().forEach(c -> ((List)this.openSubClassRestrictions.get(c)).forEach(rest -> this.processRestriction((IRI)c, (OWLRestriction)rest, 0)));
        this.openEquivRestrictions.keySet().stream().forEach(c -> ((List)this.openEquivRestrictions.get(c)).forEach(rest -> this.processRestriction((IRI)c, (OWLRestriction)rest, 1)));
        this.statements.forEach(st -> {
            try {
                this.vRels.add(new VirtualRelationship(this.vNodes.get(st.getSubject().stringValue().replace("'", "'")), this.vNodes.get(st.getObject().stringValue().replace("'", "'")), RelationshipType.withName((String)this.handleIRI(this.translateRelName(st.getPredicate()), 0))));
            }
            catch (NamespacePrefixConflictException e) {
                e.printStackTrace();
            }
        });
    }

    private void processRestriction(IRI c, OWLRestriction rest, int type) {
        try {
            if (rest.isComplete()) {
                HashMap<String, Object> relProps = new HashMap<String, Object>();
                relProps.put("onPropertyURI", rest.getRelName().stringValue());
                relProps.put("onPropertyName", rest.getRelName().getLocalName());
                relProps.put("restrictionType", this.getTypeAsString(rest));
                if (rest.isCardinalityConstraint()) {
                    relProps.put("cardinalityVal", rest.getCardinalityVal());
                }
                this.vRels.add(new VirtualRelationship(this.vNodes.get(c.stringValue().replace("'", "'")), this.vNodes.get(rest.getTargetClass().stringValue().replace("'", "'")), RelationshipType.withName((String)this.handleIRI(this.vf.createIRI("neo4j://graph.schema#" + this.getRestrictionRelName(type)), 0)), relProps));
            }
        }
        catch (NamespacePrefixConflictException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Object> getPropsPlusUri(String uri) {
        Map props = (Map)this.resourceProps.get(uri);
        props.put("uri", uri);
        return props;
    }

    @Override
    protected void periodicOperation() {
    }
}

