/*
 * Decompiled with CFR 0.152.
 */
package n10s.rdf.stream;

import java.util.ArrayList;
import n10s.ConfiguredStatementHandler;
import n10s.graphconfig.RDFParserConfig;
import n10s.rdf.stream.StatementStreamer;
import n10s.result.StreamedStatement;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class StarFormatStatementStreamer
extends StatementStreamer {
    public StarFormatStatementStreamer(RDFParserConfig pc) {
        super(pc);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if ((long)this.statements.size() < this.parserConfig.getStreamTripleLimit()) {
            if (this.parserConfig.getPredicateExclusionList() == null || !this.parserConfig.getPredicateExclusionList().contains(st.getPredicate().stringValue())) {
                StreamedStatement statement;
                Value object = st.getObject();
                if (st.getSubject().isTriple()) {
                    ArrayList<String> subjectSPO = new ArrayList<String>();
                    Triple subjectAsTriple = (Triple)st.getSubject();
                    subjectSPO.add(subjectAsTriple.getSubject().stringValue());
                    subjectSPO.add(subjectAsTriple.getPredicate().stringValue());
                    subjectSPO.add(subjectAsTriple.getObject().stringValue());
                    statement = new StreamedStatement(st.getSubject().stringValue(), st.getPredicate().stringValue(), object.stringValue(), object instanceof Literal, object instanceof Literal ? ((Literal)object).getDatatype().stringValue() : null, object instanceof Literal ? (String)((Literal)object).getLanguage().orElse(null) : null, subjectSPO);
                } else {
                    statement = new StreamedStatement(st.getSubject().stringValue(), st.getPredicate().stringValue(), object.stringValue(), object instanceof Literal, object instanceof Literal ? ((Literal)object).getDatatype().stringValue() : null, object instanceof Literal ? (String)((Literal)object).getLanguage().orElse(null) : null);
                }
                this.statements.add(statement);
            }
        } else {
            throw new ConfiguredStatementHandler.TripleLimitReached(this.parserConfig.getStreamTripleLimit() + " triples streamed");
        }
    }
}

