/*
 * Decompiled with CFR 0.152.
 */
package n10s.utils;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;

public class DateUtils {
    public static LocalDateTime parseDateTime(String stringDateTime) {
        boolean dateParsed = false;
        LocalDateTime localDateTime = null;
        StringBuilder parserErrors = new StringBuilder("Error parsing ").append(stringDateTime).append(":\n");
        try {
            localDateTime = LocalDateTime.parse(stringDateTime);
            dateParsed = true;
        }
        catch (DateTimeParseException e) {
            dateParsed = false;
            parserErrors.append(e.getMessage()).append("\n");
        }
        if (!dateParsed) {
            try {
                Calendar calendar = DatatypeConverter.parseDateTime(stringDateTime);
                localDateTime = LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
                dateParsed = true;
            }
            catch (IllegalArgumentException | DateTimeException e) {
                dateParsed = false;
                parserErrors.append(e.getMessage()).append("\n");
            }
        }
        if (!dateParsed) {
            throw new IllegalArgumentException(parserErrors.toString());
        }
        return localDateTime;
    }

    public static LocalDate parseDate(String stringDate) {
        boolean dateParsed = false;
        LocalDate localDate = null;
        StringBuilder parserErrors = new StringBuilder("Error parsing ").append(stringDate).append(":\n");
        try {
            localDate = LocalDate.parse(stringDate);
            dateParsed = true;
        }
        catch (DateTimeParseException e) {
            dateParsed = false;
            parserErrors.append(e.getMessage()).append("\n");
        }
        if (!dateParsed) {
            try {
                Calendar calendar = DatatypeConverter.parseDate(stringDate);
                localDate = LocalDate.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
                dateParsed = true;
            }
            catch (IllegalArgumentException | DateTimeException e) {
                dateParsed = false;
                parserErrors.append(e.getMessage()).append("\n");
            }
        }
        if (!dateParsed) {
            throw new IllegalArgumentException(parserErrors.toString());
        }
        return localDate;
    }
}

