/*
 * Decompiled with CFR 0.152.
 */
package n10s.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import n10s.graphconfig.GraphConfig;
import n10s.graphconfig.Params;
import n10s.utils.InvalidNamespacePrefixDefinitionInDB;
import n10s.utils.UriUtils;
import n10s.validation.ConstraintComponent;
import n10s.validation.SHACLValidationException;
import n10s.validation.ValidatorConfig;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class SHACLValidator {
    private static final String CYPHER_TX_INFIX = " focus in $touchedNodes AND ";
    private static final String CYPHER_MATCH_WHERE = "MATCH (focus:`%s`) WHERE ";
    private static final String CYPHER_MATCH_ALL_WHERE = "MATCH (focus) WHERE ";
    private static final String CYPHER_MATCH_REL_WHERE = "MATCH (focus:`%s`)-[r:`%s`]->(x) WHERE ";
    private static final String CYPHER_MATCH_ALL_REL_WHERE = "MATCH (focus)-[r:`%s`]->(x) WHERE ";
    private static final String CYPHER_WITH_PARAMS_MATCH_WHERE = "WITH $`%s` as params MATCH (focus:`%s`) WHERE ";
    private static final String CYPHER_WITH_PARAMS_MATCH_ALL_WHERE = "WITH $`%s` as params MATCH (focus) WHERE ";
    private static final String BNODE_PREFIX = "bnode://id/";
    private static final int GLOBAL_CONSTRAINT = 0;
    private static final int CLASS_BASED_CONSTRAINT = 1;
    private static final int QUERY_BASED_CONSTRAINT = 2;
    public static final String SHACL_COUNT_CONSTRAINT_COMPONENT = "http://www.w3.org/ns/shacl#CountConstraintComponent";
    public static final String SHACL_VALUE_RANGE_CONSTRAINT_COMPONENT = "http://www.w3.org/ns/shacl#ValueRangeConstraintComponent";
    public static final String SHACL_LENGTH_CONSTRAINT_COMPONENT = "http://www.w3.org/ns/shacl#LengthConstraintComponent";
    String PROP_CONSTRAINT_QUERY = "PREFIX ex: <http://example/>\nprefix sh: <http://www.w3.org/ns/shacl#> \nprefix exp: <http://www.nsmntx.org/voc/expectations#>\n\nSELECT distinct ?ns ?ps ?mostly ?path ?invPath ?rangeClass  ?rangeKind ?datatype ?severity (coalesce(?pmsg, ?nmsg,\"\") as ?msg)\n?targetClass ?targetIsQuery ?pattern ?maxCount ?minCount ?minInc ?minExc ?maxInc ?maxExc ?minStrLen \n?maxStrLen (GROUP_CONCAT (distinct ?disjointProp; separator=\"---\") AS ?disjointProps) \n(GROUP_CONCAT (distinct ?hasValueUri; separator=\"---\") AS ?hasValueUris) \n(GROUP_CONCAT (distinct ?hasValueLiteral; separator=\"---\") AS ?hasValueLiterals) \n(GROUP_CONCAT (distinct ?in; separator=\"---\") AS ?ins) \n(GROUP_CONCAT (distinct ?notIn; separator=\"---\") AS ?notins) \n(isLiteral(?inFirst) as ?isliteralIns)\n(isLiteral(?notInFirst) as ?isliteralNotIns)\n{ ?ns a ?shapeOrNodeShape ;\n     sh:node?/sh:property ?ps .\n  filter ( ?shapeOrNodeShape = sh:Shape || ?shapeOrNodeShape = sh:NodeShape )\n\n  optional { ?ps sh:path/sh:inversePath ?invPath }\n  optional { ?ps sh:path  ?path }\n  optional { ?ps sh:class  ?rangeClass }\n  optional { ?ps sh:nodeKind  ?rangeKind }  \n  optional { ?ps sh:datatype  ?datatype }\n  optional { ?ps sh:severity  ?severity }\n  optional { ?ps sh:message  ?pmsg }  \n  optional { ?ns sh:message  ?nmsg }  \n  { \n    { ?ns sh:targetClass  ?targetClass .\n      bind( false as ?targetIsQuery )}\n    union\n    { ?targetClass sh:property ?ps;\n          a rdfs:Class . \n            bind( false as ?targetIsQuery )}\n    union \n    { ?ns sh:targetQuery ?targetClass .\n              bind( true as ?targetIsQuery )}\n  }\n  optional { ?ps sh:pattern  ?pattern }\n  optional { ?ps sh:maxCount  ?maxCount }\n  \n    optional { ?ps sh:minCount  ?minCount }\n    optional { ?ps sh:minInclusive  ?minInc }\n  \n    optional { ?ps sh:maxInclusive  ?maxInc }\n    optional { ?ps sh:minExclusive  ?minExc }\n    optional { ?ps sh:maxExclusive  ?maxExc }  \n  optional { ?ps sh:minLength  ?minStrLen }\n  \n    optional { ?ps sh:minLength  ?minStrLen }\n    optional { ?ps sh:maxLength  ?maxStrLen }\n  \n   optional { ?ps sh:hasValue  ?hasValueUri . filter(isIRI(?hasValueUri)) } \n    optional { ?ps sh:hasValue  ?hasValueLiteral . filter(isLiteral(?hasValueLiteral)) } \n  \n    optional { ?ps sh:in/rdf:rest*/rdf:first ?in } \n    optional { ?ps sh:in/sh:not/rdf:rest*/rdf:first ?notIn }\n    optional { ?ps sh:in/rdf:first ?inFirst }\n    optional { ?ps sh:in/sh:not/rdf:first ?notInFirst }\n    optional { ?ps sh:minLength  ?minStrLen }\n    optional { ?ps sh:disjoint  ?disjointProp }\n    optional { ?ps exp:mostly  ?mostly }\n   \n} group by \n?ns ?ps ?path ?mostly ?invPath ?rangeClass  ?rangeKind ?datatype ?severity ?nmsg ?pmsg ?targetClass ?targetIsQuery ?pattern ?maxCount ?minCount ?minInc ?minExc ?maxInc ?maxExc ?minStrLen ?maxStrLen ?inFirst ?notInFirst";
    String NODE_CONSTRAINT_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sh: <http://www.w3.org/ns/shacl#>  \nSELECT ?ns (coalesce(?nmsg,\"\") as ?msg) ?targetClass ?targetIsQuery (GROUP_CONCAT (distinct ?definedProp; separator=\"---\") AS ?definedProps)\n(GROUP_CONCAT (distinct ?ignored; separator=\"---\") AS ?ignoredProps)\n{ ?ns a sh:NodeShape ;\n    sh:closed true .\n  {\n   { \n     ?ns sh:targetClass  ?targetClass .\n      bind( false as ?targetIsQuery )\n   }\n   union\n   { \n     ?targetClass a rdfs:Class . filter(?targetClass = ?ns) .\n     bind( false as ?targetIsQuery )\n   }\n   union\n   { \n     ?ns sh:targetQuery  ?targetClass .\n      bind( true as ?targetIsQuery )\n   }\n  }\n  optional { ?ns sh:message  ?nmsg }\n  optional { ?ns sh:property [ sh:path ?definedProp ].  filter(isIRI(?definedProp)) }\n   optional { ?ns sh:ignoredProperties/rdf:rest*/rdf:first ?ignored }\n   \n} group by ?ns ?nmsg ?targetClass ?targetIsQuery";
    String NODE_ADDITIONAL_CONSTRAINT_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nprefix sh: <http://www.w3.org/ns/shacl#>  \nSELECT ?ns (coalesce(?nmsg,\"\") as ?msg) ?targetClass ?targetIsQuery (GROUP_CONCAT (distinct ?class; separator=\"---\") AS ?class)\n(GROUP_CONCAT (distinct ?disjointclass; separator=\"---\") AS ?disjointclass)\n{ ?ns a sh:NodeShape .\n  \n  { \n    { \n     ?ns sh:targetClass  ?targetClass .\n        bind( false as ?targetIsQuery )\n    }\n    union \n    { \n     ?targetClass a rdfs:Class . filter(?targetClass = ?ns) .\n      bind( false as ?targetIsQuery )\n    }\n    union\n    {\n    ?ns sh:targetQuery  ?targetClass .\n      bind( true as ?targetIsQuery )\n    }\n  }\n  optional { ?ns sh:message ?nmsg }\n  optional { ?ns sh:class [ sh:not ?disjointclass ].  filter(isIRI(?disjointclass)) }\n  optional { ?ns sh:class ?class .  filter(isIRI(?class)) }\n  filter(bound(?disjointclass) || bound(?class))\n} group by ?ns ?nmsg ?targetClass ?targetIsQuery";
    private Transaction tx;
    private GraphDatabaseService db;
    private Log log;
    private GraphConfig gc;

    public SHACLValidator(GraphDatabaseService db, Transaction transaction, Log l) {
        this.tx = transaction;
        this.log = l;
        this.db = db;
        try {
            this.gc = new GraphConfig(this.tx);
        }
        catch (GraphConfig.GraphConfigNotFound graphConfigNotFound) {
            this.gc = null;
        }
    }

    protected ValidatorConfig compileValidations(Iterator<Map<String, Object>> constraints) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        ValidatorConfig vc = new ValidatorConfig();
        while (constraints.hasNext()) {
            Map<String, Object> propConstraint = constraints.next();
            if (!propConstraint.containsKey("appliesToCat") && !propConstraint.containsKey("appliesToQueryResult")) {
                this.log.debug("Only class-based targets (sh:targetClass), implicit class targets and query-based shapes are validated.");
                continue;
            }
            this.processConstraint(propConstraint, vc);
        }
        return vc;
    }

    protected void processConstraint(Map<String, Object> theConstraint, ValidatorConfig vc) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        String constraintSHACLType;
        Map<String, Object> params;
        Object paramSetId;
        List disjointPropList;
        List valueLiteralList;
        Map<String, Object> params2;
        String paramSetId2;
        List<String> valueUriList;
        String customMsg;
        int constraintType;
        String focusLabel = "";
        String whereClause = "";
        if (theConstraint.containsKey("appliesToCat")) {
            if (((String)theConstraint.get("appliesToCat")).equals("")) {
                constraintType = 0;
            } else {
                focusLabel = UriUtils.translateUri((String)theConstraint.get("appliesToCat"), this.tx, this.gc);
                constraintType = 1;
            }
        } else if (theConstraint.containsKey("appliesToQueryResult")) {
            whereClause = (String)theConstraint.get("appliesToQueryResult");
            this.validateWhereClause(whereClause);
            constraintType = 2;
        } else {
            throw new SHACLValidationException("invalid constraint config");
        }
        boolean isConstraintOnType = theConstraint.containsKey("item") && theConstraint.get("item").equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        String propOrRel = theConstraint.containsKey("item") ? UriUtils.translateUri((String)theConstraint.get("item"), this.tx, this.gc) : null;
        String severity = theConstraint.containsKey("severity") ? (String)theConstraint.get("severity") : SHACL.VIOLATION.stringValue();
        String string = customMsg = theConstraint.containsKey("msg") ? (String)theConstraint.get("msg") : "";
        if (theConstraint.get("dataType") != null && !isConstraintOnType) {
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "DataType", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, this.getDatatypeCastExpressionPref((String)theConstraint.get("dataType")), this.getDatatypeCastExpressionSuff((String)theConstraint.get("dataType")), focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity, (String)theConstraint.get("dataType"), customMsg), Arrays.asList(propOrRel, this.getDatatypeCastExpressionPref((String)theConstraint.get("dataType")), this.getDatatypeCastExpressionSuff((String)theConstraint.get("dataType")), (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity, (String)theConstraint.get("dataType"), customMsg)));
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "DataType2", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.DATATYPE), this.gc != null && this.gc.getGraphMode() == 2 ? theConstraint.get("dataType") : ((String)theConstraint.get("dataType")).substring(URIUtil.getLocalNameIndex((String)theConstraint.get("dataType")))));
        }
        if (theConstraint.get("hasValueUri") != null && (isConstraintOnType || this.nodesAreUriIdentified()) && !(valueUriList = (List<String>)theConstraint.get("hasValueUri")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.HAS_VALUE.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            if (isConstraintOnType) {
                if (this.typesAsLabels()) {
                    this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasValueOnTypeAsLabel", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, focusLabel, (String)theConstraint.get("propShapeUid"), severity, customMsg), Arrays.asList(paramSetId2, (String)theConstraint.get("propShapeUid"), severity, customMsg)));
                    params2.put("theHasTypeTranslatedUris", this.translateUriList(valueUriList));
                }
                if (this.typesAsRelToNodes()) {
                    this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasValueOnTypeAsNode", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
                    params2.put("theHasTypeUris", valueUriList);
                }
            } else {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasValueUri", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
                params2.put("theHasValueUri", valueUriList);
            }
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.HAS_VALUE), isConstraintOnType && this.typesAsLabels() ? this.translateUriList(valueUriList) : valueUriList));
        }
        if (theConstraint.get("hasValueLiteral") != null && !isConstraintOnType && !(valueLiteralList = (List)theConstraint.get("hasValueLiteral")).isEmpty()) {
            paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.HAS_VALUE.stringValue();
            params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
            params2.put("theHasValueLiteral", valueLiteralList);
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasValueLiteral", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.HAS_VALUE), valueLiteralList));
        }
        if (theConstraint.get("disjointProps") != null && !isConstraintOnType && !(disjointPropList = (List)theConstraint.get("disjointProps")).isEmpty()) {
            List<String> classBasedList = Arrays.asList(focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg);
            List<String> queryBasedList = Arrays.asList(propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg);
            this.addQueriesForTriggerWithDynamicProps(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasOverlappingValuesinProps", whereClause, constraintType, disjointPropList, this.buildArgArray(constraintType, classBasedList, queryBasedList));
            this.addQueriesForTriggerWithDynamicProps(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "HasOverlappingValuesinRels", whereClause, constraintType, disjointPropList, this.buildArgArray(constraintType, classBasedList, queryBasedList));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.HAS_VALUE), disjointPropList));
        }
        if (theConstraint.get("rangeKind") != null && !isConstraintOnType) {
            if (theConstraint.get("rangeKind").equals(SHACL.LITERAL.stringValue())) {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "GetRangeIRIKind", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
            } else if (theConstraint.get("rangeKind").equals(SHACL.BLANK_NODE_OR_IRI.stringValue()) || theConstraint.get("rangeKind").equals(SHACL.IRI.stringValue())) {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "GetRangeLiteralKind", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
            }
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.NODE_KIND), this.gc != null && this.gc.getGraphMode() == 2 ? theConstraint.get("rangeKind") : ((String)theConstraint.get("rangeKind")).substring(URIUtil.getLocalNameIndex((String)theConstraint.get("rangeKind")))));
        }
        if (theConstraint.get("rangeType") != null && !theConstraint.get("rangeType").equals("") && !isConstraintOnType) {
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "GetRangeType1", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc), focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc), customMsg), Arrays.asList(propOrRel, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc), (String)theConstraint.get("propShapeUid"), propOrRel, severity, UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc), customMsg)));
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "GetRangeType2", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity, propOrRel, customMsg), Arrays.asList(propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, propOrRel, severity, propOrRel, customMsg)));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.CLASS), UriUtils.translateUri((String)theConstraint.get("rangeType"), this.tx, this.gc)));
        }
        if ((theConstraint.containsKey("inLiterals") || theConstraint.containsKey("notInLiterals")) && !isConstraintOnType) {
            List list = valueLiteralList = theConstraint.containsKey("inLiterals") ? (List)theConstraint.get("inLiterals") : (List)theConstraint.get("notInLiterals");
            if (!valueLiteralList.isEmpty()) {
                paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.IN.stringValue();
                params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
                params2.put("theInLiterals", valueLiteralList);
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "InLiterals", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, theConstraint.containsKey("inLiterals") ? "not" : "", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, theConstraint.containsKey("inLiterals") ? "not" : "", (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.IN), theConstraint.containsKey("inLiterals") ? valueLiteralList : "not " + valueLiteralList.toString()));
            }
        }
        if (theConstraint.containsKey("inUris") || theConstraint.containsKey("notInUris")) {
            List<String> list = valueUriList = theConstraint.containsKey("inUris") ? (List<String>)theConstraint.get("inUris") : (List)theConstraint.get("notInUris");
            if (!valueUriList.isEmpty()) {
                paramSetId2 = theConstraint.get("propShapeUid") + "_" + SHACL.IN.stringValue();
                params2 = this.createNewSetOfParams(vc.getAllParams(), paramSetId2);
                if (isConstraintOnType) {
                    if (this.typesAsLabels()) {
                        this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "TypeAsLabelInUris", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, theConstraint.containsKey("inUris") ? "not" : "", focusLabel, (String)theConstraint.get("propShapeUid"), severity, customMsg), Arrays.asList(paramSetId2, theConstraint.containsKey("inUris") ? "not" : "", (String)theConstraint.get("propShapeUid"), severity, customMsg)));
                        params2.put("theInTypeTranslatedUris", this.translateUriList(valueUriList));
                    }
                    if (this.typesAsRelToNodes()) {
                        this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "TypeAsNodeInUris", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, theConstraint.containsKey("inUris") ? "not" : "", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, theConstraint.containsKey("inUris") ? "not" : "", (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
                        params2.put("theInTypeUris", valueUriList);
                    }
                } else {
                    this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "InUris", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId2, focusLabel, propOrRel, theConstraint.containsKey("inUris") ? "not" : "", focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg), Arrays.asList(paramSetId2, propOrRel, theConstraint.containsKey("inUris") ? "not" : "", (String)theConstraint.get("propShapeUid"), propOrRel, severity, propOrRel, customMsg)));
                    params2.put("theInUris", valueUriList);
                }
            }
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.IN), theConstraint.containsKey("inUris") ? (isConstraintOnType && this.typesAsLabels() ? this.translateUriList(valueUriList) : valueUriList) : "not " + (isConstraintOnType && this.typesAsLabels() ? this.translateUriList(valueUriList) : valueUriList)));
        }
        if (theConstraint.get("pattern") != null && !isConstraintOnType) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.PATTERN.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), (String)paramSetId);
            params.put("theRegex", (String)theConstraint.get("pattern"));
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "Regex", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, propOrRel, propOrRel, focusLabel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, customMsg), Arrays.asList(paramSetId, propOrRel, propOrRel, (String)theConstraint.get("propShapeUid"), propOrRel, severity, customMsg)));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.PATTERN), theConstraint.get("pattern")));
        }
        if (theConstraint.get("minCount") != null || theConstraint.get("maxCount") != null) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_COUNT.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), (String)paramSetId);
            params.put("minCount", theConstraint.get("minCount"));
            params.put("maxCount", theConstraint.get("maxCount"));
            String string2 = theConstraint.get("minCount") != null && theConstraint.get("maxCount") != null ? SHACL_COUNT_CONSTRAINT_COMPONENT : (constraintSHACLType = theConstraint.get("minCount") != null ? SHACL.MIN_COUNT_CONSTRAINT_COMPONENT.stringValue() : SHACL.MAX_COUNT_CONSTRAINT_COMPONENT.stringValue());
            if (!((Boolean)theConstraint.get("inverse")).booleanValue()) {
                if (isConstraintOnType) {
                    if (this.typesAsLabels()) {
                        this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "TypeAsLabelMinCardinality", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", focusLabel, (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, severity, customMsg), Arrays.asList(paramSetId, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, severity, customMsg)));
                    }
                    if (this.typesAsRelToNodes()) {
                        this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "TypeAsNodeMinCardinality", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", focusLabel, (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg), Arrays.asList(paramSetId, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg)));
                    }
                } else {
                    this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "MinCardinality1", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", focusLabel, (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, propOrRel, severity, customMsg), Arrays.asList(paramSetId, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, propOrRel, severity, customMsg)));
                }
            } else {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "MinCardinality1Inverse", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", focusLabel, (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg), Arrays.asList(paramSetId, theConstraint.get("minCount") != null ? " toInteger(params.minCount) <= " : "", propOrRel, theConstraint.get("maxCount") != null ? " <= toInteger(params.maxCount) " : "", (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg)));
            }
            if (theConstraint.get("maxCount") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MAX_COUNT), theConstraint.get("maxCount")));
            }
            if (theConstraint.get("minCount") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MIN_COUNT), theConstraint.get("minCount")));
            }
        }
        if (!(theConstraint.get("minStrLen") == null && theConstraint.get("maxStrLen") == null || isConstraintOnType)) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_LENGTH.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), (String)paramSetId);
            params.put("minStrLen", theConstraint.get("minStrLen"));
            params.put("maxStrLen", theConstraint.get("maxStrLen"));
            constraintSHACLType = theConstraint.get("minStrLen") != null && theConstraint.get("maxStrLen") != null ? SHACL_LENGTH_CONSTRAINT_COMPONENT : (theConstraint.get("minStrLen") != null ? SHACL.MIN_LENGTH_CONSTRAINT_COMPONENT.stringValue() : SHACL.MAX_LENGTH_CONSTRAINT_COMPONENT.stringValue());
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "StrLen", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, propOrRel, theConstraint.get("minStrLen") != null ? " params.minStrLen <= " : "", theConstraint.get("maxStrLen") != null ? " <= params.maxStrLen " : "", focusLabel, (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg), Arrays.asList(paramSetId, propOrRel, theConstraint.get("minStrLen") != null ? " params.minStrLen <= " : "", theConstraint.get("maxStrLen") != null ? " <= params.maxStrLen " : "", (String)theConstraint.get("propShapeUid"), constraintSHACLType, propOrRel, propOrRel, severity, customMsg)));
            if (theConstraint.get("minStrLen") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MIN_LENGTH), theConstraint.get("minStrLen")));
            }
            if (theConstraint.get("maxStrLen") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MAX_LENGTH), theConstraint.get("maxStrLen")));
            }
        }
        if (!(theConstraint.get("minInc") == null && theConstraint.get("maxInc") == null && theConstraint.get("minExc") == null && theConstraint.get("maxExc") == null || isConstraintOnType)) {
            paramSetId = theConstraint.get("propShapeUid") + "_" + SHACL.MIN_EXCLUSIVE.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), (String)paramSetId);
            params.put("min", theConstraint.get("minInc") != null ? theConstraint.get("minInc") : theConstraint.get("minExc"));
            params.put("max", theConstraint.get("maxInc") != null ? theConstraint.get("maxInc") : theConstraint.get("maxExc"));
            constraintSHACLType = SHACL_VALUE_RANGE_CONSTRAINT_COMPONENT;
            if (!(theConstraint.get("minExc") == null && theConstraint.get("minInc") == null || theConstraint.get("maxExc") == null && theConstraint.get("maxInc") == null)) {
                constraintSHACLType = SHACL_VALUE_RANGE_CONSTRAINT_COMPONENT;
            } else if (theConstraint.get("minExc") != null) {
                constraintSHACLType = SHACL.MIN_EXCLUSIVE_CONSTRAINT_COMPONENT.stringValue();
            } else if (theConstraint.get("minInc") != null) {
                constraintSHACLType = SHACL.MIN_INCLUSIVE_CONSTRAINT_COMPONENT.stringValue();
            } else if (theConstraint.get("maxExc") != null) {
                constraintSHACLType = SHACL.MAX_EXCLUSIVE_CONSTRAINT_COMPONENT.stringValue();
            } else if (theConstraint.get("maxInc") != null) {
                constraintSHACLType = SHACL.MAX_INCLUSIVE_CONSTRAINT_COMPONENT.stringValue();
            }
            String[] stringArray = new String[12];
            stringArray[0] = paramSetId;
            stringArray[1] = focusLabel;
            stringArray[2] = propOrRel;
            String string3 = theConstraint.get("minInc") != null ? " params.min <=" : (stringArray[3] = theConstraint.get("minExc") != null ? " params.min < " : "");
            stringArray[4] = theConstraint.get("maxInc") != null ? " <= params.max " : (theConstraint.get("maxExc") != null ? " < params.max " : "");
            stringArray[5] = focusLabel;
            stringArray[6] = (String)theConstraint.get("propShapeUid");
            stringArray[7] = constraintSHACLType;
            stringArray[8] = propOrRel;
            stringArray[9] = propOrRel;
            stringArray[10] = severity;
            stringArray[11] = customMsg;
            String[] stringArray2 = new String[10];
            stringArray2[0] = paramSetId;
            stringArray2[1] = propOrRel;
            String string4 = theConstraint.get("minInc") != null ? " params.min <=" : (stringArray2[2] = theConstraint.get("minExc") != null ? " params.min < " : "");
            stringArray2[3] = theConstraint.get("maxInc") != null ? " <= params.max " : (theConstraint.get("maxExc") != null ? " < params.max " : "");
            stringArray2[4] = (String)theConstraint.get("propShapeUid");
            stringArray2[5] = constraintSHACLType;
            stringArray2[6] = propOrRel;
            stringArray2[7] = propOrRel;
            stringArray2[8] = severity;
            stringArray2[9] = customMsg;
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "ValueRange", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(stringArray), Arrays.asList(stringArray2)));
            if (theConstraint.get("minInc") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MIN_INCLUSIVE), theConstraint.get("minInc")));
            }
            if (theConstraint.get("maxInc") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MAX_INCLUSIVE), theConstraint.get("maxInc")));
            }
            if (theConstraint.get("minExc") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MIN_EXCLUSIVE), theConstraint.get("minExc")));
            }
            if (theConstraint.get("maxExc") != null) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.MAX_EXCLUSIVE), theConstraint.get("maxExc")));
            }
        }
        if (theConstraint.containsKey("constraintType") && theConstraint.get("constraintType").equals("closedDefinitionPropList")) {
            paramSetId = theConstraint.get("nodeShapeUid") + "_" + SHACL.CLOSED.stringValue();
            params = this.createNewSetOfParams(vc.getAllParams(), (String)paramSetId);
            ArrayList<String> allowedPropsTranslated = new ArrayList<String>();
            if (this.typesAsRelToNodes()) {
                allowedPropsTranslated.add(UriUtils.translateUri(RDF.TYPE.stringValue(), this.tx, this.gc));
            }
            if (theConstraint.get("ignoredProps") != null) {
                allowedPropsTranslated.addAll(this.translateUriList((List)theConstraint.get("ignoredProps")));
            }
            if (theConstraint.get("definedProps") != null) {
                allowedPropsTranslated.addAll(this.translateUriList((List)theConstraint.get("definedProps")));
            }
            params.put("allAllowedProps", allowedPropsTranslated);
            this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "NodeStructure", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(paramSetId, focusLabel, focusLabel, (String)theConstraint.get("nodeShapeUid"), "http://www.w3.org/ns/shacl#Violation", customMsg), Arrays.asList(paramSetId, (String)theConstraint.get("nodeShapeUid"), "http://www.w3.org/ns/shacl#Violation", customMsg)));
            vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.IGNORED_PROPERTIES), this.translateUriList((List)theConstraint.get("ignoredProps"))));
        }
        if (theConstraint.get("disjointClass") != null) {
            Object uri2;
            for (Object uri2 : (List)theConstraint.get("disjointClass")) {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "reqAndDisjointClass", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, "", UriUtils.translateUri((String)uri2, this.tx, this.gc), focusLabel, (String)theConstraint.get("nodeShapeUid"), SHACL.NOT_CONSTRAINT_COMPONENT.stringValue(), UriUtils.translateUri((String)uri2, this.tx, this.gc), "http://www.w3.org/ns/shacl#Violation", "not allowed", UriUtils.translateUri((String)uri2, this.tx, this.gc), customMsg), Arrays.asList("", UriUtils.translateUri((String)uri2, this.tx, this.gc), (String)theConstraint.get("nodeShapeUid"), SHACL.NOT_CONSTRAINT_COMPONENT.stringValue(), UriUtils.translateUri((String)uri2, this.tx, this.gc), "http://www.w3.org/ns/shacl#Violation", "not allowed", UriUtils.translateUri((String)uri2, this.tx, this.gc), customMsg)));
            }
            List disjointClassesRaw = (List)theConstraint.get("disjointClass");
            uri2 = disjointClassesRaw.iterator();
            while (uri2.hasNext()) {
                String x = (String)uri2.next();
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.NOT), UriUtils.translateUri(x, this.tx, this.gc)));
            }
        }
        if (theConstraint.get("reqClass") != null) {
            for (Object uri2 : (List)theConstraint.get("reqClass")) {
                this.addQueriesForTrigger(vc, new ArrayList<String>(Arrays.asList(focusLabel)), "reqAndDisjointClass", whereClause, constraintType, this.buildArgArray(constraintType, Arrays.asList(focusLabel, "not", UriUtils.translateUri((String)uri2, this.tx, this.gc), focusLabel, (String)theConstraint.get("nodeShapeUid"), SHACL.CLASS_CONSTRAINT_COMPONENT.stringValue(), UriUtils.translateUri((String)uri2, this.tx, this.gc), "http://www.w3.org/ns/shacl#Violation", "missing", UriUtils.translateUri((String)uri2, this.tx, this.gc), customMsg), Arrays.asList("not", UriUtils.translateUri((String)uri2, this.tx, this.gc), (String)theConstraint.get("nodeShapeUid"), SHACL.CLASS_CONSTRAINT_COMPONENT.stringValue(), UriUtils.translateUri((String)uri2, this.tx, this.gc), "http://www.w3.org/ns/shacl#Violation", "missing", UriUtils.translateUri((String)uri2, this.tx, this.gc), customMsg)));
            }
            List reqClassesRaw = (List)theConstraint.get("reqClass");
            for (String x : reqClassesRaw) {
                vc.addConstraintToList(new ConstraintComponent(this.getTargetForList(constraintType, focusLabel, whereClause), propOrRel, this.printConstraintType(SHACL.CLASS), UriUtils.translateUri(x, this.tx, this.gc)));
            }
        }
    }

    private void validateWhereClause(String whereClause) {
        try (Transaction tempTransaction = this.db.beginTx(50L, TimeUnit.MILLISECONDS);){
            tempTransaction.execute("explain match (focus) where " + whereClause + " return focus limit 1 ");
        }
        catch (Exception e) {
            throw new SHACLValidationException("Invalid cypher expression: \"" + whereClause + "\". The cypher fragment in a sh:targetQuery element should form a valid query when embeeded in the following template:  \"match (focus) where <your cypher> return focus\"");
        }
    }

    private String[] buildArgArray(int constraintType, List<String> classBasedParamList, List<String> queryBasedParamList) {
        List<Object> argsAsList = new ArrayList();
        argsAsList = constraintType == 1 ? classBasedParamList : queryBasedParamList;
        String[] argsAsArray = new String[argsAsList.size()];
        argsAsList.toArray(argsAsArray);
        return argsAsArray;
    }

    private String getTargetForList(int constraintType, String focusLabel, String whereClause) {
        String target = "";
        switch (constraintType) {
            case 1: {
                target = focusLabel;
                break;
            }
            case 2: {
                target = whereClause;
                break;
            }
            case 0: {
                target = "[Global]";
            }
        }
        return target;
    }

    public void addQueriesForTrigger(ValidatorConfig vc, ArrayList<String> triggers, String queryId, String whereClause, int constraintType, String[] args) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        vc.addQueryAndTriggers("Q_" + (vc.getIndividualGlobalQueries().size() + 1), this.getViolationQuery(queryId, false, whereClause, constraintType, Collections.emptyList(), args), this.getViolationQuery(queryId, true, whereClause, constraintType, Collections.emptyList(), args), triggers);
    }

    public void addQueriesForTriggerWithDynamicProps(ValidatorConfig vc, ArrayList<String> triggers, String queryId, String whereClause, int constraintType, List<String> propsOrRels, String[] args) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        vc.addQueryAndTriggers("Q_" + (vc.getIndividualGlobalQueries().size() + 1), this.getViolationQuery(queryId, false, whereClause, constraintType, propsOrRels, args), this.getViolationQuery(queryId, true, whereClause, constraintType, propsOrRels, args), triggers);
    }

    private String printConstraintType(IRI i) {
        return this.gc != null && this.gc.getGraphMode() == 2 ? "sh:" + i.getLocalName() : i.getLocalName();
    }

    private List<String> translateUriList(List<String> valueUriList) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = valueUriList.iterator();
        while (iterator.hasNext()) {
            result.add(UriUtils.translateUri(iterator.next(), this.tx, this.gc));
        }
        return result;
    }

    private boolean typesAsLabels() {
        return this.gc == null || this.gc != null && (this.gc.getHandleRDFTypes() == 0 || this.gc.getHandleRDFTypes() == 2);
    }

    private boolean typesAsRelToNodes() {
        return this.gc != null && (this.gc.getHandleRDFTypes() == 1 || this.gc.getHandleRDFTypes() == 2);
    }

    private Map<String, Object> createNewSetOfParams(Map<String, Object> allParams, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        allParams.put(id, params);
        return params;
    }

    protected Iterator<Map<String, Object>> parseConstraints(InputStream is, RDFFormat format, Map<String, Object> props) throws IOException {
        SailRepository repo = new SailRepository(new MemoryStore());
        ArrayList constraints = new ArrayList();
        try (RepositoryConnection conn = repo.getConnection();){
            BindingSet next;
            HashMap<String, Object> record;
            conn.getParserConfig().set((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX, (Object)(props.containsKey("verifyUriSyntax") ? (Boolean)props.get("verifyUriSyntax") : true));
            conn.begin();
            conn.add((Reader)new InputStreamReader(is), "http://neo4j.com/base/", format, new Resource[0]);
            conn.commit();
            TupleQuery tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.PROP_CONSTRAINT_QUERY);
            TupleQueryResult queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                Literal val;
                List<String> inVals;
                Value path;
                record = new HashMap<String, Object>();
                next = (BindingSet)queryResult.next();
                Value value = path = next.hasBinding("invPath") ? next.getValue("invPath") : next.getValue("path");
                if (path instanceof BNode) {
                    this.log.debug("current version only processes single property paths");
                    continue;
                }
                record.put("item", path.stringValue());
                record.put("inverse", next.hasBinding("invPath"));
                if (!((Literal)next.getValue("targetIsQuery")).booleanValue()) {
                    record.put("appliesToCat", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                } else {
                    record.put("appliesToQueryResult", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                }
                record.put("rangeType", next.hasBinding("rangeClass") ? next.getValue("rangeClass").stringValue() : null);
                record.put("rangeKind", next.hasBinding("rangeKind") ? next.getValue("rangeKind").stringValue() : null);
                record.put("dataType", next.hasBinding("datatype") ? next.getValue("datatype").stringValue() : null);
                record.put("pattern", next.hasBinding("pattern") ? next.getValue("pattern").stringValue() : null);
                record.put("maxCount", next.hasBinding("maxCount") ? Integer.valueOf(((Literal)next.getValue("maxCount")).intValue()) : null);
                record.put("minCount", next.hasBinding("minCount") ? Integer.valueOf(((Literal)next.getValue("minCount")).intValue()) : null);
                record.put("minInc", next.hasBinding("minInc") ? Integer.valueOf(((Literal)next.getValue("minInc")).intValue()) : null);
                record.put("minExc", next.hasBinding("minExc") ? Integer.valueOf(((Literal)next.getValue("minExc")).intValue()) : null);
                record.put("maxInc", next.hasBinding("maxInc") ? Integer.valueOf(((Literal)next.getValue("maxInc")).intValue()) : null);
                record.put("maxExc", next.hasBinding("maxExc") ? Integer.valueOf(((Literal)next.getValue("maxExc")).intValue()) : null);
                if (next.hasBinding("disjointProps") && !next.getValue("disjointProps").stringValue().equals("")) {
                    List<String> disjointProps = Arrays.asList(next.getValue("disjointProps").stringValue().split("---"));
                    record.put("disjointProps", disjointProps);
                }
                if (next.hasBinding("hasValueLiterals") && !next.getValue("hasValueLiterals").stringValue().equals("")) {
                    List<String> hasValueLiterals = Arrays.asList(next.getValue("hasValueLiterals").stringValue().split("---"));
                    record.put("hasValueLiteral", hasValueLiterals);
                }
                if (next.hasBinding("hasValueUris") && !next.getValue("hasValueUris").stringValue().equals("")) {
                    List<String> hasValueUris = Arrays.asList(next.getValue("hasValueUris").stringValue().split("---"));
                    record.put("hasValueUri", hasValueUris);
                }
                if (next.hasBinding("isliteralIns")) {
                    inVals = Arrays.asList(next.getValue("ins").stringValue().split("---"));
                    val = (Literal)next.getValue("isliteralIns");
                    if (val.booleanValue()) {
                        record.put("inLiterals", inVals);
                    } else {
                        record.put("inUris", inVals);
                    }
                }
                if (next.hasBinding("isliteralNotIns")) {
                    inVals = Arrays.asList(next.getValue("notins").stringValue().split("---"));
                    val = (Literal)next.getValue("isliteralNotIns");
                    if (val.booleanValue()) {
                        record.put("notInLiterals", inVals);
                    } else {
                        record.put("notInUris", inVals);
                    }
                }
                record.put("minStrLen", next.hasBinding("minStrLen") ? Integer.valueOf(((Literal)next.getValue("minStrLen")).intValue()) : null);
                record.put("maxStrLen", next.hasBinding("maxStrLen") ? Integer.valueOf(((Literal)next.getValue("maxStrLen")).intValue()) : null);
                Value value2 = next.getValue("ps");
                if (value2 instanceof BNode) {
                    record.put("propShapeUid", BNODE_PREFIX + value2.stringValue());
                } else {
                    record.put("propShapeUid", value2.stringValue());
                }
                record.put("severity", next.hasBinding("severity") ? next.getValue("severity").stringValue() : "http://www.w3.org/ns/shacl#Violation");
                record.put("msg", next.hasBinding("msg") ? next.getValue("msg").stringValue() : "");
                constraints.add(record);
            }
            tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.NODE_CONSTRAINT_QUERY);
            queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                record = new HashMap();
                next = (BindingSet)queryResult.next();
                record.put("constraintType", "closedDefinitionPropList");
                if (!((Literal)next.getValue("targetIsQuery")).booleanValue()) {
                    record.put("appliesToCat", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                } else {
                    record.put("appliesToQueryResult", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                }
                record.put("nodeShapeUid", next.hasBinding("ns") ? next.getValue("ns").stringValue() : null);
                if (next.hasBinding("definedProps")) {
                    ArrayList<String> definedProps = new ArrayList<String>();
                    for (String s : next.getValue("definedProps").stringValue().split("---")) {
                        if (s.equals("")) continue;
                        definedProps.add(s);
                    }
                    record.put("definedProps", definedProps);
                }
                if (next.hasBinding("ignoredProps")) {
                    ArrayList<String> ignoredProps = new ArrayList<String>();
                    for (String s : next.getValue("ignoredProps").stringValue().split("---")) {
                        if (s.equals("")) continue;
                        ignoredProps.add(s);
                    }
                    record.put("ignoredProps", ignoredProps);
                }
                record.put("msg", next.hasBinding("msg") ? next.getValue("msg").stringValue() : "");
                constraints.add(record);
            }
            tupleQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, this.NODE_ADDITIONAL_CONSTRAINT_QUERY);
            queryResult = tupleQuery.evaluate();
            while (queryResult.hasNext()) {
                record = new HashMap();
                next = (BindingSet)queryResult.next();
                if (!((Literal)next.getValue("targetIsQuery")).booleanValue()) {
                    record.put("appliesToCat", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                } else {
                    record.put("appliesToQueryResult", next.hasBinding("targetClass") ? next.getValue("targetClass").stringValue() : null);
                }
                record.put("nodeShapeUid", next.hasBinding("ns") ? next.getValue("ns").stringValue() : null);
                if (next.hasBinding("class") && !next.getValue("class").stringValue().isEmpty()) {
                    record.put("reqClass", Arrays.asList(next.getValue("class").stringValue().split("---")));
                }
                if (next.hasBinding("disjointclass") && !next.getValue("disjointclass").stringValue().isEmpty()) {
                    record.put("disjointClass", Arrays.asList(next.getValue("disjointclass").stringValue().split("---")));
                }
                record.put("msg", next.hasBinding("msg") ? next.getValue("msg").stringValue() : "");
                constraints.add(record);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return constraints.iterator();
    }

    private String getDatatypeCastExpressionPref(String dataType) {
        if (dataType.equals(XSD.BOOLEAN.stringValue())) {
            return "coalesce(toBoolean(toString(";
        }
        if (dataType.equals(XSD.STRING.stringValue())) {
            return "coalesce(toString(";
        }
        if (dataType.equals(XSD.INTEGER.stringValue())) {
            return "coalesce(toInteger(";
        }
        if (dataType.equals(XSD.FLOAT.stringValue()) || dataType.equals(XSD.DECIMAL.stringValue())) {
            return "coalesce(toFloat(";
        }
        if (dataType.equals(XSD.DATE.stringValue())) {
            return "n10s.aux.dt.check('" + XSD.DATE.stringValue() + "',";
        }
        if (dataType.equals(XSD.DATETIME.stringValue())) {
            return "n10s.aux.dt.check('" + XSD.DATETIME.stringValue() + "',";
        }
        if (dataType.equals(Params.WKTLITERAL_URI.stringValue())) {
            return "n10s.aux.dt.check('" + Params.WKTLITERAL_URI.stringValue() + "',";
        }
        if (dataType.equals(XSD.ANYURI.stringValue())) {
            return "n10s.aux.dt.check('" + XSD.ANYURI.stringValue() + "',";
        }
        return "";
    }

    private String getDatatypeCastExpressionSuff(String dataType) {
        if (dataType.equals(XSD.BOOLEAN.stringValue())) {
            return ")) = x , false)";
        }
        if (dataType.equals(XSD.STRING.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XSD.INTEGER.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XSD.FLOAT.stringValue()) || dataType.equals(XSD.DECIMAL.stringValue())) {
            return ") = x , false)";
        }
        if (dataType.equals(XSD.DATE.stringValue())) {
            return ")";
        }
        if (dataType.equals(XSD.DATETIME.stringValue())) {
            return ")";
        }
        if (dataType.equals(Params.WKTLITERAL_URI.stringValue())) {
            return ")";
        }
        if (dataType.equals(XSD.ANYURI.stringValue())) {
            return ")";
        }
        throw new SHACLValidationException(dataType + " data type is not supported for sh:datatype restrictions ");
    }

    private void addCypherToValidationScripts(ValidatorConfig vc, List<String> triggers, String querystrGlobal, String querystrOnNodeset, String ... args) {
        vc.addQueryAndTriggers("Q_" + (vc.getIndividualGlobalQueries().size() + 1), String.format(querystrGlobal, args), String.format(querystrOnNodeset, args), triggers);
    }

    private String getViolationQuery(String queryId, boolean tx, String customWhere, int constraintType, List<String> propOrRelList, String ... args) throws InvalidNamespacePrefixDefinitionInDB, UriUtils.UriNamespaceHasNoAssociatedPrefix {
        String query = "";
        String nodeIdFragment = (this.nodesAreUriIdentified() ? " focus.uri " : " id(focus) ") + " as nodeId, ";
        Object nodeTypeFragment = "'[all nodes]' as nodeType, ";
        if (constraintType == 1) {
            nodeTypeFragment = (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as nodeType, ";
        } else if (constraintType == 2) {
            nodeTypeFragment = "'[query-based selection]' as nodeType, ";
        }
        String shapeIdFragment = " '%s' as shapeId, ";
        String propertyNameFragment = (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as propertyName, ";
        String severityFragment = " '%s' as severity,";
        String customMsgFragment = " '%s' as customMsg";
        switch (queryId) {
            case "DataType": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " NOT all(x in [] +  focus.`%s` where %s x %s ) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.DATATYPE_CONSTRAINT_COMPONENT + "' as propertyShape, focus.`%s` as offendingValue, " + propertyNameFragment + severityFragment + " 'property value should be of type ' + " + (this.nodesAreUriIdentified() ? " '%s' " : "n10s.rdf.getIRILocalName('%s')") + " as message , " + customMsgFragment);
                break;
            }
            case "DataType2": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_REL_WHERE : CYPHER_MATCH_ALL_REL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.DATATYPE_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.nodesAreUriIdentified() ? " x.uri " : " 'node id: ' + id(x) ") + "as offendingValue, " + propertyNameFragment + severityFragment + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a property, instead it  is a relationship' as message  , " + customMsgFragment);
                break;
            }
            case "HasValueOnTypeAsLabel": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind params.theHasTypeTranslatedUris as reqVal  with focus, reqVal where not reqVal in labels(focus) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + (String)(this.gc == null || this.gc.getGraphMode() == 1 ? " 'type' " : " '" + RDF.TYPE.stringValue() + "' ") + " as propertyName, " + severityFragment + "'The required type ' + reqVal + ' could not be found as a label of the focus node ' as message   ," + customMsgFragment);
                break;
            }
            case "HasValueOnTypeAsNode": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind params.theHasTypeUris as reqVal with focus, reqVal where not (focus)-[:`%s`]->({uri: reqVal}) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + propertyNameFragment + severityFragment + "'The required type ' + reqVal  + ' could not be found as value of relationship ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s' ") + " as message   , " + customMsgFragment);
                break;
            }
            case "HasValueUri": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind params.theHasValueUri as reqVal with focus, reqVal where not (focus)-[:`%s`]->({uri: reqVal}) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + propertyNameFragment + severityFragment + "'The required value ' + reqVal  + ' could not be found as value of relationship ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s' ") + " as message  ," + customMsgFragment);
                break;
            }
            case "HasValueLiteral": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind params.theHasValueLiteral as  reqVal with focus, reqVal where not reqVal in [] + focus.`%s` RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.HAS_VALUE_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + propertyNameFragment + severityFragment + "'The required value \"'+ reqVal + '\" was not found in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s' ") + " as message  ," + customMsgFragment);
                break;
            }
            case "GetRangeIRIKind": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " (focus)-[:`%s`]->() RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.NODE_KIND_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + propertyNameFragment + severityFragment + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a property ' as message , " + customMsgFragment);
                break;
            }
            case "GetRangeLiteralKind": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " focus.`%s` is not null RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.NODE_KIND_CONSTRAINT_COMPONENT + "' as propertyShape, null as offendingValue, " + propertyNameFragment + severityFragment + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " + ' should be a relationship but it is a property' as message , " + customMsgFragment);
                break;
            }
            case "GetRangeType1": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_REL_WHERE : CYPHER_MATCH_ALL_REL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT x:`%s` RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.CLASS_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.nodesAreUriIdentified() ? " x.uri " : " id(x) ") + " as offendingValue, " + propertyNameFragment + severityFragment + " 'value should be of type ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s')" : " '%s' ") + " as message , " + customMsgFragment);
                break;
            }
            case "GetRangeType2": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " focus.`%s` is not null RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.CLASS_CONSTRAINT_COMPONENT + "' as propertyShape, focus.`%s` as offendingValue, " + propertyNameFragment + severityFragment + "'%s should be a relationship but it is a property' as message , " + customMsgFragment);
                break;
            }
            case "InLiterals": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind [] + focus.`%s` as val with focus, val where %s val in params.theInLiterals RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.IN_CONSTRAINT_COMPONENT + "' as propertyShape, val as offendingValue, " + propertyNameFragment + severityFragment + "'The value \"'+ val + '\" in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s'") + "+ 'is not in  the accepted list' as message , " + customMsgFragment);
                break;
            }
            case "TypeAsLabelInUris": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind labels(focus) as val with focus, val  where val <> 'Resource' and %s val in params.theInTypeTranslatedUris RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.IN_CONSTRAINT_COMPONENT + "' as propertyShape, val as offendingValue, " + (String)(this.gc == null || this.gc.getGraphMode() == 1 ? " 'type' " : " '" + RDF.TYPE.stringValue() + "' ") + " as propertyName, " + severityFragment + "'The label \"'+ val + '\" is not in  the accepted list' as message , " + customMsgFragment);
                break;
            }
            case "TypeAsNodeInUris": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind [(focus)-[:`%s`]->(x) | x ] as val with focus, val where %s val.uri in params.theInTypeUris RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.IN_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.nodesAreUriIdentified() ? "val.uri" : "id(val)") + " as offendingValue, " + propertyNameFragment + severityFragment + "'The type \"'+ val.uri + '\" (node connected through property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s'") + "+ ') is not in  the accepted list' as message , " + customMsgFragment);
                break;
            }
            case "InUris": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true with params, focus unwind [(focus)-[:`%s`]->(x) | x ] as val with focus, val where %s val.uri in params.theInUris RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.IN_CONSTRAINT_COMPONENT + "' as propertyShape, " + (this.nodesAreUriIdentified() ? "val.uri" : "id(val)") + " as offendingValue, " + propertyNameFragment + severityFragment + "'The value \"'+ " + (this.nodesAreUriIdentified() ? " val.uri " : " 'node id: '  + id(val) ") + " + '\" in property ' + " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm('%s') " : " '%s'") + "+ ' is not in  the accepted list' as message , " + customMsgFragment);
                break;
            }
            case "Regex": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT all(x in [] +  coalesce(focus.`%s`,[]) where toString(x) =~ params.theRegex )   UNWIND [x in [] +  coalesce(focus.`%s`,[]) where not toString(x) =~ params.theRegex ]  as offval RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.PATTERN_CONSTRAINT_COMPONENT + "' as propertyShape, offval as offendingValue, " + propertyNameFragment + severityFragment + "'The value of the property does not match the specified regular expression' as message , " + customMsgFragment);
                break;
            }
            case "TypeAsLabelMinCardinality": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT %s size(" + (this.nodesAreUriIdentified() ? " [x in labels(focus) where x <> 'Resource' ] " : " labels(focus) ") + ") %s RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape,  'number of labels (' + size(" + (this.nodesAreUriIdentified() ? " [x in labels(focus) where x <> 'Resource' ] " : " labels(focus) ") + ") +') is outside the defined min-max limits'  as message, " + propertyNameFragment + severityFragment + " null as offendingValue , " + customMsgFragment);
                break;
            }
            case "TypeAsNodeMinCardinality": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT %s ( size([(focus)-[rel:`%s`]->() | rel ])) %s RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape,  'type cardinality (' + coalesce(size([(focus)-[rel:`%s`]->() | rel ]),0) + ') is outside the defined min-max limits'  as message, " + propertyNameFragment + severityFragment + " null as offendingValue , " + customMsgFragment);
                break;
            }
            case "MinCardinality1": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT %s ( size([(focus)-[rel:`%s`]->()| rel ]) +  size([] + coalesce(focus.`%s`, [])) ) %s RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape,  'cardinality (' + (coalesce(size([(focus)-[rel:`%s`]->()| rel ]),0) + coalesce(size([] + focus.`%s`),0)) + ') is outside the defined min-max limits'  as message, " + propertyNameFragment + severityFragment + "null as offendingValue , " + customMsgFragment);
                break;
            }
            case "HasOverlappingValuesinProps": {
                StringBuilder suffix1Props = new StringBuilder(" true with focus , [] + coalesce(focus.`%s`, []) as __baseprop ");
                StringBuilder suffix2Props = new StringBuilder(" where ");
                int pid = 0;
                for (String prop : propOrRelList) {
                    suffix1Props.append(", [] + coalesce(focus.`" + UriUtils.translateUri(prop, this.tx, this.gc) + "`, []) as __p" + pid + " ");
                    suffix2Props.append(pid > 0 ? " or " : "").append(" any(x IN __baseprop WHERE x in __p" + pid + " ) ");
                    ++pid;
                }
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), suffix1Props.toString() + suffix2Props + " RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.DISJOINT_CONSTRAINT_COMPONENT + "' as propertyShape,  'property value overlaps with expected disjoint props'  as message, " + propertyNameFragment + severityFragment + "focus.`%s` as offendingValue , " + customMsgFragment);
                break;
            }
            case "HasOverlappingValuesinRels": {
                String suffix1Rels = " true with distinct focus, x ";
                StringBuilder suffix2Rels = new StringBuilder(" where ");
                int rid = 0;
                for (String prop : propOrRelList) {
                    suffix2Rels.append(rid > 0 ? " or " : "").append(" (focus)-[:`" + UriUtils.translateUri(prop, this.tx, this.gc) + "`]->(x) ");
                    ++rid;
                }
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_REL_WHERE : CYPHER_MATCH_ALL_REL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), suffix1Rels + suffix2Rels + " RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.DISJOINT_CONSTRAINT_COMPONENT + "' as propertyShape,  'relationship target overlaps with expected disjoint rels'  as message, " + propertyNameFragment + severityFragment + (this.nodesAreUriIdentified() ? " x.uri " : " id(x) ") + " as offendingValue , " + customMsgFragment);
                break;
            }
            case "MinCardinality1Inverse": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT %s size([(focus)<-[rel:`%s`]-() | rel ]) %s RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape,  'incoming cardinality (' + coalesce(size([ (focus)<-[rel:`%s`]-()| rel ]),0) +') is outside the defined min-max limits' as message, " + propertyNameFragment + severityFragment + "null as offendingValue , " + customMsgFragment);
                break;
            }
            case "StrLen": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT all(x in [] +  focus.`%s` where %s size(toString(x)) %s ) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape, focus.`%s` as offendingValue, " + propertyNameFragment + severityFragment + "'' as message , " + customMsgFragment);
                break;
            }
            case "ValueRange": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), "NOT all(x in [] +  focus.`%s` where %s x %s ) RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape, focus.`%s` as offendingValue, " + propertyNameFragment + severityFragment + "'' as message , " + customMsgFragment);
                break;
            }
            case "NodeStructure": {
                query = this.getQuery(constraintType == 1 ? CYPHER_WITH_PARAMS_MATCH_WHERE : CYPHER_WITH_PARAMS_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " true \nUNWIND [ x in [(focus)-[r]->()| type(r)] where not x in params.allAllowedProps] + [ x in keys(focus) where " + (this.nodesAreUriIdentified() ? " x <> 'uri' and " : "") + " not x in params.allAllowedProps] as noProp\nRETURN  " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'" + SHACL.CLOSED_CONSTRAINT_COMPONENT + "' as propertyShape, substring(reduce(result='', x in [] + coalesce(focus[noProp],[(focus)-[r]-(x) where type(r)=noProp | " + (this.nodesAreUriIdentified() ? " x.uri " : " id(x) ") + "]) | result + ', ' + x ),2) as offendingValue, " + (this.shallIShorten() ? "n10s.rdf.fullUriFromShortForm(noProp)" : " noProp ") + " as propertyName, " + severityFragment + "'Closed type definition does not include this property/relationship' as message , " + customMsgFragment);
                break;
            }
            case "reqAndDisjointClass": {
                query = this.getQuery(constraintType == 1 ? CYPHER_MATCH_WHERE : CYPHER_MATCH_ALL_WHERE, tx, (String)(constraintType == 2 ? customWhere + " and " : ""), " %s focus:`%s` RETURN " + nodeIdFragment + (String)nodeTypeFragment + shapeIdFragment + "'%s' as propertyShape, '%s' as offendingValue, '" + (Serializable)(this.gc != null && this.gc.getHandleVocabUris() != 2 ? RDF.TYPE : "type") + "' as propertyName, " + severityFragment + " 'type %s: %s' as message , " + customMsgFragment);
            }
        }
        return String.format(query, args);
    }

    private boolean nodesAreUriIdentified() {
        return this.gc != null;
    }

    private boolean shallIShorten() {
        return this.gc != null && (this.gc.getHandleVocabUris() == 0 || this.gc.getHandleVocabUris() == 1);
    }

    private String getQuery(String pref, boolean tx, String queryConstraintWhere, String suff) {
        return pref + (tx ? CYPHER_TX_INFIX : "") + queryConstraintWhere + suff;
    }
}

