/*
 * Decompiled with CFR 0.152.
 */
package n10s.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import n10s.validation.ConstraintComponent;
import n10s.validation.SHACLValidationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;

public class ValidatorConfig {
    private static final int UNION_BATCH_SIZE = 4;
    private final Map<String, Object> allParams;
    private final List<ConstraintComponent> constraintList;
    private final Map<String, String> individualGlobalQueries;
    private final Map<String, String> individualNodeSetQueries;
    private final Map<String, Set<String>> triggerList;

    public ValidatorConfig() {
        this.allParams = new HashMap<String, Object>();
        this.constraintList = new ArrayList<ConstraintComponent>();
        this.individualGlobalQueries = new HashMap<String, String>();
        this.individualNodeSetQueries = new HashMap<String, String>();
        this.triggerList = new HashMap<String, Set<String>>();
    }

    public ValidatorConfig(Map<String, String> globalQueries, Map<String, String> nodeSetQueries, Map<String, Set<String>> triggerList, Map<String, Object> params) {
        this.individualGlobalQueries = globalQueries;
        this.individualNodeSetQueries = nodeSetQueries;
        this.triggerList = triggerList;
        this.allParams = params;
        this.constraintList = null;
    }

    public ValidatorConfig(Transaction tx) throws IOException, ClassNotFoundException {
        Result loadValidatorFromDBResult = tx.execute("MATCH (vc:_n10sValidatorConfig { _id: 1}) RETURN vc");
        if (!loadValidatorFromDBResult.hasNext()) {
            throw new SHACLValidationException("No shapes compiled");
        }
        Node validationConfigNode = (Node)loadValidatorFromDBResult.next().get("vc");
        this.individualGlobalQueries = (Map)this.deserialiseObject((byte[])validationConfigNode.getProperty("_gq"));
        this.individualNodeSetQueries = (Map)this.deserialiseObject((byte[])validationConfigNode.getProperty("_nsq"));
        this.triggerList = (Map)this.deserialiseObject((byte[])validationConfigNode.getProperty("_tl"));
        this.allParams = (Map)this.deserialiseObject((byte[])validationConfigNode.getProperty("_params"));
        this.constraintList = (List)this.deserialiseObject((byte[])validationConfigNode.getProperty("_constraintList"));
    }

    public Map<String, Object> getAllParams() {
        return this.allParams;
    }

    public List<ConstraintComponent> getConstraintList() {
        return this.constraintList;
    }

    public Map<String, String> getIndividualGlobalQueries() {
        return this.individualGlobalQueries;
    }

    public Map<String, String> getIndividualNodeSetQueries() {
        return this.individualNodeSetQueries;
    }

    public Map<String, Set<String>> getTriggerList() {
        return this.triggerList;
    }

    public void addConstraintToList(ConstraintComponent cc) {
        this.constraintList.add(cc);
    }

    public void addQueryAndTriggers(String queryId, String queryGlobal, String queryOnNodeSet, List<String> triggers) {
        this.individualGlobalQueries.put(queryId, queryGlobal);
        this.individualNodeSetQueries.put(queryId, queryOnNodeSet);
        for (String trigger : triggers) {
            if (this.triggerList.containsKey(trigger)) {
                this.triggerList.get(trigger).add(queryId);
                continue;
            }
            HashSet<String> queryIdSet = new HashSet<String>();
            queryIdSet.add(queryId);
            this.triggerList.put(trigger, queryIdSet);
        }
    }

    public List<String> selectQueriesAndBatchFromTriggerList(boolean global, Set<String> triggerers) {
        HashSet queries = new HashSet();
        HashSet<String> queryIds = new HashSet<String>();
        for (String triggerer : triggerers) {
            Set<String> querySet = this.triggerList.get(triggerer);
            if (querySet == null || querySet.size() <= 0) continue;
            queryIds.addAll(querySet);
        }
        queryIds.forEach(x -> queries.add(global ? this.individualGlobalQueries.get(x) : this.individualNodeSetQueries.get(x)));
        ArrayList<String> runnableQueries = new ArrayList<String>();
        int i = 0;
        StringBuilder sb = this.newInitialisedStringBuilder();
        for (String q : queries) {
            sb.append("\n UNION \n").append(q);
            if (++i < 4) continue;
            runnableQueries.add(sb.toString());
            i = 0;
            sb = this.newInitialisedStringBuilder();
        }
        if (sb.length() > 0) {
            runnableQueries.add(sb.toString());
        }
        return runnableQueries;
    }

    public List<String> generateRunnableQueries(Transaction tx, boolean global, List<Node> nodeSet) {
        List labels;
        if (global) {
            labels = (List)tx.execute("call db.labels() yield label return collect(label) as labelsInUse").next().get("labelsInUse");
        } else {
            HashMap<String, List<Node>> params = new HashMap<String, List<Node>>();
            params.put("nodeList", nodeSet);
            labels = (List)tx.execute("unwind $nodeList as node\nwith collect(distinct labels(node)) as nodeLabelSet \nreturn reduce(res=[], x in nodeLabelSet | res + x) as fullNodeLabelWithDuplicates", params).next().get("fullNodeLabelWithDuplicates");
        }
        labels.add("");
        return this.selectQueriesAndBatchFromTriggerList(global, new HashSet<String>(labels));
    }

    private StringBuilder newInitialisedStringBuilder() {
        return new StringBuilder().append("UNWIND [] as row RETURN '' as nodeId, '' as nodeType, '' as shapeId, '' as propertyShape, '' as offendingValue, '' as propertyName, '' as severity , '' as message, '' as customMsg ");
    }

    public void writeToDB(Transaction tx) throws IOException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>();
        params.put("gq", this.serialiseObject(this.individualGlobalQueries));
        params.put("nsq", this.serialiseObject(this.individualNodeSetQueries));
        params.put("tl", this.serialiseObject(this.triggerList));
        params.put("cl", this.serialiseObject(this.constraintList));
        params.put("params", this.serialiseObject(this.allParams));
        tx.execute("MERGE (vc:_n10sValidatorConfig { _id: 1}) SET vc._gq = $gq, vc._nsq = $nsq, vc._tl = $tl, vc._params = $params,  vc._constraintList = $cl ", params);
    }

    private byte[] serialiseObject(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
        objectOutputStream.writeObject(o);
        objectOutputStream.flush();
        objectOutputStream.close();
        return baos.toByteArray();
    }

    private Object deserialiseObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return objectInputStream.readObject();
    }
}

