/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.parser;

import org.neo4j.cypher.internal.frontend.v3_4.parser.BufferPosition$;
import org.neo4j.cypher.internal.frontend.v3_4.parser.InvalidInputErrorFormatter;
import org.neo4j.cypher.internal.frontend.v3_4.parser.ParserTest;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.scala.ParsingResult;
import org.parboiled.scala.package$;
import org.parboiled.scala.rules.Rule1;
import org.scalatest.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class ParserTest$class {
    public static ParserTest.ResultCheck parsing(ParserTest $this, String s, Rule1 p) {
        return ParserTest$class.convertResult($this, ParserTest$class.parseRule($this, (Rule1)p.$tilde(package$.MODULE$.EOI()), s), s);
    }

    public static ParserTest.ResultCheck partiallyParsing(ParserTest $this, String s, Rule1 p) {
        return ParserTest$class.convertResult($this, ParserTest$class.parseRule($this, p, s), s);
    }

    public static void assertFails(ParserTest $this, String s, Rule1 p) {
        Option option = ParserTest$class.parseRule($this, (Rule1)p.$tilde(package$.MODULE$.EOI()), s).result();
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object thing = some.x();
            throw ((Assertions)$this).fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' should not have been parsed correctly, parsed as ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, thing})));
        }
        throw new MatchError((Object)option);
    }

    private static ParsingResult parseRule(ParserTest $this, Rule1 rule, String text) {
        return package$.MODULE$.ReportingParseRunner().apply(rule).run(package$.MODULE$.string2Input(text));
    }

    private static ParserTest.ResultCheck convertResult(ParserTest $this, ParsingResult r, String input) {
        Option option = r.result();
        if (option instanceof Some) {
            Some some = (Some)option;
            Object t = some.x();
            ParserTest.ResultCheck resultCheck = new ParserTest.ResultCheck($this, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.convert(t)})), input);
            return resultCheck;
        }
        if (None$.MODULE$.equals(option)) {
            throw ((Assertions)$this).fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' failed with: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input}))).append((Object)((TraversableOnce)r.parseErrors().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(ParseError x0$1) {
                    String string;
                    ParseError parseError = x0$1;
                    if (parseError instanceof InvalidInputError) {
                        InvalidInputError invalidInputError = (InvalidInputError)parseError;
                        InputPosition position = BufferPosition$.MODULE$.apply(invalidInputError.getInputBuffer(), invalidInputError.getStartIndex());
                        String message = new InvalidInputErrorFormatter().format(invalidInputError);
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, position}));
                    } else {
                        string = parseError.getClass().getSimpleName();
                    }
                    return string;
                }
            }, List$.MODULE$.canBuildFrom())).mkString(",")).toString());
        }
        throw new MatchError((Object)option);
    }

    public static void $init$(ParserTest $this) {
    }
}

