/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.DummyPosition$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec$;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.v3_4.expressions.ContainerIndex;
import org.neo4j.cypher.internal.v3_4.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_4.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.SignedDecimalIntegerLiteral;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001#\t\u00112i\u001c8uC&tWM]%oI\u0016DH+Z:u\u0015\t\u0019A!A\u0005tK6\fg\u000e^5dg*\u0011QAB\u0001\u0005mNzFG\u0003\u0002\b\u0011\u0005AaM]8oi\u0016tGM\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001E*f[\u0006tG/[2Gk:\u001cV/\u001b;f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0014\u0001!91\u0004\u0001b\u0001\n\u0003a\u0012a\u00033v[6L8\u000b\u001e:j]\u001e,\u0012!\b\t\u0003=\tj\u0011a\b\u0006\u0003A\u0005\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011Q\u0001C\u0005\u0003G}\u0011q\u0002R;n[f,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007K\u0001\u0001\u000b\u0011B\u000f\u0002\u0019\u0011,X.\\=TiJLgn\u001a\u0011\t\u000f\u001d\u0002!\u0019!C\u00019\u0005aA-^7ns&sG/Z4fe\"1\u0011\u0006\u0001Q\u0001\nu\tQ\u0002Z;n[fLe\u000e^3hKJ\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001H\u0001\nIVlW.\u001f(pI\u0016Da!\f\u0001!\u0002\u0013i\u0012A\u00033v[6Lhj\u001c3fA!9q\u0006\u0001b\u0001\n\u0003a\u0012\u0001\u00033v[6L\u0018I\\=\t\rE\u0002\u0001\u0015!\u0003\u001e\u0003%!W/\\7z\u0003:L\b\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u000f\u0002\u0013\u0011,X.\\=MSN$\bBB\u001b\u0001A\u0003%Q$\u0001\u0006ek6l\u0017\u0010T5ti\u0002BQa\u000e\u0001\u0005\na\nA\"Y:tKJ$\u0018j\u001d'jgR$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0001Z\u0002\r!Q\u0001\u0005gB,7\r\u0005\u0002C\u00116\t1I\u0003\u0002E\u000b\u000691/_7c_2\u001c(BA\u0003G\u0015\t9\u0005\"\u0001\u0003vi&d\u0017BA%D\u0005!!\u0016\u0010]3Ta\u0016\u001c\u0007\"B&\u0001\t\u0013a\u0015aC1tg\u0016\u0014H/S:NCB$\"!O'\t\u000b\u0001S\u0005\u0019A!")
public class ContainerIndexTest
extends SemanticFunSuite {
    private final DummyExpression dummyString = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyInteger = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyNode = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyAny = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTAny()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyList = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());

    public DummyExpression dummyString() {
        return this.dummyString;
    }

    public DummyExpression dummyInteger() {
        return this.dummyInteger;
    }

    public DummyExpression dummyNode() {
        return this.dummyNode;
    }

    public DummyExpression dummyAny() {
        return this.dummyAny;
    }

    public DummyExpression dummyList() {
        return this.dummyList;
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$semantics$ContainerIndexTest$$assertIsList(TypeSpec spec) {
        TypeSpec intersection;
        TypeSpec typeSpec = intersection = spec.$amp(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()).covariant());
        TypeSpec typeSpec2 = TypeSpec$.MODULE$.none();
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((!(typeSpec != null ? !typeSpec.equals(typeSpec2) : typeSpec2 != null) ? 1 : 0) != 0)).should(this.be().apply(false));
        this.convertToAnyShouldWrapper(spec).should(this.equal(intersection), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$semantics$ContainerIndexTest$$assertIsMap(TypeSpec spec) {
        TypeSpec intersection;
        TypeSpec typeSpec = intersection = spec.$amp(package$.MODULE$.CTMap().covariant());
        TypeSpec typeSpec2 = TypeSpec$.MODULE$.none();
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((!(typeSpec != null ? !typeSpec.equals(typeSpec2) : typeSpec2 != null) ? 1 : 0) != 0)).should(this.be().apply(false));
        this.convertToAnyShouldWrapper(spec).should(this.equal(intersection), (Object)Equality$.MODULE$.default());
    }

    public ContainerIndexTest() {
        this.test("should detect list lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyList();
                DummyExpression rhs = this.$outer.dummyInteger();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$ContainerIndexTest$$assertIsList((TypeSpec)this.$outer.types((Expression)lhs).apply((Object)result.state()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTInteger().covariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should detect node lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyNode();
                DummyExpression rhs = this.$outer.dummyString();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$ContainerIndexTest$$assertIsMap((TypeSpec)this.$outer.types((Expression)lhs).apply((Object)result.state()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(((CypherType)package$.MODULE$.CTString()).covariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().covariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should type as any if given untyped lookup arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyAny();
                DummyExpression rhs = this.$outer.dummyAny();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)lhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().contravariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().contravariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(TypeSpec$.MODULE$.all()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return list inner types of expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ContainerIndex index = new ContainerIndex((Expression)this.$outer.dummyList(), (Expression)new SignedDecimalIntegerLiteral("1", DummyPosition$.MODULE$.apply(5)), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should raise error if indexing by fraction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ContainerIndex index = new ContainerIndex((Expression)this.$outer.dummyList(), (Expression)new DecimalDoubleLiteral("1.3", DummyPosition$.MODULE$.apply(5)), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: expected Integer but was Float", index.idx().position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

