/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.DummyPosition$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.SignedHexIntegerLiteral;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001#\t)\u0002*\u001a=J]R,w-\u001a:MSR,'/\u00197UKN$(BA\u0002\u0005\u0003%\u0019X-\\1oi&\u001c7O\u0003\u0002\u0006\r\u0005!aoM05\u0015\t9\u0001\"\u0001\u0005ge>tG/\u001a8e\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003!M+W.\u00198uS\u000e4UO\\*vSR,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0003\u001c\u0001\u0011%A$A\nbgN,'\u000f^*f[\u0006tG/[2FeJ|'\u000fF\u0002\u001eG1\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011A!\u00168ji\")AE\u0007a\u0001K\u0005Y1\u000f\u001e:j]\u001e4\u0016\r\\;f!\t1\u0013F\u0004\u0002\u001fO%\u0011\u0001fH\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)?!)QF\u0007a\u0001K\u0005aQM\u001d:pe6+7o]1hK\u0002")
public class HexIntegerLiteralTest
extends SemanticFunSuite {
    public void org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        SignedHexIntegerLiteral literal = new SignedHexIntegerLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.check((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$, (Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public HexIntegerLiteralTest() {
        this.test("correctly parses hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x22", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right = 34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x0", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0xffFF", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right3 = 65535;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("-0x9abc", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right4 = -39612;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError("0x12g3", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError("0x", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError("0x33Y23", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError("-0x12g3", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large hexadecimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$HexIntegerLiteralTest$$assertSemanticError("0xfffffffffffffffff", "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

