/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.Literal;
import org.neo4j.cypher.internal.v3_4.expressions.StringLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.UnsignedDecimalIntegerLiteral;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001#\tYA*\u001b;fe\u0006dG+Z:u\u0015\t\u0019A!A\u0005tK6\fg\u000e^5dg*\u0011QAB\u0001\u0005mNzFG\u0003\u0002\b\u0011\u0005AaM]8oi\u0016tGM\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!\u0001E*f[\u0006tG/[2Gk:\u001cV/\u001b;f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0014\u0001!)1\u0004\u0001C\u00059\u0005\u0019\u0012m]:feR\u001cV-\\1oi&\u001cWI\u001d:peR\u0019Qd\t\u0017\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006Ii\u0001\r!J\u0001\bY&$XM]1m!\t1#&D\u0001(\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\t\u0013\tYsEA\u0004MSR,'/\u00197\t\u000b5R\u0002\u0019\u0001\u0018\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\u0005=\u0012dB\u0001\u00101\u0013\t\tt$\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019 \u0001")
public class LiteralTest
extends SemanticFunSuite {
    public void org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError(Literal literal, String errorMessage) {
        SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, this.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public LiteralTest() {
        this.test("has type CTString", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("foo", this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)literal).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = ((CypherType)org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTString()).invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("22", this.$outer.pos()).value());
                int $org_scalatest_assert_macro_right = 22;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("0", this.$outer.pos()).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("12g3"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("923_23"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("999999999999999999999999999"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.signedDecimal("22").value());
                int $org_scalatest_assert_macro_right = 22;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("0").value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("-0").value());
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("-432").value());
                int $org_scalatest_assert_macro_right4 = -432;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("12g3"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("923_23"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("-92f3"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("999999999999999999999999999"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses decimal double numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.decimalDouble("22.34").value());
                double $org_scalatest_assert_macro_right = 22.34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-2342.34").value());
                double $org_scalatest_assert_macro_right2 = -2342.34;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("0.34").value());
                double $org_scalatest_assert_macro_right3 = 0.34;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-.23").value());
                double $org_scalatest_assert_macro_right4 = -0.23;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("0.0").value());
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-0.0").value());
                double $org_scalatest_assert_macro_right6 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1E23").value());
                double $org_scalatest_assert_macro_right7 = 1.0E23;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1e23").value());
                double $org_scalatest_assert_macro_right8 = 1.0E23;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-134E233").value());
                double $org_scalatest_assert_macro_right9 = -1.34E235;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-134e233").value());
                double $org_scalatest_assert_macro_right10 = -1.34E235;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1E-99").value());
                double $org_scalatest_assert_macro_right11 = 1.0E-99;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1e-99").value());
                double $org_scalatest_assert_macro_right12 = 1.0E-99;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-4E-593").value());
                double $org_scalatest_assert_macro_right13 = -0.0;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-4e-593").value());
                double $org_scalatest_assert_macro_right14 = -0.0;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("3.42E34").value());
                double $org_scalatest_assert_macro_right15 = 3.42E34;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("3.42e34").value());
                double $org_scalatest_assert_macro_right16 = 3.42E34;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-65.342546547E33").value());
                double $org_scalatest_assert_macro_right17 = -6.5342546547E34;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-65.342546547e33").value());
                double $org_scalatest_assert_macro_right18 = -6.5342546547E34;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("73.234E-235").value());
                double $org_scalatest_assert_macro_right19 = 7.3234E-234;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("73.234e-235").value());
                double $org_scalatest_assert_macro_right20 = 7.3234E-234;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-73.234E-235").value());
                double $org_scalatest_assert_macro_right21 = -7.3234E-234;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-73.234e-235").value());
                double $org_scalatest_assert_macro_right22 = -7.3234E-234;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid decimal double numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("33..34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("3f.34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("3._4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2EE4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2eE4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2Ee4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2ee4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2E--4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2e--4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2E"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2e"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2..3E34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2..3e34"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("1E9999"), "floating point number is too large");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("1e9999"), "floating point number is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.signedOctal("022").value());
                int $org_scalatest_assert_macro_right = 18;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.signedOctal("00").value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.signedOctal("0734").value());
                int $org_scalatest_assert_macro_right3 = 476;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.signedOctal("0034").value());
                int $org_scalatest_assert_macro_right4 = 28;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("0393"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("03f4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("-0934"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("077777777777777777777777777777"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

