/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.symbols;

import org.neo4j.cypher.internal.util.v3_4.symbols.AnyType;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.ListType;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001#\tq1)\u001f9iKJ$\u0016\u0010]3UKN$(BA\u0002\u0005\u0003\u001d\u0019\u00180\u001c2pYNT!!\u0002\u0004\u0002\tY\u001ct\f\u000e\u0006\u0003\u000f!\t\u0001B\u001a:p]R,g\u000e\u001a\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\u0005kRLG.\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u0015\t\u0003\u0001\"\u0003#\u0003U\t7o]3si2+\u0017m\u001d;VaB,'OQ8v]\u0012$BaI\u00151eA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t!QK\\5u\u0011\u0015Q\u0003\u00051\u0001,\u0003\u0005\t\u0007C\u0001\u0017/\u001b\u0005i#BA\u0002\u0017\u0013\tySF\u0001\u0006DsBDWM\u001d+za\u0016DQ!\r\u0011A\u0002-\n\u0011A\u0019\u0005\u0006g\u0001\u0002\raK\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000bU\u0002A\u0011\u0002\u001c\u00021\u0005\u001c8/\u001a:u\u000fJ,\u0017\r^3ti2{w/\u001a:C_VtG\r\u0006\u0003$oaJ\u0004\"\u0002\u00165\u0001\u0004Y\u0003\"B\u00195\u0001\u0004Y\u0003\"B\u001a5\u0001\u0004Q\u0004c\u0001\u0013<W%\u0011A(\n\u0002\u0007\u001fB$\u0018n\u001c8")
public class CypherTypeTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound(CypherType a, CypherType b, CypherType result) {
        CypherType simpleMergedType = a.leastUpperBound(b);
        this.convertToAnyShouldWrapper(simpleMergedType).should(this.equal(result), (Object)Equality$.MODULE$.default());
        CypherType listMergedType = package$.MODULE$.CTList(a).leastUpperBound((CypherType)package$.MODULE$.CTList(b));
        this.convertToAnyShouldWrapper(listMergedType).should(this.equal(package$.MODULE$.CTList(result)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound(CypherType a, CypherType b, Option<CypherType> result) {
        Option simpleMergedType = a.greatestLowerBound(b);
        this.convertToAnyShouldWrapper(simpleMergedType).should(this.equal(result), (Object)Equality$.MODULE$.default());
        Option listMergedType = package$.MODULE$.CTList(a).greatestLowerBound((CypherType)package$.MODULE$.CTList(b));
        this.convertToAnyShouldWrapper(listMergedType).should(this.equal(result.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ListType apply(CypherType t) {
                return package$.MODULE$.CTList(t);
            }
        })), (Object)Equality$.MODULE$.default());
    }

    public CypherTypeTest() {
        this.test("parents should be full path up type tree branch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTInteger().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTNumber(), package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTNumber().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyType[]{package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTAny().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()).parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeSpec covariant = ((CypherType)package$.MODULE$.CTGraphRef()).covariant();
                String s = covariant.toString();
                this.$outer.convertToAnyShouldWrapper(covariant).should(this.$outer.not()).be(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be assignable from sub-type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTNumber().isAssignableFrom((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTAny().isAssignableFrom((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()).isAssignableFrom((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber()).isAssignableFrom((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTInteger().isAssignableFrom((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger()).isAssignableFrom((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find leastUpperBound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTString(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTMap(), (CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTAny());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find greatestLowerBound", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber(), (Option<CypherType>)new Some((Object)package$.MODULE$.CTNumber()));
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTAny(), (Option<CypherType>)new Some((Object)package$.MODULE$.CTNumber()));
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger()), (Option<CypherType>)new Some((Object)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger())));
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTString(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTFloat(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTMap(), (CypherType)package$.MODULE$.CTFloat(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$frontend$v3_4$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTBoolean(), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option<CypherType>)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

