/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.symbols;

import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.ListType;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeRange;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeRange$;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\tiA+\u001f9f%\u0006tw-\u001a+fgRT!a\u0001\u0003\u0002\u000fMLXNY8mg*\u0011QAB\u0001\u0005mNzFG\u0003\u0002\b\u0011\u0005AaM]8oi\u0016tGM\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005MIR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0003\u0018\u0015\tA\u0002\"\u0001\u0003vi&d\u0017B\u0001\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002")
public class TypeRangeTest
extends CypherFunSuite {
    public TypeRangeTest() {
        this.test("TypeRange of single type should contain only that type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfListAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfListAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at CTAny should contain all", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtAny = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTNode()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTFloat())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTFloat()))))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at leaf type should contain leaf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtListOfNumber = new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListOfNumber.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListOfNumber.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTFloat())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListOfNumber.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListOfNumber.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListOfNumber.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at branch type should contain all more specific types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtListAny = new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTInteger()))))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTBoolean()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtListAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should contain overlapping range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtNumber.contains(rangeRootedAtInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumberToDouble = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTFloat());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfDouble = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTFloat());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtDouble = new TypeRange((CypherType)package$.MODULE$.CTFloat(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtDouble.contains(rangeOfDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains(rangeRootedAtDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with overlapping range should not change range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeRootedAtInteger.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeRootedAtInteger)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeOfInteger)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeOfNumber)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with intersecting range should return intersection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                TypeRange rangeToNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeToNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range to sub range should return sub range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfAll = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger()))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumberToInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumberToInteger.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumberToInteger.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range within list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromListAny = new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromListAny.$amp(new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeFromListAny.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with non overlapping range should return none", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTBoolean(), (CypherType)package$.MODULE$.CTBoolean()))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.convertToAnyShouldWrapper(rangeOfAny.$amp(rangeFromNumber)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAny.$amp(rangeOfNumber)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeFromNumber.$amp(rangeOfAny)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(rangeOfAny)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("leastUpperBound with super type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromAny = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                TypeRange rangeOfAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.convertToAnyShouldWrapper(rangeFromAny.leastUpperBounds(rangeOfAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.leastUpperBounds(rangeOfAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.leastUpperBounds(rangeOfNumber)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfNumber}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("leastUpperBound with sub type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromListAny = new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                TypeRange rangeOfListAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()));
                this.$outer.convertToAnyShouldWrapper(rangeFromListAny.leastUpperBounds(rangeOfListAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfListAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeFromListString = new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromListAny.leastUpperBounds(rangeFromListString)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())), new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should have indefinite size when allowing unbound any at any depth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTInteger()).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny())), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reparent into list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$).reparent((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ListType apply(CypherType inner) {
                        return package$.MODULE$.CTList(inner);
                    }
                })).should(this.$outer.equal(new TypeRange((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()).reparent((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ListType apply(CypherType inner) {
                        return package$.MODULE$.CTList(inner);
                    }
                })).should(this.$outer.equal(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("without", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTInteger()).without((CypherType)package$.MODULE$.CTNumber())).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), package$.MODULE$.CTNumber().parentType()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()).without((CypherType)package$.MODULE$.CTInteger())).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$).without((CypherType)package$.MODULE$.CTInteger())).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), package$.MODULE$.CTInteger().parentType()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$).without((CypherType)package$.MODULE$.CTNumber())).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$).without((CypherType)package$.MODULE$.CTString())).should(this.$outer.equal(new Some((Object)new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()).without((CypherType)package$.MODULE$.CTString())).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

