/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.ast;

import org.neo4j.cypher.internal.frontend.v3_4.ast.LoadCSV;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.DummyPosition$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.TypeSpec;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.StringLiteral;
import org.neo4j.cypher.internal.v3_4.expressions.Variable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001#\tYAj\\1e\u0007N3F+Z:u\u0015\t\u0019A!A\u0002bgRT!!\u0002\u0004\u0002\tY\u001ct\f\u000e\u0006\u0003\u000f!\t\u0001B\u001a:p]R,g\u000e\u001a\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\u0005kRLG.\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u001d\t\u0003A1A\u0005\u0002\t\n!\u0002\\5uKJ\fG.\u0016*M+\u0005\u0019\u0003C\u0001\u0013)\u001b\u0005)#B\u0001\u0014(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0015A\u0011BA\u0015&\u00055\u0019FO]5oO2KG/\u001a:bY\"11\u0006\u0001Q\u0001\n\r\n1\u0002\\5uKJ\fG.\u0016*MA!9Q\u0006\u0001b\u0001\n\u0003q\u0013\u0001\u0003<be&\f'\r\\3\u0016\u0003=\u0002\"\u0001\n\u0019\n\u0005E*#\u0001\u0003,be&\f'\r\\3\t\rM\u0002\u0001\u0015!\u00030\u0003%1\u0018M]5bE2,\u0007\u0005")
public class LoadCSVTest
extends CypherFunSuite {
    private final StringLiteral literalURL = new StringLiteral("file:///tmp/foo.csv", DummyPosition$.MODULE$.apply(4));
    private final Variable variable = new Variable("a", DummyPosition$.MODULE$.apply(4));

    public StringLiteral literalURL() {
        return this.literalURL;
    }

    public Variable variable() {
        return this.variable;
    }

    public LoadCSVTest() {
        this.test("cannot overwrite existing variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when expecting headers, the variable has a map type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.variable()).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTMap().invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when not expecting headers, the variable has a list type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(false, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.variable()).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTList((CypherType)org.neo4j.cypher.internal.util.v3_4.symbols.package$.MODULE$.CTString()).invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should accept one-character wide field terminators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.variable(), (Option)new Some((Object)new StringLiteral("\t", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = package$.MODULE$.Vector().empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject more-than-one-character wide field terminators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.variable(), (Option)new Some((Object)new StringLiteral("  ", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("CSV field terminator can only be one character wide", DummyPosition$.MODULE$.apply(0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

