/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.helpers;

import org.neo4j.cypher.internal.util.v3_4.Fby;
import org.neo4j.cypher.internal.util.v3_4.Last;
import org.neo4j.cypher.internal.util.v3_4.NonEmptyList;
import org.neo4j.cypher.internal.util.v3_4.NonEmptyList$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\t\u0001bj\u001c8F[B$\u0018\u0010T5tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001[3ma\u0016\u00148O\u0003\u0002\u0006\r\u0005!aoM05\u0015\t9\u0001\"\u0001\u0005ge>tG/\u001a8e\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"aE\r\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u00159\"B\u0001\r\t\u0003\u0011)H/\u001b7\n\u0005i!\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\t\u0001")
public class NonEmptyListTest
extends CypherFunSuite {
    public NonEmptyListTest() {
        this.test("Should construct NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))).should(this.$outer.equal(new Last((Object)BoxesRunTime.boxToInteger((int)1))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))).should(this.$outer.equal(new Fby((Object)BoxesRunTime.boxToInteger((int)1), (NonEmptyList)new Last((Object)BoxesRunTime.boxToInteger((int)2)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should build NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Builder builder = NonEmptyList$.MODULE$.newBuilder();
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                builder.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))), (Object)Equality$.MODULE$.default());
                builder.$plus$eq((Object)BoxesRunTime.boxToInteger((int)2));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))), (Object)Equality$.MODULE$.default());
                builder.clear();
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should construct builders via canBuildFrom", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.canBuildFrom().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).result()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.canBuildFrom().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).$plus$eq((Object)BoxesRunTime.boxToInteger((int)2)).result()).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))), (Object)Equality$.MODULE$.default());
                Option result = (Option)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$1) {
                        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
                    }
                }, NonEmptyList$.MODULE$.canBuildFrom());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)"1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2", "3"})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should convert to NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.IterableConverter((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).toNonEmptyListOption()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.IterableConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).toNonEmptyListOption()).should(this.$outer.equal(new Some((Object)new Last((Object)BoxesRunTime.boxToInteger((int)1)))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.IterableConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).toNonEmptyListOption()).should(this.$outer.equal(new Some((Object)new Fby((Object)BoxesRunTime.boxToInteger((int)1), (NonEmptyList)new Last((Object)BoxesRunTime.boxToInteger((int)2))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should convert from NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).toIndexedSeq()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).toIterable().toArray(ClassTag$.MODULE$.Int())).should(this.$outer.equal(new int[]{1}), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2})).toIndexedSeq()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2})).toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2})).toIterable().toArray(ClassTag$.MODULE$.Int())).should(this.$outer.equal(new int[]{1, 2, 2}), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should inspect single element NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).head()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).tailOption()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).hasTail())).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).isLast())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should inspect multi element NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).head()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).tailOption()).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).hasTail())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).isLast())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should prepend single element to NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 2;
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should append single element to NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$colon$plus((Object)BoxesRunTime.boxToInteger((int)2))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should append single element to longer NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})).$colon$plus((Object)BoxesRunTime.boxToInteger((int)2))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should map and prepend reversed to NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})).mapAndPrependReversedTo((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$3) {
                        return this.apply$mcII$sp(x$3);
                    }

                    public int apply$mcII$sp(int x$3) {
                        return x$3 + 1;
                    }
                }, NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})).mapAndPrependReversedTo((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$4) {
                        return this.apply$mcII$sp(x$4);
                    }

                    public int apply$mcII$sp(int x$4) {
                        return x$4 + 1;
                    }
                }, NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).mapAndPrependReversedTo((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$5) {
                        return this.apply$mcII$sp(x$5);
                    }

                    public int apply$mcII$sp(int x$5) {
                        return x$5 + 1;
                    }
                }, NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).mapAndPrependReversedTo((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$6) {
                        return this.apply$mcII$sp(x$6);
                    }

                    public int apply$mcII$sp(int x$6) {
                        return x$6 + 1;
                    }
                }, NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should prepend multiple elements to NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator iterator = ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).iterator();
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$plus$colon(iterator)).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1}))), (Object)Equality$.MODULE$.default());
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$plus$colon((Iterable)seq)).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1}))), (Object)Equality$.MODULE$.default());
                Seq seq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$plus$colon((Iterable)seq2)).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
                Seq seq3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})).$plus$plus$colon((Iterable)seq3)).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4}))), (Object)Equality$.MODULE$.default());
                Seq seq4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5}));
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})).$plus$plus$colon((Iterable)seq4)).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5, 1, 4}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should concatenate NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$plus(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).$plus$plus(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).$plus$plus(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).$plus$plus(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})))).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5, 6}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should support foreach on NonEmptyLists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IntRef count = IntRef.create((int)0);
                NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).foreach((Function1)new Serializable(this, count){
                    public static final long serialVersionUID = 0L;
                    private final IntRef count$1;

                    public final void apply(int x$12) {
                        this.apply$mcVI$sp(x$12);
                    }

                    public void apply$mcVI$sp(int x$12) {
                        ++this.count$1.elem;
                    }
                    {
                        this.count$1 = count$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)count.elem)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})).foreach((Function1)new Serializable(this, count){
                    public static final long serialVersionUID = 0L;
                    private final IntRef count$1;

                    public final void apply(int x$13) {
                        this.apply$mcVI$sp(x$13);
                    }

                    public void apply$mcVI$sp(int x$13) {
                        this.count$1.elem += 2;
                    }
                    {
                        this.count$1 = count$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)count.elem)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)9)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should support filtering a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$14) {
                        return this.apply$mcZI$sp(x$14);
                    }

                    public boolean apply$mcZI$sp(int x$14) {
                        return x$14 == 0;
                    }
                })).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$15) {
                        return this.apply$mcZI$sp(x$15);
                    }

                    public boolean apply$mcZI$sp(int x$15) {
                        return x$15 == 1;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$16) {
                        return this.apply$mcZI$sp(x$16);
                    }

                    public boolean apply$mcZI$sp(int x$16) {
                        return x$16 == 0;
                    }
                })).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$17) {
                        return this.apply$mcZI$sp(x$17);
                    }

                    public boolean apply$mcZI$sp(int x$17) {
                        return x$17 <= 2;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$18) {
                        return this.apply$mcZI$sp(x$18);
                    }

                    public boolean apply$mcZI$sp(int x$18) {
                        return x$18 >= 0;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should map NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$19) {
                        return this.apply$mcII$sp(x$19);
                    }

                    public int apply$mcII$sp(int x$19) {
                        return x$19 + 1;
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$20) {
                        return this.apply$mcII$sp(x$20);
                    }

                    public int apply$mcII$sp(int x$20) {
                        return x$20 + 1;
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should collect from a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1 == true ? "Apa" : function1.apply((Object)BoxesRunTime.boxToInteger(x1));
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(int x1) {
                        int n = x1;
                        boolean bl = n == 1;
                        return bl;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)"Apa", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        Object object = A1 == true ? "Apa" : function1.apply((Object)BoxesRunTime.boxToInteger(x2));
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(int x2) {
                        int n = x2;
                        boolean bl = n == 1;
                        return bl;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)"Apa", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        A1 A1 = x3;
                        Object object = A1 != true ? "Apa" : function1.apply((Object)BoxesRunTime.boxToInteger(x3));
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(int x3) {
                        int n = x3;
                        boolean bl = n != 1;
                        return bl;
                    }
                })).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        A1 A1 = x4;
                        Object object = A1 != true ? "Apa" : function1.apply((Object)BoxesRunTime.boxToInteger(x4));
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(int x4) {
                        int n = x4;
                        boolean bl = n != 1;
                        return bl;
                    }
                })).should(this.$outer.equal(new Some((Object)NonEmptyList$.MODULE$.apply((Object)"Apa", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should reverseFlatMap a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).reverseFlatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})).reverseFlatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 8})).reverseFlatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 5, 4, 2, 1}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should flatMap a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 5}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 8})).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NonEmptyList<Object> apply(int x) {
                        return NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{x + 1}));
                    }
                })).should(this.$outer.equal(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 5, 8, 9}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should fold left over a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).foldLeft((Object)Seq$.MODULE$.empty(), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(Seq<Object> x$21, int x$22) {
                        return (Seq)x$21.$colon$plus((Object)BoxesRunTime.boxToInteger((int)x$22), Seq$.MODULE$.canBuildFrom());
                    }
                })).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).foldLeft((Object)Seq$.MODULE$.empty(), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(Seq<Object> x$23, int x$24) {
                        return (Seq)x$23.$colon$plus((Object)BoxesRunTime.boxToInteger((int)x$24), Seq$.MODULE$.canBuildFrom());
                    }
                })).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should left reduce a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)23), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).reduceLeft((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$25, int x$26) {
                        return this.apply$mcIII$sp(x$25, x$26);
                    }

                    public int apply$mcIII$sp(int x$25, int x$26) {
                        return x$25 + x$26;
                    }
                })).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)23)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)42), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{23})).reduceLeft((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$27, int x$28) {
                        return this.apply$mcIII$sp(x$27, x$28);
                    }

                    public int apply$mcIII$sp(int x$27, int x$28) {
                        return x$27 - x$28;
                    }
                })).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)19)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)42), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{23, 10})).reduceLeft((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x$29, int x$30) {
                        return this.apply$mcIII$sp(x$29, x$30);
                    }

                    public int apply$mcIII$sp(int x$29, int x$30) {
                        return x$29 - x$30;
                    }
                })).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)9)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should group a NonEmptyList by a key for each element", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x) {
                        return this.apply$mcII$sp(x);
                    }

                    public int apply$mcII$sp(int x) {
                        return x / 2;
                    }
                })).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x) {
                        return this.apply$mcII$sp(x);
                    }

                    public int apply$mcII$sp(int x) {
                        return x / 2;
                    }
                })).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])))}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int x) {
                        return this.apply$mcII$sp(x);
                    }

                    public int apply$mcII$sp(int x) {
                        return x / 2;
                    }
                })).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should find min in a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).min((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).min((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})).min((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).min((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should find max in a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).max((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})).max((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 2})).max((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{10})).max((Ordering)Ordering.Int$.MODULE$)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Should partition a NonEmptyList", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x == 1 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Left().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))), (Object)None$.MODULE$))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x != 1 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x == 1 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Left().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))), (Object)new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x != 1 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]))))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x != 0 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Left().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))), (Object)None$.MODULE$))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Product apply(int x) {
                        return x == 0 ? package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)x)) : package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)x));
                    }
                })).should(this.$outer.equal(package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("exists should work as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$31) {
                        return this.apply$mcZI$sp(x$31);
                    }

                    public boolean apply$mcZI$sp(int x$31) {
                        return x$31 == 2;
                    }
                }))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$32) {
                        return this.apply$mcZI$sp(x$32);
                    }

                    public boolean apply$mcZI$sp(int x$32) {
                        return x$32 == 1;
                    }
                }))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$33) {
                        return this.apply$mcZI$sp(x$33);
                    }

                    public boolean apply$mcZI$sp(int x$33) {
                        return x$33 == 4;
                    }
                }))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$34) {
                        return this.apply$mcZI$sp(x$34);
                    }

                    public boolean apply$mcZI$sp(int x$34) {
                        return x$34 < 4;
                    }
                }))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$35) {
                        return this.apply$mcZI$sp(x$35);
                    }

                    public boolean apply$mcZI$sp(int x$35) {
                        return x$35 >= 3;
                    }
                }))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("forall should work as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NonEmptyListTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$36) {
                        return this.apply$mcZI$sp(x$36);
                    }

                    public boolean apply$mcZI$sp(int x$36) {
                        return x$36 == 2;
                    }
                }))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[0])).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$37) {
                        return this.apply$mcZI$sp(x$37);
                    }

                    public boolean apply$mcZI$sp(int x$37) {
                        return x$37 == 1;
                    }
                }))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$38) {
                        return this.apply$mcZI$sp(x$38);
                    }

                    public boolean apply$mcZI$sp(int x$38) {
                        return x$38 == 4;
                    }
                }))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$39) {
                        return this.apply$mcZI$sp(x$39);
                    }

                    public boolean apply$mcZI$sp(int x$39) {
                        return x$39 < 4;
                    }
                }))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)NonEmptyList$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int x$40) {
                        return this.apply$mcZI$sp(x$40);
                    }

                    public boolean apply$mcZI$sp(int x$40) {
                        return x$40 >= 3;
                    }
                }))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

