/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.v3_4.semantics;

import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState;
import org.neo4j.cypher.internal.frontend.v3_4.semantics.SemanticState$;
import org.neo4j.cypher.internal.util.v3_4.InputPosition;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.v3_4.expressions.Expression;
import org.neo4j.cypher.internal.v3_4.expressions.LogicalVariable;
import org.neo4j.cypher.internal.v3_4.expressions.NodePattern;
import org.neo4j.cypher.internal.v3_4.expressions.PatternComprehension;
import org.neo4j.cypher.internal.v3_4.expressions.PatternElement;
import org.neo4j.cypher.internal.v3_4.expressions.Property;
import org.neo4j.cypher.internal.v3_4.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.v3_4.expressions.RelationshipChain;
import org.neo4j.cypher.internal.v3_4.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.v3_4.expressions.RelationshipPattern$;
import org.neo4j.cypher.internal.v3_4.expressions.RelationshipsPattern;
import org.neo4j.cypher.internal.v3_4.expressions.SemanticDirection;
import org.neo4j.cypher.internal.v3_4.expressions.StringLiteral;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001#\tA\u0002+\u0019;uKJt7i\\7qe\u0016DWM\\:j_:$Vm\u001d;\u000b\u0005\r!\u0011!C:f[\u0006tG/[2t\u0015\t)a!\u0001\u0003wg}#$BA\u0004\t\u0003!1'o\u001c8uK:$'BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0001cU3nC:$\u0018n\u0019$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\n\u0001\u0011\u001dY\u0002A1A\u0005\u0002q\t\u0011A\\\u000b\u0002;A\u0011aDI\u0007\u0002?)\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\u0011%\u00111e\b\u0002\f\u001d>$W\rU1ui\u0016\u0014h\u000e\u0003\u0004&\u0001\u0001\u0006I!H\u0001\u0003]\u0002Bqa\n\u0001C\u0002\u0013\u0005A$A\u0001y\u0011\u0019I\u0003\u0001)A\u0005;\u0005\u0011\u0001\u0010\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0003\u0005\u0011X#A\u0017\u0011\u0005yq\u0013BA\u0018 \u0005M\u0011V\r\\1uS>t7\u000f[5q!\u0006$H/\u001a:o\u0011\u0019\t\u0004\u0001)A\u0005[\u0005\u0011!\u000f\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003\u001d\u0001\u0018\r\u001e;fe:,\u0012!\u000e\t\u0003=YJ!aN\u0010\u0003)I+G.\u0019;j_:\u001c\b.\u001b9t!\u0006$H/\u001a:o\u0011\u0019I\u0004\u0001)A\u0005k\u0005A\u0001/\u0019;uKJt\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u0011A\u0014x\u000e]3sif,\u0012!\u0010\t\u0003=yJ!aP\u0010\u0003\u0011A\u0013x\u000e]3sifDa!\u0011\u0001!\u0002\u0013i\u0014!\u00039s_B,'\u000f^=!\u0011\u001d\u0019\u0005A1A\u0005\u0002q\nqBZ1jY&tw\r\u0015:pa\u0016\u0014H/\u001f\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001f\u0002!\u0019\f\u0017\u000e\\5oOB\u0013x\u000e]3sif\u0004\u0003bB$\u0001\u0005\u0004%\t\u0001S\u0001\u000egR\u0014\u0018N\\4MSR,'/\u00197\u0016\u0003%\u0003\"A\b&\n\u0005-{\"!D*ue&tw\rT5uKJ\fG\u000e\u0003\u0004N\u0001\u0001\u0006I!S\u0001\u000fgR\u0014\u0018N\\4MSR,'/\u00197!\u0001")
public class PatternComprehensionTest
extends SemanticFunSuite {
    private final NodePattern n = new NodePattern((Option)new Some((Object)this.variable("n")), (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, this.pos());
    private final NodePattern x = new NodePattern((Option)new Some((Object)this.variable("x")), (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, this.pos());
    private final RelationshipPattern r = new RelationshipPattern((Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, RelationshipPattern$.MODULE$.apply$default$6(), this.pos());
    private final RelationshipsPattern pattern = new RelationshipsPattern(new RelationshipChain((PatternElement)this.n(), this.r(), this.x(), this.pos()), this.pos());
    private final Property property = new Property((Expression)this.variable("x"), new PropertyKeyName("prop", this.pos()), this.pos());
    private final Property failingProperty = new Property((Expression)this.variable("missing"), new PropertyKeyName("prop", this.pos()), this.pos());
    private final StringLiteral stringLiteral = new StringLiteral("APA", this.pos());

    public NodePattern n() {
        return this.n;
    }

    public NodePattern x() {
        return this.x;
    }

    public RelationshipPattern r() {
        return this.r;
    }

    public RelationshipsPattern pattern() {
        return this.pattern;
    }

    public Property property() {
        return this.property;
    }

    public Property failingProperty() {
        return this.failingProperty;
    }

    public StringLiteral stringLiteral() {
        return this.stringLiteral;
    }

    public PatternComprehensionTest() {
        this.test("pattern comprehension on a property returns the expected type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.property(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)expression).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()).covariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pattern comprehension with literal string projection has correct type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)expression).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()).invariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("inner projection using missing identifier reports error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.failingProperty(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Variable `missing` not defined", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("inner filter using missing identifier reports error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)new Some((Object)this.$outer.failingProperty()), (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Variable `missing` not defined", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pattern can't reuse identifier with different type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticState semanticState = (SemanticState)SemanticState$.MODULE$.clean().declareVariable((LogicalVariable)this.$outer.variable("n"), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTBoolean()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)semanticState);
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: n already defined with conflicting type Boolean (expected Node)", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{this.$outer.pos()}))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

