/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;

public class NodesAndRelsSubGraph
implements SubGraph {
    private final Collection<Node> nodes;
    private final Collection<Relationship> rels;
    private final Transaction tx;
    private final Set<String> labels = new HashSet<String>(20);
    private final Set<String> types = new HashSet<String>(20);

    public NodesAndRelsSubGraph(Transaction tx, Collection<Node> nodes, Collection<Relationship> rels) {
        this(tx, nodes, rels, false);
    }

    public NodesAndRelsSubGraph(Transaction tx, Collection<Node> nodes, Collection<Relationship> rels, boolean rebind) {
        this.tx = tx;
        this.nodes = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            if (rebind) {
                node = Util.rebind(tx, node);
            }
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            this.nodes.add(node);
        }
        this.rels = new HashSet<Relationship>(rels.size());
        for (Relationship rel : rels) {
            if (rebind) {
                rel = Util.rebind(tx, rel);
            }
            this.rels.add(rel);
            this.types.add(rel.getType().name());
        }
    }

    @Override
    public ResourceIterable<Node> getNodes() {
        return org.neo4j.internal.helpers.collection.Iterables.asResourceIterable(this.nodes);
    }

    @Override
    public ResourceIterable<Relationship> getRelationships() {
        return org.neo4j.internal.helpers.collection.Iterables.asResourceIterable(this.rels);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.getDefinitions((schema, label) -> StreamSupport.stream(schema.getIndexes(label).spliterator(), false).filter(indexDefinition -> indexDefinition.getIndexType() != IndexType.VECTOR).toList(), (schema, type) -> StreamSupport.stream(schema.getIndexes(type).spliterator(), false).filter(indexDefinition -> indexDefinition.getIndexType() != IndexType.VECTOR).toList());
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        Comparator<ConstraintDefinition> comp = Comparator.comparing(ConstraintDefinition::getName);
        ArrayList<ConstraintDefinition> definitions = this.getDefinitions(Schema::getConstraints, Schema::getConstraints);
        definitions.sort(comp);
        return definitions;
    }

    private <T> ArrayList<T> getDefinitions(BiFunction<Schema, Label, Iterable<T>> nodeFunction, BiFunction<Schema, RelationshipType, Iterable<T>> relFunction) {
        Schema schema = this.tx.schema();
        ArrayList definitions = new ArrayList(this.labels.size() * 2);
        for (String label : this.labels) {
            Iterables.addAll(definitions, nodeFunction.apply(schema, Label.label((String)label)));
        }
        for (String type : this.types) {
            Iterables.addAll(definitions, relFunction.apply(schema, RelationshipType.withName((String)type)));
        }
        return definitions;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        if (!this.labels.contains(label.name())) {
            return Collections.emptyList();
        }
        return this.tx.schema().getConstraints(label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        if (!this.types.contains(type.name())) {
            return Collections.emptyList();
        }
        return this.tx.schema().getConstraints(type);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        if (!this.labels.contains(label.name())) {
            return Collections.emptyList();
        }
        return Util.getIndexes(this.tx, label);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(RelationshipType type) {
        if (!this.types.contains(type.name())) {
            return Collections.emptyList();
        }
        return Util.getIndexes(this.tx, type);
    }

    @Override
    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.types.stream().map(RelationshipType::withName).collect(Collectors.toSet());
    }

    @Override
    public Iterable<Label> getAllLabelsInUse() {
        return this.labels.stream().map(Label::label).collect(Collectors.toSet());
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type, Label end) {
        return this.rels.stream().filter(r -> {
            boolean matchType = r.getType().equals((Object)type);
            boolean matchStart = start != null ? r.getStartNode().hasLabel(start) : true;
            boolean matchEnd = end != null ? r.getEndNode().hasLabel(end) : true;
            return matchType && matchStart && matchEnd;
        }).count();
    }

    @Override
    public long countsForNode(Label label) {
        return this.nodes.stream().filter(n -> n.hasLabel(label)).count();
    }

    @Override
    public Iterator<Node> findNodes(Label label) {
        return this.nodes.stream().filter(n -> n.hasLabel(label)).iterator();
    }
}

