/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.export.util.ExportConfig;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.io.StringWriter;
import org.neo4j.procedure.Description;

public class ExportProgressInfo
implements ProgressInfo {
    public static final ExportProgressInfo EMPTY = new ExportProgressInfo(null, null, null);
    @Description(value="The name of the file to which the data was exported.")
    public final String file;
    @Description(value="A summary of the exported data.")
    public String source;
    @Description(value="The format the file is exported in.")
    public final String format;
    @Description(value="The number of exported nodes.")
    public long nodes;
    @Description(value="The number of exported relationships.")
    public long relationships;
    @Description(value="The number of exported properties.")
    public long properties;
    @Description(value="The duration of the export.")
    public long time;
    @Description(value="The number of rows returned.")
    public long rows;
    @Description(value="The size of the batches the export was run in.")
    public long batchSize = -1L;
    @Description(value="The number of batches the export was run in.")
    public long batches;
    @Description(value="Whether the export ran successfully.")
    public boolean done;
    @Description(value="The data returned by the export.")
    public Object data;

    public ExportProgressInfo(String file, String source, String format) {
        this.file = file;
        this.source = source;
        this.format = format;
    }

    public ExportProgressInfo(ExportProgressInfo pi) {
        this.file = pi.file;
        this.source = pi.source;
        this.format = pi.format;
        this.nodes = pi.nodes;
        this.relationships = pi.relationships;
        this.properties = pi.properties;
        this.time = pi.time;
        this.rows = pi.rows;
        this.batchSize = pi.batchSize;
        this.batches = pi.batches;
        this.done = pi.done;
    }

    public String toString() {
        return String.format("nodes = %d rels = %d properties = %d", this.nodes, this.relationships, this.properties);
    }

    @Override
    public ExportProgressInfo update(long nodes, long relationships, long properties) {
        this.nodes += nodes;
        this.relationships += relationships;
        this.properties += properties;
        return this;
    }

    @Override
    public ExportProgressInfo updateTime(long start) {
        this.time = System.currentTimeMillis() - start;
        return this;
    }

    @Override
    public ExportProgressInfo done(long start) {
        this.done = true;
        return this.updateTime(start);
    }

    @Override
    public void nextRow() {
        ++this.rows;
    }

    @Override
    public ExportProgressInfo drain(StringWriter writer, ExportConfig config) {
        if (writer != null) {
            this.data = Util.getStringOrCompressedData(writer, config);
        }
        return this;
    }

    @Override
    public void setBatches(long batches) {
        this.batches = batches;
    }

    @Override
    public void setRows(long rows) {
        this.rows = rows;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }
}

