/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import apoc.util.CollectionUtils;
import apoc.util.collection.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.TokenRead;

public interface SubGraph {
    public ResourceIterable<Node> getNodes();

    public ResourceIterable<Relationship> getRelationships();

    public Iterable<IndexDefinition> getIndexes();

    public Iterable<ConstraintDefinition> getConstraints();

    public Iterable<ConstraintDefinition> getConstraints(Label var1);

    public Iterable<ConstraintDefinition> getConstraints(RelationshipType var1);

    public Iterable<IndexDefinition> getIndexes(Label var1);

    public Iterable<IndexDefinition> getIndexes(RelationshipType var1);

    public Iterable<RelationshipType> getAllRelationshipTypesInUse();

    public Iterable<Label> getAllLabelsInUse();

    public Iterator<Node> findNodes(Label var1);

    default public Map<String, Integer> relTypesInUse(TokenRead ops, Collection<String> relTypeNames) {
        Stream<RelationshipType> stream = Iterables.stream(this.getAllRelationshipTypesInUse());
        if (CollectionUtils.isNotEmpty(relTypeNames)) {
            stream = stream.filter(rel -> relTypeNames.contains(rel.name()));
        }
        return stream.map(RelationshipType::name).collect(Collectors.toMap(t -> t, arg_0 -> ((TokenRead)ops).relationshipType(arg_0)));
    }

    default public Map<String, Integer> labelsInUse(TokenRead ops, Collection<String> labelNames) {
        Stream<Label> stream = Iterables.stream(this.getAllLabelsInUse());
        if (CollectionUtils.isNotEmpty(labelNames)) {
            stream = stream.filter(rel -> labelNames.contains(rel.name()));
        }
        return stream.map(Label::name).collect(Collectors.toMap(t -> t, arg_0 -> ((TokenRead)ops).nodeLabel(arg_0)));
    }

    public long countsForRelationship(Label var1, RelationshipType var2, Label var3);

    default public long countsForRelationship(RelationshipType type, Label end) {
        return this.countsForRelationship(null, type, end);
    }

    default public long countsForRelationship(Label start, RelationshipType type) {
        return this.countsForRelationship(start, type, null);
    }

    default public long countsForRelationship(RelationshipType type) {
        return this.countsForRelationship(null, type, null);
    }

    public long countsForNode(Label var1);
}

