/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.util.ExportFormat;
import apoc.util.CompressionConfig;
import apoc.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExportConfig
extends CompressionConfig {
    public static final String RELS_WITH_TYPE_KEY = "multipleRelationshipsWithType";
    public static final ExportConfig EMPTY = new ExportConfig(null);
    public static final char QUOTECHAR = '\"';
    public static final String NONE_QUOTES = "none";
    public static final String ALWAYS_QUOTES = "always";
    public static final String IF_NEEDED_QUUOTES = "ifNeeded";
    public static final int DEFAULT_BATCH_SIZE = 20000;
    private static final int DEFAULT_UNWIND_BATCH_SIZE = 20;
    public static final String DEFAULT_DELIM = ",";
    public static final String DEFAULT_ARRAY_DELIM = ";";
    public static final String DEFAULT_QUOTES = "always";
    private final boolean streamStatements;
    private final boolean ifNotExists;
    private final NodeConfig source;
    private final NodeConfig target;
    private int batchSize;
    private boolean multipleRelationshipsWithType;
    private boolean saveIndexNames;
    private boolean bulkImport;
    private boolean sampling;
    private String delim;
    private String quotes;
    private boolean useTypes;
    private Set<String> caption;
    private boolean writeNodeProperties;
    private boolean nodesOfRelationships;
    private ExportFormat format;
    private CypherFormat cypherFormat;
    private final Map<String, Object> config;
    private boolean separateHeader;
    private String arrayDelim;
    private Map<String, Object> optimizations;
    private OptimizationType optimizationType;
    private int unwindBatchSize;
    private long awaitForIndexes;
    private final Map<String, Object> samplingConfig;

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isBulkImport() {
        return this.bulkImport;
    }

    public char getDelimChar() {
        return this.delim.charAt(0);
    }

    public String isQuotes() {
        return this.quotes;
    }

    public boolean useTypes() {
        return this.useTypes;
    }

    public ExportFormat getFormat() {
        return this.format;
    }

    public Set<String> getCaption() {
        return this.caption;
    }

    public CypherFormat getCypherFormat() {
        return this.cypherFormat;
    }

    public boolean isMultipleRelationshipsWithType() {
        return this.multipleRelationshipsWithType;
    }

    public ExportConfig(Map<String, Object> config) {
        super(config);
        config = config != null ? config : Collections.emptyMap();
        this.saveIndexNames = Util.toBoolean(config.getOrDefault("saveIndexNames", false));
        this.delim = ExportConfig.delim(config.getOrDefault("delim", DEFAULT_DELIM).toString());
        this.arrayDelim = ExportConfig.delim(config.getOrDefault("arrayDelim", DEFAULT_ARRAY_DELIM).toString());
        this.useTypes = Util.toBoolean(config.get("useTypes"));
        this.caption = ExportConfig.convertCaption(config.getOrDefault("caption", Arrays.asList("name", "title", "label", "id")));
        this.nodesOfRelationships = Util.toBoolean(config.get("nodesOfRelationships"));
        this.bulkImport = Util.toBoolean(config.get("bulkImport"));
        this.separateHeader = Util.toBoolean(config.get("separateHeader"));
        this.format = ExportFormat.fromString((String)config.getOrDefault("format", "cypher-shell"));
        this.cypherFormat = CypherFormat.fromString((String)config.getOrDefault("cypherFormat", "create"));
        this.config = config;
        this.streamStatements = Util.toBoolean(config.get("streamStatements")) || Util.toBoolean(config.get("stream"));
        this.writeNodeProperties = Util.toBoolean(config.getOrDefault("writeNodeProperties", true));
        this.ifNotExists = Util.toBoolean(config.get("ifNotExists"));
        this.exportQuotes(config);
        this.optimizations = config.getOrDefault("useOptimizations", Collections.emptyMap());
        this.optimizationType = OptimizationType.valueOf(this.optimizations.getOrDefault("type", OptimizationType.UNWIND_BATCH.toString()).toString().toUpperCase());
        this.batchSize = ((Number)config.getOrDefault("batchSize", 20000)).intValue();
        this.sampling = Util.toBoolean(config.getOrDefault("sampling", false));
        this.samplingConfig = config.getOrDefault("samplingConfig", new HashMap());
        this.unwindBatchSize = ((Number)this.getOptimizations().getOrDefault("unwindBatchSize", 20)).intValue();
        this.awaitForIndexes = ((Number)config.getOrDefault("awaitForIndexes", 300)).longValue();
        this.multipleRelationshipsWithType = Util.toBoolean(config.get(RELS_WITH_TYPE_KEY));
        this.source = new NodeConfig((Map)config.get("source"));
        this.target = new NodeConfig((Map)config.get("target"));
        this.validate();
    }

    private void validate() {
        if (OptimizationType.UNWIND_BATCH_PARAMS.equals((Object)this.optimizationType) && !ExportFormat.CYPHER_SHELL.equals((Object)this.format)) {
            throw new RuntimeException("`useOptimizations: 'UNWIND_BATCH_PARAMS'` can be used only in combination with `format: 'CYPHER_SHELL' but got [format:`" + this.format + "]");
        }
        if (!OptimizationType.NONE.equals((Object)this.optimizationType) && this.unwindBatchSize > this.batchSize) {
            throw new RuntimeException("`unwindBatchSize` must be <= `batchSize`, but got [unwindBatchSize:" + this.unwindBatchSize + ", batchSize:" + this.batchSize + "]");
        }
    }

    private void exportQuotes(Map<String, Object> config) {
        try {
            this.quotes = (String)config.getOrDefault("quotes", "always");
            if (!(this.quotes.equals("always") || this.quotes.equals(NONE_QUOTES) || this.quotes.equals(IF_NEEDED_QUUOTES))) {
                throw new RuntimeException("The string value of the field quote is not valid");
            }
        }
        catch (ClassCastException e) {
            this.quotes = Util.toBoolean(config.get("quotes")) ? "always" : NONE_QUOTES;
        }
    }

    public boolean getRelsInBetween() {
        return this.nodesOfRelationships;
    }

    private static String delim(String value) {
        if (value.length() == 1) {
            return value;
        }
        if (value.contains("\\t")) {
            return String.valueOf('\t');
        }
        if (value.contains(" ")) {
            return " ";
        }
        throw new RuntimeException("Illegal delimiter '" + value + "'");
    }

    public String defaultRelationshipType() {
        return this.config.getOrDefault("defaultRelationshipType", "RELATED").toString();
    }

    public NodeConfig getSource() {
        return this.source;
    }

    public NodeConfig getTarget() {
        return this.target;
    }

    public boolean readLabels() {
        return Util.toBoolean(this.config.getOrDefault("readLabels", false));
    }

    public boolean storeNodeIds() {
        return Util.toBoolean(this.config.getOrDefault("storeNodeIds", false));
    }

    public boolean separateFiles() {
        return Util.toBoolean(this.config.getOrDefault("separateFiles", false));
    }

    private static Set<String> convertCaption(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new RuntimeException("Only array of Strings are allowed!");
        }
        List strings = (List)value;
        return new HashSet<String>(strings);
    }

    public boolean streamStatements() {
        return this.streamStatements;
    }

    public boolean writeNodeProperties() {
        return this.writeNodeProperties;
    }

    public long getTimeoutSeconds() {
        return Util.toLong(this.config.getOrDefault("timeoutSeconds", 100));
    }

    public int getUnwindBatchSize() {
        return this.unwindBatchSize;
    }

    public Map<String, Object> getOptimizations() {
        return this.optimizations;
    }

    public boolean isSeparateHeader() {
        return this.separateHeader;
    }

    public String getArrayDelim() {
        return this.arrayDelim;
    }

    public OptimizationType getOptimizationType() {
        return this.optimizationType;
    }

    public long getAwaitForIndexes() {
        return this.awaitForIndexes;
    }

    public Map<String, Object> getSamplingConfig() {
        return this.samplingConfig;
    }

    public boolean isSampling() {
        return this.sampling;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public boolean shouldSaveIndexNames() {
        return this.saveIndexNames;
    }

    public static enum OptimizationType {
        NONE,
        UNWIND_BATCH,
        UNWIND_BATCH_PARAMS;

    }

    public static class NodeConfig {
        public String label;
        public String id;

        public NodeConfig(Map<String, String> config) {
            config = config == null ? Collections.emptyMap() : config;
            this.label = config.get("label");
            this.id = config.get("id");
        }
    }
}

