/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.export.util.ExportConfig;
import apoc.util.FileUtils;
import inet.ipaddr.IPAddressString;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.security.WebURLAccessRule;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.util.Preconditions;

public class ApocConfig
extends LifecycleAdapter {
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    public static final String APOC_IMPORT_FILE_ENABLED = "apoc.import.file.enabled";
    public static final String APOC_EXPORT_FILE_ENABLED = "apoc.export.file.enabled";
    public static final String APOC_IMPORT_FILE_USE_NEO4J_CONFIG = "apoc.import.file.use_neo4j_config";
    public static final String APOC_TRIGGER_ENABLED = "apoc.trigger.enabled";
    public static final String APOC_IMPORT_FILE_ALLOW__READ__FROM__FILESYSTEM = "apoc.import.file.allow_read_from_filesystem";
    public static final String APOC_CONFIG_JOBS_SCHEDULED_NUM_THREADS = "apoc.jobs.scheduled.num_threads";
    public static final String APOC_CONFIG_JOBS_POOL_NUM_THREADS = "apoc.jobs.pool.num_threads";
    public static final String APOC_CONFIG_JOBS_QUEUE_SIZE = "apoc.jobs.queue.size";
    public static final String APOC_CONFIG_INITIALIZER = "apoc.initializer";
    public static final String LOAD_FROM_FILE_ERROR = "Import from files not enabled, please set apoc.import.file.enabled=true in your apoc.conf";
    public static final String APOC_MAX_DECOMPRESSION_RATIO = "apoc.max.decompression.ratio";
    public static final Integer DEFAULT_MAX_DECOMPRESSION_RATIO = 200;
    private static final WebURLAccessRule webAccessRule = new WebURLAccessRule();
    private static final Map<String, Object> configDefaultValues = Map.of("apoc.export.file.enabled", false, "apoc.import.file.enabled", false, "apoc.import.file.use_neo4j_config", true, "apoc.trigger.enabled", false);
    private static final List<Setting> NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES = new ArrayList<Setting>(Arrays.asList(GraphDatabaseSettings.data_directory, GraphDatabaseSettings.load_csv_file_url_root, GraphDatabaseSettings.logs_directory, GraphDatabaseSettings.plugin_dir, GraphDatabaseSettings.transaction_logs_root_path, BootloaderSettings.run_directory, BootloaderSettings.lib_directory, GraphDatabaseSettings.neo4j_home));
    private static final String DEFAULT_PATH = ".";
    private static final String CONFIG_DIR = "config-dir=";
    public static final String EXPORT_NOT_ENABLED_ERROR = "Export to files not enabled, please set apoc.export.file.enabled=true in your apoc.conf.";
    public static final String EXPORT_TO_FILE_ERROR = "Export to files not enabled, please set apoc.export.file.enabled=true in your apoc.conf.\nOtherwise, if you are running in a cloud environment without filesystem access, use the `{stream:true}` config and null as a 'file' parameter to stream the export back to your client.";
    private final Config neo4jConfig;
    private final Log log;
    private final DatabaseManagementService databaseManagementService;
    private Configuration config;
    private static ApocConfig theInstance;
    private GraphDatabaseService systemDb;
    private List<IPAddressString> blockedIpRanges = List.of();
    private boolean expandCommands;
    private Duration commandEvaluationTimeout;

    public ApocConfig(Config neo4jConfig, LogService log, GlobalProcedures globalProceduresRegistry, DatabaseManagementService databaseManagementService) {
        this.neo4jConfig = neo4jConfig;
        this.blockedIpRanges = (List)neo4jConfig.get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        this.commandEvaluationTimeout = (Duration)neo4jConfig.get(GraphDatabaseInternalSettings.config_command_evaluation_timeout);
        if (this.commandEvaluationTimeout == null) {
            this.commandEvaluationTimeout = (Duration)GraphDatabaseInternalSettings.config_command_evaluation_timeout.defaultValue();
        }
        this.expandCommands = neo4jConfig.expandCommands();
        this.log = log.getInternalLog(ApocConfig.class);
        this.databaseManagementService = databaseManagementService;
        theInstance = this;
        globalProceduresRegistry.registerComponent(((Object)((Object)this)).getClass(), ctx -> this, true);
        this.log.info("successfully registered ApocConfig for @Context");
    }

    public ApocConfig(Config neo4jConfig) {
        this.neo4jConfig = neo4jConfig;
        if (neo4jConfig != null) {
            this.blockedIpRanges = (List)neo4jConfig.get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        }
        this.log = NullLog.getInstance();
        this.databaseManagementService = null;
        theInstance = this;
        this.config = new PropertiesConfiguration();
    }

    public Configuration getConfig() {
        return this.config;
    }

    private String evaluateIfCommand(String settingName, String entry) {
        if (Config.isCommand((String)entry)) {
            Preconditions.checkArgument((boolean)this.expandCommands, (String)String.format("%s is a command, but config is not explicitly told to expand it. (Missing --expand-commands argument?)", entry));
            String str = entry.trim();
            String command = str.substring(2, str.length() - 1);
            this.log.info("Executing external script to retrieve value of setting " + settingName);
            return ProcessUtils.executeCommandWithOutput((String)command, (Duration)this.commandEvaluationTimeout);
        }
        return entry;
    }

    public void init() {
        this.log.debug("called init");
        String neo4jConfFolder = System.getenv().getOrDefault("NEO4J_CONF", this.determineNeo4jConfFolder());
        System.setProperty("NEO4J_CONF", neo4jConfFolder);
        this.log.info("system property NEO4J_CONF set to %s", new Object[]{neo4jConfFolder});
        File apocConfFile = new File(neo4jConfFolder + "/apoc.conf");
        if (apocConfFile.exists() && this.expandCommands) {
            Config.Builder.validateFilePermissionForCommandExpansion(List.of(apocConfFile.toPath()));
        }
        this.loadConfiguration();
    }

    protected String determineNeo4jConfFolder() {
        String command = System.getProperty(SUN_JAVA_COMMAND);
        if (command == null) {
            this.log.warn("system property %s is not set, assuming '.' as conf dir. This might cause `apoc.conf` not getting loaded.", new Object[]{SUN_JAVA_COMMAND});
            return DEFAULT_PATH;
        }
        String neo4jConfFolder = Stream.of(command.split("--")).map(String::trim).filter(s -> s.startsWith(CONFIG_DIR)).map(s -> s.substring(CONFIG_DIR.length())).findFirst().orElse(DEFAULT_PATH);
        if (DEFAULT_PATH.equals(neo4jConfFolder)) {
            this.log.info("cannot determine conf folder from sys property %s, assuming '.' ", new Object[]{command});
        } else {
            this.log.info("from system properties: NEO4J_CONF=%s", new Object[]{neo4jConfFolder});
        }
        return neo4jConfFolder;
    }

    protected void loadConfiguration() {
        try {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("apoc-config.xml");
            this.log.info("loading apoc meta config from %s", new Object[]{resource.toString()});
            CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder().configure(new BuilderParameters[]{(BuilderParameters)new Parameters().fileBased().setURL(resource)});
            this.config = (Configuration)builder.getConfiguration();
            this.config.getKeys().forEachRemaining(configKey -> this.config.setProperty(configKey, (Object)this.evaluateIfCommand((String)configKey, this.config.getProperty(configKey).toString())));
            configDefaultValues.forEach((k, v) -> {
                if (!this.config.containsKey(k)) {
                    this.config.setProperty(k, v);
                    this.log.info("setting APOC config to default value: " + k + "=" + v);
                }
            });
            this.addDbmsDirectoriesMetricsSettings();
            for (Setting s : NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES) {
                Object value = this.neo4jConfig.get(s);
                if (value == null) continue;
                this.config.setProperty(s.name(), (Object)value.toString());
            }
            if (!this.config.containsKey(APOC_MAX_DECOMPRESSION_RATIO)) {
                this.config.setProperty(APOC_MAX_DECOMPRESSION_RATIO, (Object)DEFAULT_MAX_DECOMPRESSION_RATIO);
            }
            if (this.config.getInt(APOC_MAX_DECOMPRESSION_RATIO) == 0) {
                throw new IllegalArgumentException(String.format("value 0 is not allowed for the config option %s", APOC_MAX_DECOMPRESSION_RATIO));
            }
            boolean allowFileUrls = (Boolean)this.neo4jConfig.get(GraphDatabaseSettings.allow_file_urls);
            this.config.setProperty(APOC_IMPORT_FILE_ALLOW__READ__FROM__FILESYSTEM, (Object)allowFileUrls);
            Setting db_temporal_timezone = GraphDatabaseSettings.db_temporal_timezone;
            this.config.setProperty(db_temporal_timezone.name(), this.neo4jConfig.get(db_temporal_timezone));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDbmsDirectoriesMetricsSettings() {
        try {
            Class<?> metricsSettingsClass = Class.forName("com.neo4j.kernel.impl.enterprise.configuration.MetricsSettings");
            Field csvPathField = metricsSettingsClass.getDeclaredField("csvPath");
            Setting dbms_directories_metrics = (Setting)csvPathField.get(null);
            NEO4J_DIRECTORY_CONFIGURATION_SETTING_NAMES.add(dbms_directories_metrics);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public GraphDatabaseService getSystemDb() {
        if (this.systemDb == null) {
            try {
                this.systemDb = this.databaseManagementService.database("system");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.systemDb;
    }

    public void isImportFileEnabled() {
        if (!this.config.getBoolean(APOC_IMPORT_FILE_ENABLED)) {
            throw new RuntimeException(LOAD_FROM_FILE_ERROR);
        }
    }

    public URL checkAllowedUrlAndPinToIP(String url) throws IOException {
        try {
            URL parsedUrl = new URL(url);
            if (this.blockedIpRanges != null && !this.blockedIpRanges.isEmpty()) {
                return webAccessRule.checkNotBlockedAndPinToIP(parsedUrl, this.blockedIpRanges);
            }
            return parsedUrl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void checkReadAllowed(String url) throws IOException {
        if (FileUtils.isFile(url)) {
            this.isImportFileEnabled();
        } else {
            this.checkAllowedUrlAndPinToIP(url);
        }
    }

    public void checkWriteAllowed(ExportConfig exportConfig, String fileName) {
        if (!(this.config.getBoolean(APOC_EXPORT_FILE_ENABLED) || exportConfig != null && (fileName == null || fileName.equals("")) && exportConfig.streamStatements())) {
            throw new RuntimeException(EXPORT_TO_FILE_ERROR);
        }
    }

    public void checkStorageEngine() {
        List<String> supportedTypes = Arrays.asList("standard", "aligned", "high_limit");
        if (!supportedTypes.contains(this.neo4jConfig.get(GraphDatabaseSettings.db_format))) {
            throw new RuntimeException("Record engine type unsupported; please use one of the following; standard, aligned or high_limit");
        }
    }

    public static ApocConfig apocConfig() {
        return theInstance;
    }

    public String getString(String key) {
        return this.getConfig().getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getConfig().getString(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.getConfig().setProperty(key, value);
    }

    public boolean getBoolean(String key) {
        return this.getConfig().getBoolean(key);
    }

    public boolean isImportFolderConfigured() {
        String importFolder = this.getImportDir();
        if (importFolder == null) {
            return false;
        }
        return !"/target/test data/neo4j".equals(importFolder);
    }

    public String getImportDir() {
        return ApocConfig.apocConfig().getString("server.directories.import");
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getConfig().getInt(key, defaultValue);
        }
        catch (ConversionException e) {
            Object o = this.getConfig().getProperty(key);
            if (o instanceof Duration) {
                return (int)((Duration)o).getSeconds();
            }
            throw new IllegalArgumentException("don't know how to convert for config option " + key, e);
        }
    }
}

